package jp.agentec.abook.abv.ui.home.activity;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.webkit.JavascriptInterface;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.handmark.pulltorefresh.library.PullToRefreshBase;

import org.json.adf.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import jp.agentec.abook.abv.bl.acms.type.AcmsApis;
import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.abook.abv.bl.acms.type.OperationType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.Constant.ReportType;
import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.download.ContentFileExtractor;
import jp.agentec.abook.abv.bl.download.ContentZipDownloadNotification;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.OperationContentDto;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterDto;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.OperationLocationType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.common.view.ABVBatchSyncView;
import jp.agentec.abook.abv.ui.common.view.ABVListDialog;
import jp.agentec.abook.abv.ui.common.view.ABVPopupListWindow;
import jp.agentec.abook.abv.ui.home.adapter.HierarchyOperationGroupListAdapter;
import jp.agentec.abook.abv.ui.home.helper.ABookPermissionHelper;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.home.helper.HomeOperationListHelper;
import jp.agentec.abook.abv.ui.home.helper.OperationGroupMasterListHelper;
import jp.agentec.abook.abv.ui.home.helper.OperationListHelper;
import jp.agentec.abook.abv.ui.viewer.activity.DeviceImageListActivity;
import jp.agentec.abook.abv.ui.viewer.activity.OnlineHTMLWebViewActivity;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;


/**
 * Created by leej on 2018/08/17
 */
public class OperationListActivity extends ABVUIActivity {
    private static final String TAG = "OperationListActivity";

    private WebView mCheckWebView;

    private final String OPERATION_LIST_PAGE = "file:///android_asset/check/app/index.html?";
    private JsInf jsInf = new JsInf();

    // 検索画面の条件（文字列）
    public String mSearchWord;                                      // 検索画面の値（作業名）
    public String mStartDateStr;                                    // 検索画面の値（作業開始日）
    public String mEndDateStr;                                      // 検索画面の値（作業終了日）
    public int sortType = 2;
    public boolean isSearch = false;
    public int mOperationGroupMasterId = 0;
    boolean firstFlg = true;
    private EditText mSearchTextView;                              // 検索画面の作業名
    private TextView mStartDate;                                    // 検索画面の作業開始日
    private TextView mEndDate;                                      // 検索画面の作業終了日

    private Dialog mSearchDialog;

    private boolean activityResultFlg;

    private OperationListHelper mListHelper = null;

    private ABVListDialog mShowDialog;

    private Map<Integer, Integer> operationCountMap;
    // 全て・作業種別のセグメントボタン
    private RadioGroup mLocationTypeRadioGroup;

    // 作業種別のサービスオプション値を保持用フラグ
    private boolean mOperationGroupMasterServiceOperationFlg;

    //シーン画像選択画面からベース画像登録後に閉じたときに処理追加のため、
    private static final int SUB_DIVICE_IMAGE_LIST_ACTIVITY = 1001;

    private Long mSelectedOperationId;

    private Integer mScanType;

    //redirect page
    private String directPage;
    private String backPage;
    private String directTaskKey;
    private String directPhaseNo;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        //setContentView(R.layout.ac_operation_list);

        setContentView(R.layout.chat_webview);

        mCheckWebView = findViewById(R.id.chatWebview);
        mCheckWebView.setOverScrollMode(View.OVER_SCROLL_NEVER);  //オーバースクロールしない。
        mCheckWebView.setVerticalScrollBarEnabled(false); //スクロールバーを消す。
        mCheckWebView.addJavascriptInterface(jsInf, "android");
        mCheckWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                //fix FileUriExposedException error when webview load url with file://
//                if (Uri.parse(url).getScheme().equals("file")) {
//                    view.loadUrl(url);
//                    return true;
//                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        if (Logger.isDebugEnabled()) {
            mCheckWebView.setWebContentsDebuggingEnabled(true);
        }
        WebSettings settings = mCheckWebView.getSettings();
        settings.setJavaScriptEnabled(true); //Javascriptを有効にする。
        settings.setCacheMode(WebSettings.LOAD_DEFAULT);

        settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setAllowFileAccess(true);
        settings.setUseWideViewPort(true);
        settings.setAllowContentAccess(true);
        settings.setAllowFileAccessFromFileURLs(true);
        settings.setSaveFormData(false);
        settings.setAllowUniversalAccessFromFileURLs(true);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("debug=1");
        paramList.add("app=android");
        paramList.add("lang=" + ActivityHandlingHelper.getInstance().getLocaleFileName());
        paramList.add("mobile_flg=" + (isNormalSize() ? "1" : "0"));
        paramList.add("isRFIDBarcodeScan=" + (ABVDataCache.getInstance().serviceOption.isUsableRFIDBarcodeScan() ? "1" : "0"));
        paramList.add("isOperationGroupMaster=" + (ABVDataCache.getInstance().serviceOption.isOperationGroupMaster() ? "1" : "0"));
        paramList.add("isChat=" + (ABVDataCache.getInstance().serviceOption.isChat() ? "1" : "0"));
        mCheckWebView.postUrl(OPERATION_LIST_PAGE + StringUtil.join("&", paramList), null);
        mListHelper = getListHelper();
        updateNeedSyncRoutineOperation();

        // サービスオプション(作業種別使用)をセット
        mOperationGroupMasterServiceOperationFlg = ABVDataCache.getInstance().serviceOption.isOperationGroupMaster();

        if (!StringUtil.isNullOrEmpty(getIntent().getStringExtra(AppDefType.PushMessageKey.operationId))) {
            final long operationId = Long.parseLong(getIntent().getStringExtra(AppDefType.PushMessageKey.operationId));
            String message = getIntent().getStringExtra(AppDefType.PushMessageKey.message);
            if (operationId < 1) { return; }

            final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(this, getRString(R.string.app_name), message);
            // リソースパターンの適用
            alertDialog.setPositiveButton(PatternStringUtil.patternToInt(
                    getApplicationContext(),
                    R.string.work_report,
                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)
                    ),
                    new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int whichButton) {
                            if (contentRefresher.isRefreshing()) {
                                // リソースパターンの適用
                                ErrorMessage.showErrorMessageToast(
                                        OperationListActivity.this,
                                        PatternStringUtil.patternToInt(
                                                getApplicationContext(),
                                                R.string.msg_routineTask_report_disable_refreshing,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)
                                        )
                                );
                            } else if(ActivityHandlingHelper.getInstance().isMeetingConnected()) {
                                // リソースパターンの適用
                                ErrorMessage.showErrorMessageToast(
                                        OperationListActivity.this,
                                        PatternStringUtil.patternToInt(
                                                getApplicationContext(),
                                                R.string.msg_routineTask_report_disable_meeting_room,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)
                                        )
                                );
                            } else if (isShowingBatchSync()) {
                                // 一括同期中は移動しない
                                ErrorMessage.showErrorMessageToast(
                                        OperationListActivity.this,
                                        getString(R.string.msg_batch_sync_move_operation_view)
                                );
                            } else {
                                OperationDto operationDto = mOperationLogic.getOperation(operationId);

                                if (operationDto == null) {
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(
                                            OperationListActivity.this,
                                            PatternStringUtil.patternToInt(
                                                    getApplicationContext(),
                                                    R.string.msg_routineTask_report_disable_no_operation,
                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)
                                            )
                                    );
                                } else  if (operationDto.needSyncFlg) {
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(
                                            OperationListActivity.this,
                                            PatternStringUtil.patternToInt(
                                                    getApplicationContext(),
                                                    R.string.msg_routineTask_report_disable_not_updated,
                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)
                                            )
                                    );
                                } else {
                                    startTaskDirectionOrReportView(operationDto);
                                }
                            }

                            dialog.dismiss();
                        }
                    }
            );

            alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int whichButton) {
                    dialog.dismiss();
                }
            });

            alertDialog.show();

        }
    }

    private class JsInf {
        @JavascriptInterface
        public void sendParam(String param) {
            JSONObject jsonParam = new JSONObject(param);
            OperationDto operationDto;
            if (jsonParam.has(ABookKeys.CMD)) {
                switch (jsonParam.getString(ABookKeys.CMD)){
                    case ABookKeys.CMD_KEY.GO_SETTING:
                        showSetting();
                        break;

                    case ABookKeys.CMD_KEY.GO_RELATION_CONTENT:
                        showCommonContent();
                        break;

                    case ABookKeys.CMD_KEY.GO_PRINT_TARGET:
                        showPrintTargetSelect();
                        break;

                    case ABookKeys.CMD_KEY.GO_OPERATION:
                        if (!jsonParam.has(ABookKeys.OPERATION_ID)) {
                            break;
                        }
                        if (jsonParam.has(ABookKeys.SCAN_TYPE)) {
                            mScanType = jsonParam.getInt(ABookKeys.SCAN_TYPE);
                        }
                        directPage = null;
                        if (jsonParam.has(ABookKeys.GO_OPERATION_KEY.DIRECT_PAGE)
                                && !jsonParam.isNull(ABookKeys.GO_OPERATION_KEY.DIRECT_PAGE)) {
                            directPage = jsonParam.getString(ABookKeys.GO_OPERATION_KEY.DIRECT_PAGE);
                        }
                        backPage = null;
                        if (jsonParam.has(ABookKeys.GO_OPERATION_KEY.BACK_PAGE)
                                && !jsonParam.isNull(ABookKeys.GO_OPERATION_KEY.BACK_PAGE)) {
                            backPage = jsonParam.getString(ABookKeys.GO_OPERATION_KEY.BACK_PAGE);
                        }
                        directTaskKey = null;
                        if (jsonParam.has(ABookKeys.GO_OPERATION_KEY.DIRECT_TASK_KEY)
                                && !jsonParam.isNull(ABookKeys.GO_OPERATION_KEY.DIRECT_TASK_KEY)) {
                            directTaskKey = jsonParam.getString(ABookKeys.GO_OPERATION_KEY.DIRECT_TASK_KEY);
                        }
                        directPhaseNo = null;
                        if (jsonParam.has(ABookKeys.GO_OPERATION_KEY.DIRECT_PHASE_NO)
                                && !jsonParam.isNull(ABookKeys.GO_OPERATION_KEY.DIRECT_PHASE_NO)) {
                            directPhaseNo = jsonParam.getString(ABookKeys.GO_OPERATION_KEY.DIRECT_PHASE_NO);
                        }
                        final OperationDto tempOperationDto = mOperationDao.getOperationJoinContent(jsonParam.getInt(ABookKeys.OPERATION_ID));
                        if (tempOperationDto.operationType == Constant.operationType.CONTENT360
                                && tempOperationDto.contentId == null) {
                            tempOperationDto.operationId = jsonParam.getLong(ABookKeys.OPERATION_ID);
                            showPanoEntryDialog(tempOperationDto);
                        } else {
                            if (tempOperationDto.needSyncFlg) {
                                mCallBack = new Runnable() {
                                    @Override
                                    public void run() {
                                        CommonExecutor.execute(new Runnable() {
                                            @Override
                                            public void run() {

                                                openReportView(tempOperationDto);
                                            }
                                        });
                                    }
                                };
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        startSyncOperation(tempOperationDto);
                                    }
                                });
                            } else {
                                openReportView(tempOperationDto);
                            }
                        }
                        break;

                    case ABookKeys.CMD_KEY.GO_COMMUNICATION:
                        showCommunicationMenuDialog();
                        break;

                    case ABookKeys.CMD_KEY.GO_PANORAMA_EDIT:
                        final OperationDto panoramaOperationDto = mOperationDao.getOperationJoinContent(jsonParam.getInt(ABookKeys.OPERATION_ID));
                        if (panoramaOperationDto.contentId != null && panoramaOperationDto.contentId != 0) {
                            if (panoramaOperationDto.needSyncFlg) {
                                mCallBack = new Runnable() {
                                    @Override
                                    public void run() {
                                        startPanoEdit(panoramaOperationDto);
                                    }
                                };
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        startSyncOperation(panoramaOperationDto);
                                    }
                                });
                            } else {
                                startPanoEdit(panoramaOperationDto);
                            }
                        }else {
                            panoramaOperationDto.operationId = jsonParam.getLong(ABookKeys.OPERATION_ID);
                            showPanoEntryDialog(panoramaOperationDto);
                        }
                        break;

                    case ABookKeys.CMD_KEY.REFRESH_CONTENT:
                        dateUpdate();
                        break;

                    case ABookKeys.CMD_KEY.CHANGE_OPERATION_GROUP_MASTER:
                        clearSearch();
                        List<OperationDto>operationList = mOperationGroupMasterLogic.getOperationByOperationGroupMasterId(jsonParam.getInt(ABookKeys.OPERATION_GROUPMASTER_ID), null);
                        mOperationLogic.createOperationListJson(operationList, null);
                        break;

                    case ABookKeys.CMD_KEY.RESET_SEARCH:
                        clearSearch();
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                mCheckWebView.loadUrl("javascript:CHK.initReportApp();");
                            }
                        });
                        break;
                    case ABookKeys.CMD_KEY.SAVE_JSON:
                        if (jsonParam.has(ABookKeys.JSON_NAME)) {
                            saveJson(jsonParam.getString(ABookKeys.JSON_NAME), jsonParam.getString(ABookKeys.JSON_DATA));
                        }
                        break;
                    case ABookKeys.CMD_KEY.GO_SEND_MESSAGE:
                        showSendMessage();
                        break;
                    case ABookKeys.CMD_KEY.GO_DISTANCE_SUPPORT:
                        showDistanceSupport();
                        break;
                    case ABookKeys.CMD_KEY.GO_CHAT:
                        showChat();
                        break;
                    case ABookKeys.CMD_KEY.ACTION_PUSH_MESSAGE:
                        if (jsonParam.has(ABookKeys.PUSH_MESSAGE_ID)) {
                            actionPushMessage(jsonParam.getString(ABookKeys.PUSH_MESSAGE_ACTION), jsonParam.getInt(ABookKeys.PUSH_MESSAGE_ID));
                        }
                        break;
                }
            }
        }

        @JavascriptInterface
        public String getCachePath() {
            return getCacheDir().getAbsolutePath();
        }

        @JavascriptInterface
        public String searchOperationList(String searchKeyword, String searchStartDate, String searchEndDate, int operationGroupMasterId) {
            mSearchWord = searchKeyword;
            mStartDateStr = searchStartDate;
            mEndDateStr = searchEndDate;
            List<OperationDto> operationList;
            if (operationGroupMasterId != 0) {
                mOperationGroupMasterId = operationGroupMasterId;
            }
            operationList = mListHelper.filterOperationList();
            String searchOperationListStr = mOperationLogic.createOperationListJson(operationList, null);
            isSearch = true;
            return searchOperationListStr;
        }

        @JavascriptInterface
        public void startScan() {
            //TODO ConnectScanner
        }

        @JavascriptInterface
        public void stopScan() {
            //TODO DisconnectScanner
        }

        @JavascriptInterface
        public void setSortType(int requestSortType) {
            sortType = requestSortType;
        }

        @JavascriptInterface
        public int getSortType() {
            return sortType;
        }

        @JavascriptInterface
        public void testScanResult(String code, int scanType) {
            onScanned(code, scanType);
        }

        @JavascriptInterface
        public void showLoading() {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    showProgressPopup();
                }
            });
        }

        @JavascriptInterface
        public void hideLoading() {
            if (!contentRefresher.isRefreshing()) {
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        closeProgressPopup();
                    }
                });
            }
        }
    }

    //TODO Method called when code is scanned
    public void onScanned(final String code, final int scanType) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mCheckWebView.loadUrl("javascript:CHK.scanResult(" + code + "," +  scanType + " );");
            }
        });
    }

    // 共通資料画面表示
    private void showCommonContent() {
        Intent intent = new Intent();
        intent.setClass(OperationListActivity.this, OperationRelatedContentActivity.class);
        intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, OperationListActivity.class.getName());
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent, NaviConsts.Right);
    }

    // 簡易帳票印刷対象選択画面表示
    private void showPrintTargetSelect() {
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showDisConnectNetworkDialog();
            return;
        }
        Intent intent = new Intent();
        intent.setClass(OperationListActivity.this, OnlineHTMLWebViewActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        intent.putExtra("LINKURL", AcmsApis.getApiUrl(ABVEnvironment.getInstance().acmsAddress, ABVDataCache.getInstance().getUrlPath(), AcmsApis.ApiQuickReportSearch));
        startActivity(intent, NaviConsts.Right);
    }

    // 検索ワードのクリア
    private void clearSearch() {
        mSearchWord = null;
        mStartDateStr = null;
        mEndDateStr = null;
        mOperationGroupMasterId = 0;
        isSearch = false;
        sortType = 2;
        //clearData();
    }

    // 検索済みかどうかチェック
    private boolean isSearched() {
        return !(StringUtil.isNullOrEmpty(mSearchWord) && StringUtil.isNullOrEmpty(mStartDateStr) && StringUtil.isNullOrEmpty(mEndDateStr));
    }


    /**
     * ビューを作り直す。
     */
    public void setOperationListView() {
        mListHelper = getListHelper();
        screenRefresh();
    }


    @Override
    public void onRefreshedContent(final boolean result, long contentId, Exception e) {
        super.onRefreshedContent(result, contentId, e);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!contentRefresher.isRefreshing()) {
                    // 新着処理が終わったら以下の処理が実行
                    stopUpdateAnimation();
                    // 新着更新時間の更新
                    getABVUIDataCache().saveLastUpdateTime();
                    // リソースパターンを取得し、ローカルに保存する。
                    setResourcePattern();
                    // 絞り検索マスタデータ最新更新する時fetchDateをローカルに保存する。
                    setApertureMasterDataFetchDate();
                    
                    if (mOperationGroupMasterServiceOperationFlg != ABVDataCache.getInstance().serviceOption.isOperationGroupMaster()) {
                        // 初期化
                        getABVUIDataCache().clearOperationGroupMaster();
                        mOperationGroupMasterServiceOperationFlg = ABVDataCache.getInstance().serviceOption.isOperationGroupMaster();
                        // ビューを作り直す
                    }
                    screenRefresh();
                }
            }
        });
    }

    // 回転時、画面リロード
   @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        // 画面リロード
        setOperationListView();
    }

    @Override
    public void onResume() {
        Logger.i(TAG, "onResume:start");
        super.onResume();

        if (isSearch) {
            isSearch = false;
            return;
        }

        //アプリロック状態の場合、何もしない。
        if (checkForceLoginPeriodically()) {
            return;
        }
        if (isShowingBatchSync()) {
            // 一括同期中の場合何もしない
            return;
        }

        screenRefresh();

        // プッシュメッセージがある場合の処理
        //一度チャットルームを開いたのかチェックし、開いたらい何もしない
        if (getABVUIDataCache().isChatPushMessageOpenOperationList) {
            if (goChatRoom(getIntent(), ChatWebViewActivity.class.getName(), OperationListActivity.class.getName())) {
                getABVUIDataCache().isChatPushMessageOpenOperationList = false;
                return;
            }
        }

        // 報告画面から作業一覧へ戻った時の同期処理
        final long operationId = getUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, -1L);

        if (operationId == -1) {
            if (firstFlg) {
                dateUpdate();
                firstFlg = false;
            }
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        createJsonForOperationList(getCacheDir().getAbsolutePath());
                        //closeProgressPopup();
                    } catch (Exception e) {
                        Logger.d("Update error");
                    }
                }
            });
        } else {
            //作業報告した後、戻った時に自動同期を開始
            final OperationDto operationDto = mOperationLogic.getOperation(operationId);
            if (operationDto != null && operationDto.needSyncFlg) {
                if (ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
                    mCallBack = new Runnable() {
                        @Override
                        public void run() {
                            //同期終了後、新着更新
                            if (!contentRefresher.isRefreshing()) {
                                dateUpdate();
                            }
                        }
                    };
                    //すぐ同期処理を開始すると、プログレスバー表示されないため、0.5秒後に実行
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            startSyncOperationStart(operationDto, false);
                        }
                    }, 500);
                }
            }

        }

        if (!activityResultFlg && operationId == -1) {
            //dataRefresh(true);
        }
        putUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, -1L);
        activityResultFlg = false;
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String activeTab = intent.getStringExtra("activeTab");
        if (mCheckWebView != null && activeTab != null) {
            String jsUrl = null;
            if (activeTab.contentEquals("dashboard")) {
                jsUrl = "javascript:CHK_Footer.goDashboard();";
            } else if (activeTab.contentEquals("operationList")) {
                jsUrl = "javascript:CHK_Footer.goOperationList();";
            }
            if (jsUrl != null) {
                final String url = jsUrl;
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        mCheckWebView.loadUrl(url);
                    }
                });
            }
        }
    }

    // 検索ダイアログ表示
    private void showSearchDialog() {
        contentRefresher.stopRefresh();
        if (mSearchDialog == null) {
            mSearchDialog = new Dialog(this);
            mSearchDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            mSearchDialog.setCanceledOnTouchOutside(false);
            mSearchDialog.setContentView(R.layout.operation_search_dialog);
        }

        mStartDate = (TextView) mSearchDialog.findViewById(R.id.start_date);

        mEndDate = (TextView) mSearchDialog.findViewById(R.id.end_date);

        // 検索ダイアログ画面の作業名要素
        mSearchTextView = (EditText) mSearchDialog.findViewById(R.id.operation_name);
        mSearchTextView.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN && keyCode == KeyEvent.KEYCODE_ENTER) {
                    //キーボードのエンターキーを無効にする
                    return true;
                }
                return false;
            }
        });

        mStartDate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showDatePicker(mStartDate);
            }
        });

        mEndDate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showDatePicker(mEndDate);
            }
        });

        // クリアボタン
        mSearchDialog.findViewById(R.id.btn_clear).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // 初期化
                clearData();
            }
        });

        // 検索ボタン
        mSearchDialog.findViewById(R.id.btn_search).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                mSearchWord = StringUtil.toString(mSearchTextView.getText());
                mStartDateStr = StringUtil.toString(mStartDate.getText());
                mEndDateStr = StringUtil.toString(mEndDate.getText());

                screenRefresh();
                mSearchDialog.dismiss();

                // 検索条件に条件がある場合のみ、件数のトーストメッセージは表示する
                if (isSearched()) {
                    // リソースパターンの適用
                    ABVToastUtil.showMakeText(OperationListActivity.this, String.format(PatternStringUtil.patternToString(getApplicationContext(),
                            R.string.operation_search_count,
                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), mListHelper.getOperationCount() + ""), Toast.LENGTH_SHORT);
                }
            }
        });

        // 閉じるボタン
        mSearchDialog.findViewById(R.id.closeBtn).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                mSearchDialog.dismiss();
            }
        });
        if (mSearchDialog != null) {
            mSearchDialog.show();
        }
    }

    private void showDatePicker(final TextView text) {
        String textViewStr = text.getText().toString();
        Calendar calendar = Calendar.getInstance();
        if (!textViewStr.isEmpty()) {
            calendar.setTime(DateTimeUtil.toDate(textViewStr, DateTimeFormat.yyyyMMdd_slash));
        }
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        int day = calendar.get(Calendar.DAY_OF_MONTH);

        final DatePickerDialog dpd = new DatePickerDialog(this, android.R.style.Theme_Holo_Light_Dialog, new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                String date = String.format("%4d/%02d/%02d", year, monthOfYear + 1, dayOfMonth);
                if (dateValidation(text, date)) {
                    text.setText(date);
                }
            }

        }, year, month, day);
        dpd.setButton(DialogInterface.BUTTON_POSITIVE, getString(R.string.complete), dpd);
        dpd.setButton(DialogInterface.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), dpd);
        dpd.setButton(DialogInterface.BUTTON_NEUTRAL, getString(R.string.clear), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int whichButton) {
                text.setText(StringUtil.Empty);
            }
        });
        dpd.setCanceledOnTouchOutside(false);
        dpd.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dpd.show();
    }

    private void clearData() {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mCheckWebView.loadUrl("javascript:$('#searchTaskName').val('');");
                mCheckWebView.loadUrl("javascript:$('#searchStartDate').val('');");
                mCheckWebView.loadUrl("javascript:$('#searchEndDate').val('');");
                mCheckWebView.loadUrl("javascript:$('.sort-type').removeClass('active');");
                mCheckWebView.loadUrl("javascript:$('#defaultSort').addClass('active');");
            }
        });
    }

    // 開始日と終了日のバリデーション
    private boolean dateValidation(TextView textView, String targetDateStr) {
        boolean result = true;
        Date startDate = null;
        Date endDate = null;
        if (textView.equals(mStartDate)) {
            // 選択したTextViewを開始日と見做す
            if (!StringUtil.isNullOrEmpty(mEndDate.getText().toString())) {
                startDate = DateTimeUtil.toDate(targetDateStr, "UTC", DateTimeFormat.yyyyMMdd_hyphen);
                endDate = DateTimeUtil.toDate(mEndDate.getText().toString(), "UTC", DateTimeFormat.yyyyMMdd_hyphen);
            }
        } else {
            // 選択したTextViewが終了日と見做す
            if (!StringUtil.isNullOrEmpty(mStartDate.getText().toString())) {
                startDate = DateTimeUtil.toDate(mStartDate.getText().toString(), "UTC", DateTimeFormat.yyyyMMdd_hyphen);
                endDate = DateTimeUtil.toDate(targetDateStr, "UTC", DateTimeFormat.yyyyMMdd_hyphen);
            }
        }
        if (startDate != null && endDate != null) {
            if (startDate.after(endDate)) {
                // リソースパターンの適用
                ABVToastUtil.showMakeText(OperationListActivity.this, PatternStringUtil.patternToString(getApplicationContext(),
                                                                                R.string.msg_date_validation,
                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
                result = false;
            }
        }
        return result;
    }

    public void startTaskDirectionOrReportView(final OperationDto operationDto) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                showProgressPopup();
            }
        });
        try {
            ContentDto contentDto = contentDao.getContent(operationDto.contentId);
            if (contentDto != null && contentDto.downloadedFlg) {
                String contentPath;
                if (operationDto.operationType == OperationType.LIST) {
                    contentPath = ABVEnvironment.getInstance().getTaskListDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                    if (operationDto.reportType == ReportType.ReportContinuous) {
                        contentPath = ABVEnvironment.getInstance().getProcessListDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                    }
                } else if (operationDto.operationType == OperationType.PDF) {
                    contentPath = ABVEnvironment.getInstance().getTaskPdfDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                    if (operationDto.reportType == ReportType.ReportContinuous) {
                        contentPath = ABVEnvironment.getInstance().getProcessListDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                    }
                } else {
                    contentPath = ABVEnvironment.getInstance().getPanoImageDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                    if (operationDto.reportType == ReportType.ReportContinuous) {
                        contentPath = ABVEnvironment.getInstance().getProcessListDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                    }
                }

                // 作業の報告画面を表示時、必要なJSONファイル作成
                mOperationLogic.createJsonForOpenABookCheckPano(operationDto.operationId, operationDto.contentId, contentPath);
                mOperationLogic.createJsonForOperationContent(operationDto.operationId, contentPath, operationDto.reportType == ReportType.RoutineTask);

                // 作業閲覧日付の更新
                mOperationDao.updateReadingDate(operationDto.operationId);
                final String _contentPath = contentPath;
                runOnUiThread(new Runnable() {

                    @Override
                    public void run() {

                        // サーバ作業後、対応必要
                        StringBuffer path = new StringBuffer();
                        path.append(_contentPath);
                        // #32926 作業報告画面改善 start
                        path.append("/index.html?app=android");
                        path.append("&report_type=" + operationDto.reportType);  // 作業報告タイプ : 0:報告 1:定期点検 2:報告(回答)
                        path.append("&mobile_flg=" + (isNormalSize() ? "1" : "0"));  // ScreenType
                        path.append("&operationId=" + operationDto.operationId);
                        path.append("&sid=" + ABVDataCache.getInstance().getMemberInfo().sid);
                        path.append("&quickReport=" + operationDto.quickReport);
                        path.append("&shopName=" + ABVDataCache.getInstance().getUrlPath());
                        if (directPage != null && directPage.length() > 0) {
                            path.append("&autoDirectPage=" + directPage);
                        }
                        if (backPage != null && backPage.length() > 0) {
                            path.append("&backPage=" + backPage);
                        }
                        if (directTaskKey != null && directTaskKey.length() > 0) {
                            path.append("&directTaskKey=" + directTaskKey);
                        }
                        if (directPhaseNo != null && directPhaseNo.length() > 0) {
                            path.append("&directPhaseNo=" + directPhaseNo);
                        }
                        path.append("&acmsAddress=" + ABVEnvironment.getInstance().acmsAddress);
                        if (mScanType != null) {
                            String scanTypeKey = null;
                            if (mScanType.equals(ABookKeys.SCAN_TYPE_VALUE.BARCODE)) {
                                scanTypeKey = ABookKeys.SCAN_TYPE_KEY.BARCODE;
                            } else if (mScanType.equals(ABookKeys.SCAN_TYPE_VALUE.RFID)) {
                                scanTypeKey = ABookKeys.SCAN_TYPE_KEY.RFID;
                            }
                            path.append("&scanType=" + scanTypeKey);
                            mScanType = null;
                        }
                        Logger.d(TAG, "path : " + path);
                        // #32926 作業報告画面改善 end
                        Intent intent = new Intent();
                        intent.putExtra(ABookKeys.CONTENT_ID, operationDto.contentId);
                        intent.putExtra(ABookKeys.OPERATION_ID, operationDto.operationId);
                        intent.putExtra(Constant.ABookCheck.XWALK_OPEN_TYPE, Constant.XWalkOpenType.TASK_REPORT);
                        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
                        intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, OperationListActivity.class.getName());

                        if (operationDto.operationType == OperationType.PDF) {
                            intent.putExtra("LINKURL", "file://" + path);
                            ActivityHandlingHelper.getInstance().checkContentActivity(operationDto.contentId, 0, intent);
                        } else {
                            ActivityHandlingHelper.getInstance().startHTMLWebActivity(OperationListActivity.this, intent, "file://" + path, operationDto.contentId, -1, -1, -1, -1, -1);
                        }
                    }
                });
            } else {
                Logger.w(TAG, "content is not download");
            }
        } catch (Exception e) {
            Logger.e(TAG, e);
            handleErrorMessageToast(ErrorCode.E107);
        } finally {
            closeProgressPopup();
        }
    }

    @Override
    public void onDownloadingContentZip(final ContentZipDownloadNotification notification) {
        Logger.d(TAG, "[onDownloadingContentZip]");
        String errorCodeStr = "";
        if (isShowingBatchSync()) {
            if (notification.getError() != null) {
                Exception e = notification.getError();
                Logger.e(TAG, e);
                if (e instanceof AcmsException && ((AcmsException)e).getCode() != null) {
                    errorCodeStr = Integer.toString(((AcmsException)e).getHttpStatus());
                }
            }
        } else {
            // 一括同期以外は親Activityに通知する
            super.onDownloadingContentZip(notification);
        }
        OperationContentDto operationContentDto = mOperationContentDao.getOperationContentForContentId(notification.getContentId());
        if (operationContentDto != null) {
            if (notification.downloadStatus == DownloadStatusType.Succeeded) {
                if (isShowingBatchSync()) {
                    // 一括同期からの同期処理
                    Logger.d(TAG, "[onDownloadingContentZip] batchOperationSync start");
                    batchSyncView.batchOperationSync();
                } else {
                    OperationDto operationDto = mOperationLogic.getOperation(operationContentDto.operationId);
                    singleSyncOperation(operationContentDto.operationId, operationDto.reportType, true);
                }
            } else if (notification.downloadStatus == DownloadStatusType.Failed || notification.downloadStatus == DownloadStatusType.Canceled || notification.downloadStatus == DownloadStatusType.Paused) {
                Logger.d(TAG, "syncOperation update is failed downloadStatus : " + notification.downloadStatus);
                if (isShowingBatchSync()) {
                    // 一括同期からのダウンロード失敗時、エラーメッセージ表示
                    OperationDto operationDto = mOperationLogic.getOperation(operationContentDto.operationId);
                    batchSyncView.showBatchSyncErrorAlert(operationDto, getString(R.string.msg_batch_sync_content_download_fail) + (StringUtil.isNullOrEmpty(errorCodeStr) ? "" : "(" + errorCodeStr + ")"));
                }
                closeProgressPopup();
            }
        }
    }

    // 作業の自動同期処理(onresumeで呼ばれる同期処理)
    public void singleSyncOperation(final long operationId, int operationReportType) {
        singleSyncOperation(operationId, operationReportType, false);
    }

    /**
     * 作業同期処理(単一)
     * @param operationId
     * @param operationReportType
     */
    public void singleSyncOperation(final long operationId, int operationReportType, boolean buttonEventFlg) {
        String errorMessage = syncOperation(operationId, operationReportType, buttonEventFlg);
        if (errorMessage != null) {
            closeProgressPopup();
            if (buttonEventFlg) {
                // エラーメッセージ表示
                showSimpleAlertDialog(getString(R.string.app_name), errorMessage);
            }
        }
    }

    // 設定画面へ遷移
    public void onClickSetting(View v) {
        showSetting();
    }

    /**
     * 360編集画面表示
     *
     * @param operationDto
     */
    public void startPanoEdit(OperationDto operationDto) {
        // 会議室接続中
        if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
            ABVToastUtil.showMakeText(this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
            return;
        }
        if (operationDto.contentId != null && operationDto.contentId != 0) {
            //showProgressPopup();
            try {
                String baseUrl = ABVEnvironment.getInstance().acmsAddress + ABVDataCache.getInstance().getUrlPath() + "/shop/login/authByCheck/%s/%s";
                String url = String.format(baseUrl, ABVDataCache.getInstance().getMemberInfo().sid, operationDto.contentId);
                Intent intent = new Intent();
                intent.putExtra(ABookKeys.CONTENT_ID, operationDto.contentId);
                intent.putExtra(ABookKeys.OPERATION_ID, operationDto.operationId);
                intent.putExtra(Constant.ABookCheck.XWALK_OPEN_TYPE, Constant.XWalkOpenType.PANO_EDIT);
                intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, OperationListActivity.class.getName());
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
                ActivityHandlingHelper.getInstance().startHTMLWebActivity(OperationListActivity.this, intent, url, operationDto.contentId, -1, -1, -1, -1, -1);
            } catch (Exception e) {
                Logger.e(TAG, e);
                ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
            } finally {
                //closeProgressPopup();
            }
        }
    }

    /**
     * 360コンテンツ登録ダイアログ
     */
    public void showPanoEntryDialog(final OperationDto operationDto) {
        if (contentRefresher != null && contentRefresher.isRefreshing()) {
            // 新着更新処理が行っていれば、止める
            contentRefresher.stopRefresh();
        }
        //インターネットチェック
        if (checkNetworkConnected()) {
            //パーミッションチェック
            ABookPermissionHelper helper = new ABookPermissionHelper(this, Constant.ABookPermissionType.ReadExternalStorage, null);
            if (helper.checkMultiPermissions(true)) {
                mSelectedOperationId = operationDto.operationId;
                //シーン画像選択画面表示
                Intent intent = new Intent();
                intent.putExtra(ABookKeys.BASE_CONTENT_REGISTER, true);
                intent.putExtra(ABookKeys.OPERATION_ID, mSelectedOperationId);
                intent.putExtra(ABookKeys.OPERATION_NAME, operationDto.operationName);

                String className = DeviceImageListActivity.class.getName();
                if (isNormalSize() == false) {
                    className += "Dialog";
                }

                intent.setClassName(getPackageName(), className);
                startActivityForResult(intent, SUB_DIVICE_IMAGE_LIST_ACTIVITY);

            } else {
                Logger.w(TAG, "ReadExternalStorage checkMultiPermissions false");
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode,requestCode, intent);

        if (requestCode == ABookCommConstants.PUSH_MESSAGE_DLG_REQUEST_CODE) {
            // プッシュメッセージダイアログのリザルトだった場合
            if (resultCode == ABookCommConstants.PUSH_MESSAGE_DLG_RESULT.OK) {
                goChatRoom(intent, ChatWebViewActivity.class.getName(), OperationListActivity.class.getName());
            }
            return;
        }

        activityResultFlg = true;
        Uri result = (intent == null || resultCode != RESULT_OK) ? null : intent.getData();
        //ベースファイル登録した後にシーン画像選択画面閉じた後に呼ばれる
        if (requestCode == SUB_DIVICE_IMAGE_LIST_ACTIVITY && resultCode == RESULT_OK) {
            mOperationLogic.setContentCreatingFlg(mSelectedOperationId);

            //screenRefresh();

            //10秒（コンテンツ作成し、公開までの時間）に新着更新させる。
            showProgressView(getString(R.string.msg_common_processing));
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    int progress = progressDialogHorizontal.getProgress();
                    progressDialogHorizontal.setProgress(progress + 10);
                    if (progress >= 30) {
                        try {
                            dateUpdate();
                        } catch (Exception e) {
                            handler.post(new Runnable() {
                                @Override
                                public void run() {
                                    closeProgressPopup();
                                }
                            });
                        }
                    } else {
                        handler.postDelayed(this, 4000);
                    }
                }
            }, 2000);
        }
    }

    /**
     * 作業報告画面に移動
     * @param operationDto
     */
    public void openReportView(OperationDto operationDto) {
        if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
            ABVToastUtil.showMakeText(this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
            return;
        }
        // 新着更新を止める
        contentRefresher.stopRefresh();
        startTaskDirectionOrReportView(operationDto);
    }

    /**
     * 同期処理
     * @param operationDto
     */
    public void startSyncOperation(final OperationDto operationDto) {
        //ネットワークチェック
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            ABVToastUtil.showMakeText(OperationListActivity.this, R.string.request_network_connection, Toast.LENGTH_SHORT);
            return;
        }
        //新着更新中
        if (contentRefresher.isRefreshing()) {
            return;
        }

        // 会議室接続中
        if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
            ABVToastUtil.showMakeText(this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
            return;
        }
        startSyncOperationStart(operationDto, true);
    }

    public void startSyncOperationStart(final OperationDto operationDto, final boolean buttonEventFlg) {
        // リソースパターンの適用
        showProgressView(PatternStringUtil.patternToString(getApplicationContext(),
                R.string.synchronizing,
                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                Logger.i(TAG, "[syncOperation] operationId=%s, contentId=%s", operationDto.operationId, operationDto.contentId);
                // コンテンツダウンロード
                if (operationDto.contentId == null) {
                    Logger.e(TAG, "contentDto is null !");
                    closeProgressPopup();
                    if (mCallBack != null) {
                        mCallBack.run();
                    }
                    return;
                }
                ContentDto contentDto = contentDao.getContent(operationDto.contentId);
                if (contentDto == null) {
                    Logger.e(TAG, "contentDto is null !");
                    return;
                }
                if (!contentDto.downloadedFlg || contentDto.updatedFlg) {
                    if (!operationContentDownload(contentDto)) {
                        Logger.e("operation sync baseFile download fail");
                        closeProgressPopup();
                    }
                } else {
                    singleSyncOperation(operationDto.operationId, operationDto.reportType, buttonEventFlg);
                }
            }
        });
    }

    /**
     * リストビュー用のプルダウンで新着更新処理
     * @param refreshView
     */
    public void pullToListViewRefresh(PullToRefreshBase<ListView> refreshView) {
        refreshBaseView = refreshView;

        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showDisConnectNetworkDialog();
            return;
        }
        long lastUpdateTime = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.LAST_UPDATE_TIME, 0L);
        if (lastUpdateTime > 0) {
            String lastUpdateTimeLabel = null;
            String strUpdateTime = DateTimeUtil.toString(new Date(lastUpdateTime), DateTimeFormat.yyyyMMddHHmmss_slash);
            // リソースパターンの適用
            String formatStr = PatternStringUtil.patternToString(getApplicationContext(),
                                R.string.recent_update_date,
                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
            lastUpdateTimeLabel = String.format(formatStr, strUpdateTime);

            // Update the LastUpdatedLabel
            if (lastUpdateTimeLabel != null) {
                refreshView.getLoadingLayoutProxy().setLastUpdatedLabel(lastUpdateTimeLabel);
            }
        }
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                if (!contentRefresher.isRefreshing()) {
                    dataRefresh(false);
                }
            }
        });
    }

    /**
     * パンネルビュー用のプルダウンで新着更新処理
     * @param refreshView
     */
    public void pullToGridViewRefresh(PullToRefreshBase<GridView> refreshView) {
        // 完了通知のため、ビューをメンバー変数で管理する
        refreshBaseView = refreshView;
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showDisConnectNetworkDialog();
            return;
        }
        long lastUpdateTime = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.LAST_UPDATE_TIME, 0L);
        if (lastUpdateTime > 0) {
            String lastUpdateTimeLabel = null;
            String strUpdateTime = DateTimeUtil.toString(new Date(lastUpdateTime), DateTimeFormat.yyyyMMddHHmmss_slash);
            // リソースパターンの適用
            String formatStr = PatternStringUtil.patternToString(getApplicationContext(),
                                R.string.recent_update_date,
                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
            lastUpdateTimeLabel = String.format(formatStr, strUpdateTime);

            // Update the LastUpdatedLabel
            if (lastUpdateTimeLabel != null) {
                refreshView.getLoadingLayoutProxy().setLastUpdatedLabel(lastUpdateTimeLabel);
            }
        }
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        if (!contentRefresher.isRefreshing()) {
                            dataRefresh(false);
                        }
                    }
                });
            }
        });
    }

    /**
     * インターネットが繋がってない場合のダイアログ表示
     */
    private void showDisConnectNetworkDialog() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                // ヘッダーの新着更新処理を完了にさせる
                stopUpdateAnimation();
                final ABookAlertDialog messageDialog = AlertDialogUtil.createAlertDialog(OperationListActivity.this, R.string.app_name);
                messageDialog.setMessage(getString(R.string.msg_network_offline));
                messageDialog.setPositiveButton(R.string.confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        messageDialog.dismiss();
                    }
                });
                messageDialog.show();
            }
        });
    }

    // ログイン成功した後、新着更新時の「ContentVersion」APIからリソースパターンを取得し、ローカルに保存する。
    private void setResourcePattern() {
        Logger.d(TAG, "ABVEnvironment.getInstance().resourcePatternType : " + ABVEnvironment.getInstance().resourcePatternType);
        putUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, ABVEnvironment.getInstance().resourcePatternType);
    }

    /**
     * 作業種別の選択のダイアログ画面表示
     * @param isInit 初期表示
     */
    public void showOperationGroupMasterDialog(boolean isInit) {
        if (isInit || operationCountMap == null) {
            // 最後の階層レベルを取得
            Integer lastLevel = mOperationGroupMasterLogic.getLastGroupLevel();
            operationCountMap = new HashMap<Integer, Integer>();
            // 作業種別毎に作業数をMapにセット
            mOperationGroupMasterLogic.getAllOperationCount(lastLevel, operationCountMap);
        }
        // 既にダイアログが存在するか、開いた状態である場合は何もしない
        if (mShowDialog != null && mShowDialog.isShowing()) {
            return;
        }
        final ABVListDialog dialog = new ABVListDialog(this);
        // 外側タップしてもダイアログ画面が閉じられないように設定
        dialog.setCanceledOnTouchOutside(false);
        mShowDialog = dialog;
        OperationGroupMasterListHelper helper = (OperationGroupMasterListHelper) mListHelper;
        ArrayList<String> groupNames = new ArrayList<>();

        // 直下の作業種別リスト情報を取得
        final List<OperationGroupMasterDto> operationGroupMasterDtoList = helper.getChildList();

        dialog.setTitle(helper.getPeekName(), R.drawable.ic_title_group_operation);

        // 閉じるボタン
        dialog.setRightItemOnClickListener(R.drawable.ic_operation_close, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        boolean[] haveChildFlags = new boolean[operationGroupMasterDtoList.size()];
        int[] operationCounts = new int[operationGroupMasterDtoList.size()];
        int i = 0;
        for (OperationGroupMasterDto dto : operationGroupMasterDtoList) {
            int operationGroupMasterId = dto.operationGroupMasterId;
            groupNames.add(dto.operationGroupMasterName);
            // 下位階層があるか否かチェック
            haveChildFlags[i] = helper.getChildList(operationGroupMasterId).size() > 0;
            // 子グループも含めて作業種別に紐づく作業数
            operationCounts[i] = operationCountMap.get(operationGroupMasterId);
            i++;
        }

        final HierarchyOperationGroupListAdapter adapter = new HierarchyOperationGroupListAdapter(this, groupNames, haveChildFlags, operationCounts);

        // 上位階層がある場合、上位階層に戻るボタンを追加
        if (helper.getStackSize() > 1) {
            dialog.setListViewAdapter(adapter);
            String backToName = helper.getPrePeekName();
            // スマートフォン端末で20文字を超えた場合、20文字まで切り落として後ろに...をつけて表示
            if (isNormalSize() && backToName.length() > 20) {
                backToName = backToName.substring(0, 20) + "...";
            }
            dialog.setHeaderItemOnClickListener(backToName, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    OperationGroupMasterListHelper helper = (OperationGroupMasterListHelper) mListHelper;
                    helper.popList(1, true);
                    // ポップアップ再表示
                    dialog.dismiss();
                    showOperationGroupMasterDialog(false);
                }
            });
        } else {
            dialog.setListViewAdapter(adapter);
        }

        // 直下階層の要素をクリックイベント
        dialog.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                OperationGroupMasterDto operationGroupMasterDto = operationGroupMasterDtoList.get(position);
                OperationGroupMasterListHelper helper = (OperationGroupMasterListHelper) mListHelper;
                helper.pushList(operationGroupMasterDto);
                // ポップアップ再表示
                dialog.dismiss();
                showOperationGroupMasterDialog(false);
            }
        });

        // リストが空の時表示するテキストを設定
        dialog.setListEmptyText(getString(R.string.no_child));
        if (isNormalSize()) {
            dialog.showHalfSize();
        } else {
            dialog.show();
        }
    }

    /**
     * operationListHelperに通常か作業種別のhelperをセット
     * @return
     */
    private OperationListHelper getListHelper() {
        OperationListHelper operationListHelper;
        if (mOperationGroupMasterServiceOperationFlg && getABVUIDataCache().getOperationGroupMasterMode() == OperationLocationType.CATEGORY) {
            operationListHelper = new OperationGroupMasterListHelper(this);
        } else {
            operationListHelper = new HomeOperationListHelper(this);
        }
        return operationListHelper;
    }

    /**
     * 作業種別ID取得
     * @return
     */
    public int getOperationGroupMasterId() {
        return getABVUIDataCache().getOperationGroupMasterId();
    }

    /**
     * 開いた作業種別ID保存
     * @param operationGroupMasterId
     */
    public void setOperationGroupMasterId(int operationGroupMasterId) {
        getABVUIDataCache().setOperationGroupMasterId(operationGroupMasterId);
    }

    /**
     * 絞り検索の日付を設定
     */
    private void setApertureMasterDataFetchDate() {
        putUserPref(AppDefType.UserPrefKey.APERTURE_MASTER_DATA_FETCH_DATE, ABVDataCache.getInstance().getTempApertureMasterDataFetchDate());
    }

    /**
     * カテゴリの一括同期ダイアログ表示
     */
    private void showBatchSyncDialog() {
        ABookAlertDialog dialog = AlertDialogUtil.createABookAlertDialog(this);
        dialog.setTitle(getString(R.string.batch_sync));
        dialog.setMessage(getString(R.string.msg_confirm_batch_sync));
        dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                // 一括同期開始
                categoryBatchSync();
            }
        });
        dialog.setNegativeButton(R.string.cancel,  new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        if (mAlertDialog != null && this.mAlertDialog.isShowing()) {
            mAlertDialog.dismiss();
        }
        this.mAlertDialog = dialog;
        mAlertDialog.show();
    }

    /**
     * カテゴリの一括同期ボタン
     */
    public void categoryBatchSync() {
        Logger.i(TAG, "---batch sync start");
        // ネットワーク通信チェック
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showSimpleAlertDialog(getString(R.string.app_name), getString(R.string.request_network_connection));
            return;
        }

        // 作業種別に関連する作業リストを取得
        List<OperationDto> operationList = mOperationDao.getNeedSyncOperationByGroupMasterId(getABVUIDataCache().getOperationGroupMasterId());

        // 作業リストをスタックにセット
        Stack<OperationDto> operationDtoStack = new Stack<OperationDto>();
        operationDtoStack.addAll(operationList);

        // 一括同期を設定
        batchSyncView = new ABVBatchSyncView(this);

        // batchSyncViewにスタックをセットして表示
        batchSyncView.setStack(operationDtoStack);
        batchSyncView.show();

        // 一括同期処理
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                batchSyncView.batchOperationSyncForCheckDonwload();
            }
        });
    }

    /**
     * 同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合
     * needSyncFlgをtrueに更新する
     */
    private void updateNeedSyncRoutineOperation() {
        // サービスオプションチェック
        if (ABVDataCache.getInstance().serviceOption.isRoutineTaskReport()) {
            // 同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合needSyncFlgをtrueに更新する
            List<OperationDto> deactivatedRoutineOperationList = mOperationDao.getDeactivatedRoutineOperation();
            for (OperationDto routineOperationDto : deactivatedRoutineOperationList) {
                String syncedDate = getUserPref(String.format(AppDefType.UserPrefKey.SYNCED_OPERATION_ID, routineOperationDto.operationId), "");
                if (StringUtil.isNullOrEmpty(routineOperationDto.reportPeriod) && !syncedDate.equals(DateTimeUtil.toString(DateTimeUtil.getCurrentSqlDate(), DateTimeFormat.yyyyMMdd_none))) {
                    // 同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合
                    mOperationLogic.updateSyncOperation(routineOperationDto.operationId, true);
                }
            }
        }
    }

    /**
     * 作業用コンテンツダウンロード時、ダウンロードかダウンロード再開か判定して行う。
     * @param contentDto
     * @return
     */
    public boolean operationContentDownload(final ContentDto contentDto) {
        if (contentDto.isDownloadPaused()) {
            // ダウンロード途中で通信が切れた場合、一時停止のステータスに変更になるため、再開させる
            try {
                contentDownloader.resume(contentDto.contentId);
            } catch (Exception e) {
                Logger.e(TAG, "downloadContent failed. contentId=" + contentDto.contentId, e);
                return false;
            }
        } else {
            // ダウンロード
            return contentDownload(contentDto.contentId, false, false);
        }
        return true;
    }

    @Override
    public void onDestroy() {
        Logger.d(TAG, "onDestroy");
        contentDownloader.removeContentDownloadListener(this);
        if (batchSyncView != null) {
            batchSyncView.setActivityDestroy();
        }
        super.onDestroy();
    }

    /**
     * 並び替え設定メニュー（タブレット）
     * @param anchor
     */
    public void onClickSortMenuByTablet(View anchor) {
        Logger.d(TAG, "onClickShowSortConditionList");
        final ABVPopupListWindow popup = new ABVPopupListWindow(this, R.layout.popup_simple_list);
        popup.setTitle(getRString(R.string.sort_title));

        ListView listView = popup.getListView();
        // ソート用のリストビューセット
        ArrayAdapter<String> adapter = setSortListView(listView);
        listView.setAdapter(adapter);
        listView.setItemChecked(getABVUIDataCache().getSortCondition(), true);

        // 横幅をフィットさせる
        popup.setWidth((int)(ABVPopupListWindow.getWidestView(this, adapter) * 1.15));

        popup.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Logger.d(TAG, "onClickSortMenuByTablet id:" + id);
                getABVUIDataCache().setSortCondition((int)id);
                // ビューア更新
                screenRefresh();
            }
        });

        if (anchor == null) {
            // 呼び出したViewが存在しない場合、真ん中に表示する
            popup.showAtLocation(getWindow().getDecorView().findViewById(android.R.id.content), Gravity.CENTER, 0,0);
        } else {
            popup.showAsDropDown(anchor);
        }
    }


    /**
     * 並び替え設定メニュー（スマートフォン）
     * @param view
     */
    public void onClickSortMenuByNormalSize(View view) {
        final ABVListDialog dialog = new ABVListDialog(this, getString(R.string.sort_title));

        // ダイアログ表示時、ダイアログ以外の画面をタップしても閉じられないように設定
        dialog.setCanceledOnTouchOutside(false);
        // ソート用のリストビューセット
        ListView listView = dialog.getListView();
        dialog.setListViewAdapter(setSortListView(listView));
        listView.setItemChecked(getABVUIDataCache().getSortCondition(), true);

        mShowDialog = dialog;

        // 閉じるボタン
        dialog.setRightItemOnClickListener(R.drawable.ic_operation_close, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        dialog.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                getABVUIDataCache().setSortCondition((int)id);
                screenRefresh();
            }
        });

        if (isNormalSize()) {
            dialog.showHalfSize();
        } else {
            dialog.show();
        }
    }

    // 並び替えの表示するソートリスト

    /**
     * 並び替えの表示するソートリスト
     * @param listView
     * @return ArrayAdapter ソート名をセットしたアダプタ
     */
    private ArrayAdapter<String> setSortListView(ListView listView) {
        listView.setChoiceMode(AbsListView.CHOICE_MODE_SINGLE);
        return new ArrayAdapter<>(this, R.layout.item_checked_list, Arrays.asList(getRStringArray(R.array.sort_names)));
    }

    /**
     * 並べ替え画面表示
     *
     * @param anchor
     */
    public void onClickGroupLocationByTablet(final View anchor) {
        Logger.d(TAG, "onClickGroupLocationByTablet start");
        final ABVPopupListWindow popup = new ABVPopupListWindow(this, R.layout.popup_simple_list);
        popup.setTitle(getRString(R.string.category_list));
        popup.setWidth(getRDimensionSize(R.dimen.popup_size_large));

        // 表示するコンテンツタイプのリストを作成
        ListView listView = popup.getListView();
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, R.layout.item_dialog_list, Arrays.asList(getRStringArray(R.array.category_types)));

        popup.setListViewAdapter(adapter);

        popup.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                popup.dismiss();
                setOperationLocation(id);
            }
        });
        if (anchor == null) {
            // 呼び出したViewが存在しない場合、真ん中に表示する
            popup.showAtLocation(getWindow().getDecorView().findViewById(android.R.id.content), Gravity.CENTER, 0,0);
        } else {
            popup.showAsDropDown(anchor);
        }
    }

    // 全て・カテゴリ選択画面(スマートフォン)
    public void onClickGroupLocationByNormalSize(View view) {
        final ABVListDialog dialog = new ABVListDialog(this);
        // 外側タップしてもダイアログ画面が閉じられないように設定
        final ArrayAdapter<String> adapter = new ArrayAdapter<>(this, R.layout.item_dialog_list, Arrays.asList(getRStringArray(R.array.category_types)));
        dialog.setTitle(getRString(R.string.category_list));
        dialog.setListViewAdapter(adapter);
        dialog.setCanceledOnTouchOutside(false);

        // 閉じるボタン
        dialog.setRightItemOnClickListener(R.drawable.ic_operation_close, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        dialog.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // ポップアップ再表示
                dialog.dismiss();
                setOperationLocation(id);
            }
        });

        if (isNormalSize()) {
            dialog.showHalfSize();
        } else {
            dialog.show();
        }
    }

    /**
     * カテゴリ選択した内容で設定・表示する
     * @param type 0 : 全て 1: カテゴリ
     */
    private void setOperationLocation(long type) {
        Logger.d(TAG, "setOperationLocation type :" + type);
        int localType = getABVUIDataCache().getOperationGroupMasterMode();

        // loadFlgがtrueの場合のみ、タイプを保存して画面を再作成する
        if (localType != type) {
            // typeの値をxmlに書き込み
            getABVUIDataCache().setOperationGroupMasterMode((int) type);
            // プログレスバー
            //showProgressPopup();
            setOperationListView();
        }
    }

    /**
     * ソート順取得（デフォルト：１(作業期間が新しい順)）
     * @return
     */
    public int getSortCondition() {
        return getABVUIDataCache().getSortCondition();
    }

    public void createJsonForOperationList(String filePath) {
        //clearSearch();
        List<OperationDto> operationList = mListHelper.filterOperationList();
        mOperationLogic.createOperationListJson(operationList, filePath);
        mOperationGroupMasterLogic.createOperationGroupMasterListJson(filePath);
        mOperationGroupMasterLogic.createOperationGroupMasterRelationListJson(filePath);
        mPushMessageLogic.createOperationPushMessageListJson(filePath);
    }

    public void screenRefresh() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    createJsonForOperationList(getCacheDir().getAbsolutePath());
                    mCheckWebView.loadUrl("javascript:CHK.initOperationList();");
                } catch (Exception e) {
                    Logger.d("Update error");
                }
            }
        });
    }

    public void dateUpdate() {
        if (!isFinishing() && progressDialogHorizontal != null && !progressDialogHorizontal.isShowing()) {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    showProgressView(getString(R.string.msg_common_processing));
                }
            });
        }
        final Callback progressCallback = new Callback() {
            @Override
            public Object callback(Object ret) {
                final int progress = (int)ret;
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if ((progressDialogHorizontal.getProgress() + progress) < 100) {
                            progressDialogHorizontal.setProgress(progressDialogHorizontal.getProgress() + progress);
                        } else {
                            progressDialogHorizontal.setProgress(100);
                        }
                    }
                });
                return null;
            }
        };
        try {
            dataRefresh(true, progressCallback);
        } catch (Exception e) {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    closeProgressPopup();
                }
            });
        }
    }

    private void saveJson(String jsonName, String jsonData) {
        if (StringUtil.isNullOrEmpty(jsonName)) {
            Logger.d(TAG,"saveJson:jsonName is null or empty");
            return;
        }
        String filePath = getCacheDir().getAbsolutePath() + "/" + jsonName;
        try {
            FileUtil.createFile(filePath, jsonData);
        } catch (IOException e) {
        };
    }

    private void showSendMessage() {
        showOperationSelectDialog();
    }

    private void showDistanceSupport() {
        ActivityHandlingHelper.getInstance().startMeetingActivity();
    }

    private void showChat() {
        ActivityHandlingHelper.getInstance().startChatWebViewActivity(new Long(0),"", ChatWebViewActivity.class.getName(), OperationListActivity.class.getName());
    }

    private void actionPushMessage(String action, int pushMessageId) {
        if (action.equals("read")) {
            pushMessageLogic.updateReadingFlg(pushMessageId);
            pushMessageLogic.createOperationPushMessageListJson(getCacheDir().getAbsolutePath());
        }
    }

}
