package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.os.AsyncTask;

import com.theta.network.HttpConnector;

import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaCameraActivity;
/**
 * THETAカメラの露出情報を設定するスレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class SetOptionExposureTask extends AsyncTask<String, String, String> {
    private static final String TAG = "SetOptionExposureTask";
    private final WeakReference<ThetaCameraActivity> refActivity;

    public SetOptionExposureTask(ThetaCameraActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected String doInBackground(String... params) {
        Logger.d(TAG, "doInBackground");
        boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(), ABookKeys.THETA_OLD_VERSION_FLG, false);
        HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
        if (camera.setOptionExposure(params[0])) {
            return ABookValues.SUCCESS;
        }
        return ABookValues.FAIL;
    }

    @Override
    protected void onPostExecute(String exposure) {
        Logger.d(TAG, "onPostExecute");
        ThetaCameraActivity activity = refActivity.get();
        activity.setOptionExposureTaskFinish(exposure);
    }
}
