package jp.agentec.abook.abv.ui.viewer.adapter;

import jp.agentec.adf.util.StringUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

public class PDFIndexInfoJSON {
	private static final String TAG = "PDFIndexInfoJSON";

	/**
	 * JSON Param
	 */
	public static final String ID = "ID";
	public static final String DEST_COORD_LEFT = "destCoordLeft";
	public static final String DEST_COORD_TOP = "destCoordTop";
	public static final String DEST_PAGE_NUMBER = "destPageNumber";
	public static final String DEST_URL = "destURL";
	public static final String LEVEL = "level";
	public static final String LINK_KIND = "linkKind";
	public static final String PARENT_ID = "parentID";
	public static final String TITLE = "title";

	private JSONArray root;

	public PDFIndexInfoJSON(String json) {
		if (StringUtil.isNullOrEmpty(json)) {
			root = new JSONArray();
		}
		else {
			root = new JSONArray(json);
		}
	}
	
	public JSONObject getJsonObject(int num) {
		return root.getJSONObject(num);
	}
	
	public JSONArray getJsonArray() {
		return  root;
	
	}

}
