package jp.agentec.abook.abv.ui.viewer.view.action;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.BitmapUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.DisplayUtil;
import jp.agentec.abook.abv.ui.viewer.view.ActionImageView;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.ImageView.ScaleType;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ViewFlipper;

/***********************************************************************
 * イメージ差し替えタップ  クラス
 ***********************************************************************/
public class ImageChangeAction {
    private int mIndex;
    private int mPage;
    private int mW;
    private int mH;
    private String[] mFilelist;
    private long[] mResourceIds;
    private LinearLayout[] mFlipperLayout;
    private int mHistoryImageIndex[] = new int[2];
    private int mPosition;   //表示画像番号
    public ViewFlipper mViewFlipper;
    boolean mImageAspectTypeFlag = false;
    
	//***** イメージ表示領域の追加
    public void addImageChangeTap(Context context, int x, int y, int w, int h, float fscale, String[] filelist, long[] resourceIds, RelativeLayout layout, int index, int page, boolean isImageAspectType) {
    	mIndex = index;
		mPage = page;
		mW = w;
		mH = h;
		mFilelist = filelist;
		mResourceIds = resourceIds;
		
		mPosition = 0;
    	mViewFlipper = new ViewFlipper(context);
    	mFlipperLayout = new LinearLayout[mFilelist.length];
    	mImageAspectTypeFlag = isImageAspectType;
    	
    	//イメージ領域セット
    	for (int i = 0; i < filelist.length; i++) {
    		mFlipperLayout[i] = new LinearLayout(context);

	    	LinearLayout.LayoutParams paramFlipperLayout = new LinearLayout.LayoutParams(w, h);
	    	mViewFlipper.addView(mFlipperLayout[i], paramFlipperLayout);
    	}
    	ImageView flipperImageView = new ImageView(context);
    	flipperImageView.setPadding(0, 0, 0, 0);
    	flipperImageView.setScaleType(ScaleType.FIT_XY);
		//flipperImageView.setImageURI(Uri.parse(mFilelist[0]));

    	if (mImageAspectTypeFlag) {
    		flipperImageView.setScaleType(ScaleType.FIT_CENTER);       //画像のアスペクト比を維持
    	} else {
    		flipperImageView.setScaleType(ScaleType.FIT_XY);       //エリア全体に画像を拡大して表示
    	}
    	
    	Bitmap myBitmap = BitmapFactory.decodeFile(mFilelist[0]);
    	flipperImageView.setImageBitmap(myBitmap);
    	
//    	Bitmap resized = BitmapUtil.getResizedBitmap(mFilelist[0], mW, mH, Config.RGB_565, false);//イメージサイズをリサイズする
//    	flipperImageView.setImageBitmap(resized);
    	LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(w, h);
		mFlipperLayout[0].removeAllViews();
	    mFlipperLayout[0].addView(flipperImageView, param);
	    mHistoryImageIndex[0] = 1;

    	RelativeLayout.LayoutParams paramRel = new RelativeLayout.LayoutParams((int)(w * fscale), (int)(h * fscale));   //W,H 横幅、高さ
    	paramRel.setMargins((int)(x * fscale), (int)(y * fscale), 0, 0);                    //X,Y 外側の余白
    	layout.addView(mViewFlipper, paramRel);  
    }
    
    public void showImageTap(Context context, int id) {
    	mViewFlipper.setInAnimation(AnimationUtils.loadAnimation(context, R.anim.inslide_left));
		mViewFlipper.setOutAnimation(AnimationUtils.loadAnimation(context, R.anim.outslide_right));
		mViewFlipper.setDisplayedChild(id);
    }
    
  //***** イメージ表示領域の追加
    public ActionImageView addImageChangeView(Context context, int x, int y, int w, int h, float fscale, String imgfile, RelativeLayout layout, boolean isImagetAspectType) {
    	RelativeLayout.LayoutParams param1 = new RelativeLayout.LayoutParams(w, h);   //W,H 横幅、高さ
    	param1.setMargins(x, y, 0, 0);                    //X,Y 外側の余白

		Logger.d("mPageActionList  ", "   arrayChangeImageTap  w " + w + "h" + h);
    	ActionImageView imgView = new ActionImageView(context);
    	imgView.setPadding(0, 0, 0, 0);               //内側の余白
    	//imgView_.setAdjustViewBounds(true);            //描画の縦横比を維持
    	if (isImagetAspectType) {
    		imgView.setScaleType(ScaleType.FIT_CENTER);       //画像のアスペクト比を維持
    	} else {
    		imgView.setScaleType(ScaleType.FIT_XY);       //エリア全体に画像を拡大して表示
    	}
		//noinspection deprecation(API16から非推奨になった。無視)
    	imgView.setBackgroundDrawable(null);          //半透明表示
    	Bitmap myBitmap = BitmapFactory.decodeFile(imgfile);

		// ディスプレイ情報取得して、アクセプト比を維持してリサイズ
		Point point = DisplayUtil.getDisplaySize(context);
		int dispWidth = point.x;
		int dispHeight = point.y;
		Bitmap resized = BitmapUtil.getResizedBitmap(imgfile,dispWidth,dispHeight);
		imgView.setImageBitmap(resized);

    	layout.addView(imgView, param1);
    	
		return imgView;
    }
    public void setPage(int page) {
		this.mPage = page;
	}
	public int getPage() {
		return mPage;
	}
    public void setIndex(int index) {
    	mIndex = index;
    }
    public int getIndex() {
    	return mIndex;
    }
    public void setFlipperImage(Context context, int index) {
    	ImageView flipperImageView = new ImageView(context);
    	flipperImageView.setPadding(0, 0, 0, 0);
    	flipperImageView.setScaleType(ScaleType.FIT_XY);

		Logger.d("setFlipperImage  ", "   setFlipperImage    w" + mW + "          h" + mH);
		if (mImageAspectTypeFlag) {
    		flipperImageView.setScaleType(ScaleType.FIT_CENTER);       //画像のアスペクト比を維持
    	} else {
    		flipperImageView.setScaleType(ScaleType.FIT_XY);       //エリア全体に画像を拡大して表示
    	}
    	
    	Bitmap myBitmap = BitmapFactory.decodeFile(mFilelist[index]);
    	flipperImageView.setImageBitmap(myBitmap);
//    	Bitmap resized = BitmapUtil.getResizedBitmap(mFilelist[index], mW, mH, Config.RGB_565, false);//イメージサイズをリサイズする
//    	flipperImageView.setImageBitmap(resized);
    	//flipperImageView.setImageURI(Uri.parse(mFilelist[index]));
		LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(mW, mH);
		mFlipperLayout[index].removeAllViews();
	    mFlipperLayout[index].addView(flipperImageView, param);
	    mPosition = index;
		removeFlipperImage(index + 1);
    }
    private void removeFlipperImage(int index) {
    	int historyHitPosition = -1;
    	boolean historyMaxFlg = true;
    	for (int i = 0; i < mHistoryImageIndex.length; i++) {
    		if (mHistoryImageIndex[i] == index) {
    			historyHitPosition = i;
    			break;
    		} else if (mHistoryImageIndex[i] == 0) {
    			historyMaxFlg = false;
    			mHistoryImageIndex[i] = index;
    			break;
    		}
    	}
    	if (historyHitPosition > -1) {
    		for (int i = historyHitPosition; i < mHistoryImageIndex.length; i++) {
    			if ((i + 1) < mHistoryImageIndex.length) {
    				if (mHistoryImageIndex[i + 1] == 0) {
    					mHistoryImageIndex[i] = index;
    					break;
    				} else {
    					mHistoryImageIndex[i] = mHistoryImageIndex[i + 1];
    				}
    			} else {
    				mHistoryImageIndex[i] = index;
    			}
    		}
    	} else if (historyMaxFlg == true) {
    		mFlipperLayout[mHistoryImageIndex[0] - 1].removeAllViews();
    		for (int i = 0; i < mHistoryImageIndex.length; i++) {
    			if ((i + 1) < mHistoryImageIndex.length) {
    				mHistoryImageIndex[i] = mHistoryImageIndex[i + 1];
    			} else {
    				mHistoryImageIndex[i] = index;
    			}
    		}
       	} 	
    }
    // 選択画像を表示
 	public void goIndex(Context context, int index) {
 		mViewFlipper.setInAnimation(AnimationUtils.loadAnimation(context, R.anim.inslide_left));
		mViewFlipper.setOutAnimation(AnimationUtils.loadAnimation(context, R.anim.outslide_right));
 		setFlipperImage(context, index);
 		mViewFlipper.setDisplayedChild(index);
 	}
 		
 	// 次の画像を表示
 	public long goNext(Context context) {
 		int index;
 		if (mPosition < (mFilelist.length - 1)) {
 			index = mPosition + 1;
 		} else {
 			index = 0;
 		}
 		mViewFlipper.setInAnimation(AnimationUtils.loadAnimation(context, R.anim.inslide_left));
		mViewFlipper.setOutAnimation(AnimationUtils.loadAnimation(context, R.anim.outslide_right));
		setFlipperImage(context, index);
 		mViewFlipper.setDisplayedChild(index);

 		return mResourceIds[index];
 	}
 	
 	public int getPosition() {
    	return mPosition;
    }
}
