/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import oz.client.shape.ui.view.OZSignpadScrollView;
import oz.client.shape.ui.view.OZSignpadScrollView$ScrollCommand;
import oz.main.OZStorage;

public class OZSignpadScrollBarView
extends View {
    private OZSignpadScrollView mTargetView;
    private boolean mNeedUpdate;
    private boolean mIsVertical;
    private float mStartLocation;
    private float mStartRealLocation;
    private int mStartX;
    private int mStartY;
    private boolean mIsMove;
    private Rect mScrollBarRect = new Rect();
    private Rect mScrollAreaRect = new Rect();
    private Rect mScrollAreaAbleRect = new Rect();
    private Rect mDrawableDrawRect = new Rect();
    private Rect mDrawableRealDrawRect = new Rect();
    private RectF mDrawRectArea = new RectF();
    private RectF mDrawRectBar = new RectF();
    private RectF mTouchRectBar = new RectF();
    private float mNowLocation;
    private Paint mBarPaint = new Paint(1);
    private Paint mAreaPaint;
    private Drawable mBarDrawable;
    private float mDrawable_Bar_Ratio;
    private int mBarMargin;

    public OZSignpadScrollBarView(Context context) {
        super(context);
        this.mBarPaint.setStyle(Paint.Style.FILL);
        this.mBarPaint.setColor(Color.argb((int)220, (int)100, (int)100, (int)100));
        this.mAreaPaint = new Paint(1);
        this.mAreaPaint.setStyle(Paint.Style.FILL);
        this.mAreaPaint.setColor(Color.argb((int)20, (int)100, (int)100, (int)100));
    }

    public void setBarMargin(int n) {
        this.mBarMargin = n;
    }

    public void setBarDrawable(Drawable drawable2) {
        this.mBarDrawable = drawable2;
        this.requestUpdateScroll();
    }

    public void setVertical(boolean bl) {
        this.mIsVertical = bl;
    }

    public boolean isVertical() {
        return this.mIsVertical;
    }

    public void setTargetView(OZSignpadScrollView oZSignpadScrollView) {
        this.mTargetView = oZSignpadScrollView;
    }

    public View getTargetView() {
        return this.mTargetView;
    }

    public void requestUpdateScroll() {
        this.mNeedUpdate = true;
    }

    OZSignpadScrollView getScrollView() {
        return this.mTargetView;
    }

    OZSignpadScrollView$ScrollCommand getCommand() {
        if (this.getScrollView() != null) {
            return this.isVertical() ? this.getScrollView().getVerticalCommand() : this.getScrollView().getHorizontalCommand();
        }
        return null;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.requestUpdateScroll();
    }

    private void updateScrollBarRect(int n, float f2, float f3) {
        float f4;
        if (f2 > 0.0f && f3 > 0.0f && (f4 = f2 / f3) > 0.0f && f4 < 1.0f) {
            float f5 = Math.min(1.0f - f4, (float)n / f3);
            float f6 = Math.min(1.0f, f5 + f4);
            int n2 = this.mScrollAreaRect.width();
            int n3 = this.mScrollAreaRect.height();
            this.mScrollBarRect.set(this.mScrollAreaRect);
            if (this.isVertical()) {
                this.mScrollBarRect.top += (int)((float)n3 * f5);
                this.mScrollBarRect.bottom -= (int)((float)n3 * (1.0f - f6));
            } else {
                this.mScrollBarRect.left += (int)((float)n2 * f5);
                this.mScrollBarRect.right -= (int)((float)n2 * (1.0f - f6));
            }
            this.mDrawRectArea.set(this.mScrollAreaAbleRect);
            this.mDrawRectBar.set(this.mScrollBarRect);
            if (this.isVertical()) {
                if (this.mDrawRectArea.width() > this.mDrawRectArea.height()) {
                    this.mDrawRectArea.bottom = Math.min((float)this.mScrollAreaRect.bottom, this.mDrawRectArea.top + this.mDrawRectArea.width());
                    if (this.mDrawRectArea.width() > this.mDrawRectArea.height()) {
                        this.mDrawRectArea.top = this.mDrawRectArea.bottom - this.mDrawRectArea.width();
                    }
                }
            } else if (this.mDrawRectArea.width() < this.mDrawRectArea.height()) {
                this.mDrawRectArea.right = Math.min((float)this.mScrollAreaRect.right, this.mDrawRectArea.left + this.mDrawRectArea.height());
                if (this.mDrawRectArea.width() < this.mDrawRectArea.height()) {
                    this.mDrawRectArea.left = this.mDrawRectArea.right - this.mDrawRectArea.height();
                }
            }
            if (this.mBarDrawable != null) {
                float f7 = 0.0f;
                float f8 = 0.0f;
                float f9 = 0.0f;
                this.mDrawableDrawRect.set(this.mScrollAreaRect);
                if (this.isVertical()) {
                    f7 = (float)this.mScrollAreaRect.width() / Math.max((float)this.mBarDrawable.getIntrinsicWidth(), 1.0f);
                    f8 = Math.max((float)this.mBarDrawable.getIntrinsicHeight() * f7, 1.0f);
                    this.mDrawable_Bar_Ratio = ((float)this.mScrollAreaRect.height() - f8) / (float)this.mScrollAreaRect.height();
                    f9 = (float)this.mScrollAreaRect.height() * ((float)n / (f3 - f2));
                    this.mDrawableDrawRect.top = (int)((float)this.mDrawableDrawRect.top + f9);
                    this.mDrawableDrawRect.bottom = (int)((float)this.mDrawableDrawRect.top + f8);
                } else {
                    f7 = (float)this.mScrollAreaRect.height() / Math.max((float)this.mBarDrawable.getIntrinsicHeight(), 1.0f);
                    f8 = Math.max((float)this.mBarDrawable.getIntrinsicWidth() * f7, 1.0f);
                    this.mDrawable_Bar_Ratio = ((float)this.mScrollAreaRect.width() - f8) / (float)this.mScrollAreaRect.width();
                    f9 = (float)this.mScrollAreaRect.width() * f5 + (float)this.mScrollAreaRect.width() * (f4 - (1.0f - this.mDrawable_Bar_Ratio)) * (f5 / (1.0f - f4));
                    this.mDrawableDrawRect.left = (int)((float)this.mDrawableDrawRect.left + f9);
                    this.mDrawableDrawRect.right = (int)((float)this.mDrawableDrawRect.left + f8);
                }
                this.mDrawableRealDrawRect.set(this.mDrawableDrawRect);
                int n4 = this.isVertical() ? this.mScrollAreaRect.height() : this.mScrollAreaRect.width();
                if (f8 < (float)n4 && !this.mScrollAreaRect.contains(this.mDrawableRealDrawRect)) {
                    this.mDrawableRealDrawRect.set(this.mScrollAreaRect);
                    if (this.isVertical()) {
                        this.mDrawableRealDrawRect.top = (int)((float)this.mDrawableRealDrawRect.bottom - f8);
                    } else {
                        this.mDrawableRealDrawRect.left = (int)((float)this.mDrawableRealDrawRect.right - f8);
                    }
                }
                this.mTouchRectBar.set(this.mDrawableRealDrawRect);
            } else {
                this.mTouchRectBar.set(this.mDrawRectBar);
            }
            this.mNowLocation = f5;
            this.mTouchRectBar.inset((float)(-((int)OZStorage.padding_1) * this.mBarMargin), (float)(-((int)OZStorage.padding_1) * this.mBarMargin));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        OZSignpadScrollView$ScrollCommand oZSignpadScrollView$ScrollCommand = this.getCommand();
        if (oZSignpadScrollView$ScrollCommand != null) {
            if (this.mNeedUpdate) {
                this.mScrollAreaAbleRect.set(0, 0, canvas.getWidth(), canvas.getHeight());
                this.mScrollAreaRect.set(this.mScrollAreaAbleRect);
                this.mScrollAreaRect.inset((int)OZStorage.padding_1 * this.mBarMargin, (int)(OZStorage.padding_1 * (float)this.mBarMargin));
                this.mScrollBarRect.setEmpty();
                this.mDrawableDrawRect.setEmpty();
                this.mDrawableRealDrawRect.setEmpty();
                this.updateScrollBarRect(oZSignpadScrollView$ScrollCommand.getCurrentScroll(), oZSignpadScrollView$ScrollCommand.getScrollSize(), oZSignpadScrollView$ScrollCommand.getContentSize());
                this.mNeedUpdate = false;
            }
            if (!this.mScrollBarRect.isEmpty()) {
                if (this.mBarDrawable == null) {
                    float f2 = (this.isVertical() ? this.mDrawRectArea.width() : this.mDrawRectArea.height()) / 2.0f;
                    canvas.drawRoundRect(this.mDrawRectArea, f2, f2, this.mAreaPaint);
                    f2 = (this.isVertical() ? this.mDrawRectBar.width() : this.mDrawRectBar.height()) / 2.0f;
                    canvas.drawRoundRect(this.mDrawRectBar, f2, f2, this.mBarPaint);
                } else {
                    this.mBarDrawable.setBounds(this.mDrawableRealDrawRect);
                    this.mBarDrawable.draw(canvas);
                }
            }
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = false;
        if (!this.mScrollBarRect.isEmpty()) {
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    OZSignpadScrollView$ScrollCommand oZSignpadScrollView$ScrollCommand;
                    if (!this.mTouchRectBar.contains(motionEvent.getX(), motionEvent.getY()) || (oZSignpadScrollView$ScrollCommand = this.getCommand()) == null) break;
                    this.mStartX = (int)motionEvent.getX();
                    this.mStartY = (int)motionEvent.getY();
                    this.mStartLocation = this.mBarDrawable == null ? this.mNowLocation : (float)(this.isVertical() ? this.mDrawableRealDrawRect.top - this.mScrollAreaRect.top : this.mDrawableRealDrawRect.left - this.mScrollAreaRect.left) / (float)(this.isVertical() ? this.mScrollAreaRect.height() : this.mScrollAreaRect.width());
                    this.mStartRealLocation = (float)(this.isVertical() ? this.mStartY - this.mScrollAreaRect.top : this.mStartX - this.mScrollAreaRect.left) / (float)(this.isVertical() ? this.mScrollAreaRect.height() : this.mScrollAreaRect.width());
                    this.mIsMove = true;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!this.mIsMove) break;
                    OZSignpadScrollView$ScrollCommand oZSignpadScrollView$ScrollCommand = this.getCommand();
                    if (oZSignpadScrollView$ScrollCommand != null) {
                        float f2 = (this.isVertical() ? motionEvent.getY() - (float)this.mScrollAreaRect.top : motionEvent.getX() - (float)this.mScrollAreaRect.left) / (float)(this.isVertical() ? this.mScrollAreaRect.height() : this.mScrollAreaRect.width());
                        f2 -= this.mStartRealLocation - this.mStartLocation;
                        f2 = Math.min(1.0f, Math.max(0.0f, f2));
                        int n = 0;
                        if (this.mBarDrawable == null) {
                            n = (int)((float)oZSignpadScrollView$ScrollCommand.getContentSize() * f2);
                        } else {
                            float f3 = (float)oZSignpadScrollView$ScrollCommand.getScrollSize() / (float)oZSignpadScrollView$ScrollCommand.getContentSize();
                            float f4 = f2 / this.mDrawable_Bar_Ratio;
                            n = (int)(f4 * (1.0f - f3) * (float)oZSignpadScrollView$ScrollCommand.getContentSize());
                        }
                        oZSignpadScrollView$ScrollCommand.scrollTo(n);
                        this.requestUpdateScroll();
                        this.invalidate();
                    }
                    bl = true;
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    if (!this.mIsMove) break;
                    this.mIsMove = false;
                    bl = true;
                }
            }
        }
        return bl;
    }
}

