/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oz.lottie.FontAssetDelegate;
import oz.lottie.ImageAssetDelegate;
import oz.lottie.L;
import oz.lottie.LottieComposition;
import oz.lottie.LottieDrawable$1;
import oz.lottie.LottieDrawable$10;
import oz.lottie.LottieDrawable$11;
import oz.lottie.LottieDrawable$12;
import oz.lottie.LottieDrawable$13;
import oz.lottie.LottieDrawable$14;
import oz.lottie.LottieDrawable$15;
import oz.lottie.LottieDrawable$16;
import oz.lottie.LottieDrawable$17;
import oz.lottie.LottieDrawable$2;
import oz.lottie.LottieDrawable$3;
import oz.lottie.LottieDrawable$4;
import oz.lottie.LottieDrawable$5;
import oz.lottie.LottieDrawable$6;
import oz.lottie.LottieDrawable$7;
import oz.lottie.LottieDrawable$8;
import oz.lottie.LottieDrawable$9;
import oz.lottie.LottieDrawable$LazyCompositionTask;
import oz.lottie.LottieProperty;
import oz.lottie.PerformanceTracker;
import oz.lottie.TextDelegate;
import oz.lottie.manager.FontAssetManager;
import oz.lottie.manager.ImageAssetManager;
import oz.lottie.model.KeyPath;
import oz.lottie.model.Marker;
import oz.lottie.model.layer.CompositionLayer;
import oz.lottie.parser.LayerParser;
import oz.lottie.utils.Logger;
import oz.lottie.utils.LottieValueAnimator;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;
import oz.lottie.value.SimpleLottieValueCallback;

public class LottieDrawable
extends Drawable
implements Animatable,
Drawable.Callback {
    private static final String TAG = LottieDrawable.class.getSimpleName();
    private final Matrix matrix = new Matrix();
    private LottieComposition composition;
    private final LottieValueAnimator animator = new LottieValueAnimator();
    private float scale = 1.0f;
    private boolean systemAnimationsEnabled = true;
    private boolean safeMode = false;
    private final Set colorFilterData = new HashSet();
    private final ArrayList lazyCompositionTasks = new ArrayList();
    private final ValueAnimator.AnimatorUpdateListener progressUpdateListener = new LottieDrawable$1(this);
    private ImageView.ScaleType scaleType;
    private ImageAssetManager imageAssetManager;
    private String imageAssetsFolder;
    private ImageAssetDelegate imageAssetDelegate;
    private FontAssetManager fontAssetManager;
    FontAssetDelegate fontAssetDelegate;
    TextDelegate textDelegate;
    private boolean enableMergePaths;
    private CompositionLayer compositionLayer;
    private int alpha = 255;
    private boolean performanceTrackingEnabled;
    private boolean isApplyingOpacityToLayersEnabled;
    private boolean isExtraScaleEnabled = true;
    private boolean isDirty = false;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public LottieDrawable() {
        this.animator.addUpdateListener(this.progressUpdateListener);
    }

    public boolean hasMasks() {
        return this.compositionLayer != null && this.compositionLayer.hasMasks();
    }

    public boolean hasMatte() {
        return this.compositionLayer != null && this.compositionLayer.hasMatte();
    }

    public boolean enableMergePathsForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void enableMergePathsForKitKatAndAbove(boolean bl) {
        if (this.enableMergePaths == bl) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            Logger.warning("Merge paths are not supported pre-Kit Kat.");
            return;
        }
        this.enableMergePaths = bl;
        if (this.composition != null) {
            this.buildCompositionLayer();
        }
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void setImagesAssetsFolder(String string) {
        this.imageAssetsFolder = string;
    }

    public String getImageAssetsFolder() {
        return this.imageAssetsFolder;
    }

    public boolean setComposition(LottieComposition lottieComposition) {
        if (this.composition == lottieComposition) {
            return false;
        }
        this.isDirty = false;
        this.clearComposition();
        this.composition = lottieComposition;
        this.buildCompositionLayer();
        this.animator.setComposition(lottieComposition);
        this.setProgress(this.animator.getAnimatedFraction());
        this.setScale(this.scale);
        this.updateBounds();
        Iterator iterator = new ArrayList(this.lazyCompositionTasks).iterator();
        while (iterator.hasNext()) {
            LottieDrawable$LazyCompositionTask lottieDrawable$LazyCompositionTask = (LottieDrawable$LazyCompositionTask)iterator.next();
            lottieDrawable$LazyCompositionTask.run(lottieComposition);
            iterator.remove();
        }
        this.lazyCompositionTasks.clear();
        lottieComposition.setPerformanceTrackingEnabled(this.performanceTrackingEnabled);
        return true;
    }

    public void setPerformanceTrackingEnabled(boolean bl) {
        this.performanceTrackingEnabled = bl;
        if (this.composition != null) {
            this.composition.setPerformanceTrackingEnabled(bl);
        }
    }

    public PerformanceTracker getPerformanceTracker() {
        if (this.composition != null) {
            return this.composition.getPerformanceTracker();
        }
        return null;
    }

    public void setApplyingOpacityToLayersEnabled(boolean bl) {
        this.isApplyingOpacityToLayersEnabled = bl;
    }

    public void disableExtraScaleModeInFitXY() {
        this.isExtraScaleEnabled = false;
    }

    public boolean isApplyingOpacityToLayersEnabled() {
        return this.isApplyingOpacityToLayersEnabled;
    }

    private void buildCompositionLayer() {
        this.compositionLayer = new CompositionLayer(this, LayerParser.parse(this.composition), this.composition.getLayers(), this.composition);
    }

    public void clearComposition() {
        if (this.animator.isRunning()) {
            this.animator.cancel();
        }
        this.composition = null;
        this.compositionLayer = null;
        this.imageAssetManager = null;
        this.animator.clearComposition();
        this.invalidateSelf();
    }

    public void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    public void invalidateSelf() {
        if (this.isDirty) {
            return;
        }
        this.isDirty = true;
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void setAlpha(int n) {
        this.alpha = n;
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        Logger.warning("Use addColorFilter instead.");
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        this.isDirty = false;
        L.beginSection("Drawable#draw");
        if (this.safeMode) {
            try {
                this.drawInternal(canvas);
            }
            catch (Throwable throwable) {
                Logger.error("Lottie crashed in draw!", throwable);
            }
        } else {
            this.drawInternal(canvas);
        }
        L.endSection("Drawable#draw");
    }

    private void drawInternal(Canvas canvas) {
        if (ImageView.ScaleType.FIT_XY == this.scaleType) {
            this.drawWithNewAspectRatio(canvas);
        } else {
            this.drawWithOriginalAspectRatio(canvas);
        }
    }

    public void start() {
        this.playAnimation();
    }

    public void stop() {
        this.endAnimation();
    }

    public boolean isRunning() {
        return this.isAnimating();
    }

    public void playAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$2(this));
            return;
        }
        if (this.systemAnimationsEnabled || this.getRepeatCount() == 0) {
            this.animator.playAnimation();
        }
        if (!this.systemAnimationsEnabled) {
            this.setFrame((int)(this.getSpeed() < 0.0f ? this.getMinFrame() : this.getMaxFrame()));
            this.animator.endAnimation();
        }
    }

    public void endAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.endAnimation();
    }

    public void resumeAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$3(this));
            return;
        }
        if (this.systemAnimationsEnabled || this.getRepeatCount() == 0) {
            this.animator.resumeAnimation();
        }
        if (!this.systemAnimationsEnabled) {
            this.setFrame((int)(this.getSpeed() < 0.0f ? this.getMinFrame() : this.getMaxFrame()));
            this.animator.endAnimation();
        }
    }

    public void setMinFrame(int n) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$4(this, n));
            return;
        }
        this.animator.setMinFrame(n);
    }

    public float getMinFrame() {
        return this.animator.getMinFrame();
    }

    public void setMinProgress(float f2) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$5(this, f2));
            return;
        }
        this.setMinFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), f2));
    }

    public void setMaxFrame(int n) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$6(this, n));
            return;
        }
        this.animator.setMaxFrame((float)n + 0.99f);
    }

    public float getMaxFrame() {
        return this.animator.getMaxFrame();
    }

    public void setMaxProgress(float f2) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$7(this, f2));
            return;
        }
        this.setMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), f2));
    }

    public void setMinFrame(String string) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$8(this, string));
            return;
        }
        Marker marker = this.composition.getMarker(string);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + string + ".");
        }
        this.setMinFrame((int)marker.startFrame);
    }

    public void setMaxFrame(String string) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$9(this, string));
            return;
        }
        Marker marker = this.composition.getMarker(string);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + string + ".");
        }
        this.setMaxFrame((int)(marker.startFrame + marker.durationFrames));
    }

    public void setMinAndMaxFrame(String string) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$10(this, string));
            return;
        }
        Marker marker = this.composition.getMarker(string);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + string + ".");
        }
        int n = (int)marker.startFrame;
        this.setMinAndMaxFrame(n, n + (int)marker.durationFrames);
    }

    public void setMinAndMaxFrame(String string, String string2, boolean bl) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$11(this, string, string2, bl));
            return;
        }
        Marker marker = this.composition.getMarker(string);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + string + ".");
        }
        int n = (int)marker.startFrame;
        Marker marker2 = this.composition.getMarker(string2);
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + string2 + ".");
        }
        int n2 = (int)(marker2.startFrame + (bl ? 1.0f : 0.0f));
        this.setMinAndMaxFrame(n, n2);
    }

    public void setMinAndMaxFrame(int n, int n2) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$12(this, n, n2));
            return;
        }
        this.animator.setMinAndMaxFrames(n, (float)n2 + 0.99f);
    }

    public void setMinAndMaxProgress(float f2, float f3) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$13(this, f2, f3));
            return;
        }
        this.setMinAndMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), f2), (int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), f3));
    }

    public void reverseAnimationSpeed() {
        this.animator.reverseAnimationSpeed();
    }

    public void setSpeed(float f2) {
        this.animator.setSpeed(f2);
    }

    public float getSpeed() {
        return this.animator.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        this.animator.addUpdateListener(animatorUpdateListener);
    }

    public void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        this.animator.removeUpdateListener(animatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        this.animator.removeAllUpdateListeners();
        this.animator.addUpdateListener(this.progressUpdateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.animator.addListener(animatorListener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.animator.removeListener(animatorListener);
    }

    public void removeAllAnimatorListeners() {
        this.animator.removeAllListeners();
    }

    public void setFrame(int n) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$14(this, n));
            return;
        }
        this.animator.setFrame(n);
    }

    public int getFrame() {
        return (int)this.animator.getFrame();
    }

    public void setProgress(float f2) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$15(this, f2));
            return;
        }
        L.beginSection("Drawable#setProgress");
        this.animator.setFrame(MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), f2));
        L.endSection("Drawable#setProgress");
    }

    public void loop(boolean bl) {
        this.animator.setRepeatCount(bl ? -1 : 0);
    }

    public void setRepeatMode(int n) {
        this.animator.setRepeatMode(n);
    }

    public int getRepeatMode() {
        return this.animator.getRepeatMode();
    }

    public void setRepeatCount(int n) {
        this.animator.setRepeatCount(n);
    }

    public int getRepeatCount() {
        return this.animator.getRepeatCount();
    }

    public boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    public boolean isAnimating() {
        if (this.animator == null) {
            return false;
        }
        return this.animator.isRunning();
    }

    void setSystemAnimationsAreEnabled(Boolean bl) {
        this.systemAnimationsEnabled = bl;
    }

    public void setScale(float f2) {
        this.scale = f2;
        this.updateBounds();
    }

    public void setImageAssetDelegate(ImageAssetDelegate imageAssetDelegate) {
        this.imageAssetDelegate = imageAssetDelegate;
        if (this.imageAssetManager != null) {
            this.imageAssetManager.setDelegate(imageAssetDelegate);
        }
    }

    public void setFontAssetDelegate(FontAssetDelegate fontAssetDelegate) {
        this.fontAssetDelegate = fontAssetDelegate;
        if (this.fontAssetManager != null) {
            this.fontAssetManager.setDelegate(fontAssetDelegate);
        }
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.textDelegate = textDelegate;
    }

    public TextDelegate getTextDelegate() {
        return this.textDelegate;
    }

    public boolean useTextGlyphs() {
        return this.textDelegate == null && this.composition.getCharacters().size() > 0;
    }

    public float getScale() {
        return this.scale;
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    private void updateBounds() {
        if (this.composition == null) {
            return;
        }
        float f2 = this.getScale();
        this.setBounds(0, 0, (int)((float)this.composition.getBounds().width() * f2), (int)((float)this.composition.getBounds().height() * f2));
    }

    public void cancelAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.cancel();
    }

    public void pauseAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.pauseAnimation();
    }

    public float getProgress() {
        return this.animator.getAnimatedValueAbsolute();
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().width() * this.getScale());
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().height() * this.getScale());
    }

    public List resolveKeyPath(KeyPath keyPath) {
        if (this.compositionLayer == null) {
            Logger.warning("Cannot resolve KeyPath. Composition is not set yet.");
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        this.compositionLayer.resolveKeyPath(keyPath, 0, arrayList, new KeyPath(new String[0]));
        return arrayList;
    }

    public void addValueCallback(KeyPath keyPath, Object object, LottieValueCallback lottieValueCallback) {
        boolean bl;
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LottieDrawable$16(this, keyPath, object, lottieValueCallback));
            return;
        }
        if (keyPath.getResolvedElement() != null) {
            keyPath.getResolvedElement().addValueCallback(object, lottieValueCallback);
            bl = true;
        } else {
            List list = this.resolveKeyPath(keyPath);
            int n = 0;
            while (n < list.size()) {
                ((KeyPath)list.get(n)).getResolvedElement().addValueCallback(object, lottieValueCallback);
                ++n;
            }
            boolean bl2 = bl = !list.isEmpty();
        }
        if (bl) {
            this.invalidateSelf();
            if (object == LottieProperty.TIME_REMAP) {
                this.setProgress(this.getProgress());
            }
        }
    }

    public void addValueCallback(KeyPath keyPath, Object object, SimpleLottieValueCallback simpleLottieValueCallback) {
        this.addValueCallback(keyPath, object, new LottieDrawable$17(this, simpleLottieValueCallback));
    }

    public Bitmap updateBitmap(String string, Bitmap bitmap) {
        ImageAssetManager imageAssetManager = this.getImageAssetManager();
        if (imageAssetManager == null) {
            Logger.warning("Cannot update bitmap. Most likely the drawable is not added to a View which prevents Lottie from getting a Context.");
            return null;
        }
        Bitmap bitmap2 = imageAssetManager.updateBitmap(string, bitmap);
        this.invalidateSelf();
        return bitmap2;
    }

    public Bitmap getImageAsset(String string) {
        ImageAssetManager imageAssetManager = this.getImageAssetManager();
        if (imageAssetManager != null) {
            return imageAssetManager.bitmapForId(string);
        }
        return null;
    }

    private ImageAssetManager getImageAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.imageAssetManager != null && !this.imageAssetManager.hasSameContext(this.getContext())) {
            this.imageAssetManager = null;
        }
        if (this.imageAssetManager == null) {
            this.imageAssetManager = new ImageAssetManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetManager;
    }

    public Typeface getTypeface(String string, String string2) {
        FontAssetManager fontAssetManager = this.getFontAssetManager();
        if (fontAssetManager != null) {
            return fontAssetManager.getTypeface(string, string2);
        }
        return null;
    }

    private FontAssetManager getFontAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.fontAssetManager == null) {
            this.fontAssetManager = new FontAssetManager(this.getCallback(), this.fontAssetDelegate);
        }
        return this.fontAssetManager;
    }

    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, runnable, l);
    }

    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, runnable);
    }

    void setScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    private float getMaxScale(Canvas canvas) {
        float f2 = (float)canvas.getWidth() / (float)this.composition.getBounds().width();
        float f3 = (float)canvas.getHeight() / (float)this.composition.getBounds().height();
        return Math.min(f2, f3);
    }

    private void drawWithNewAspectRatio(Canvas canvas) {
        if (this.compositionLayer == null) {
            return;
        }
        int n = -1;
        Rect rect = this.getBounds();
        float f2 = (float)rect.width() / (float)this.composition.getBounds().width();
        float f3 = (float)rect.height() / (float)this.composition.getBounds().height();
        if (this.isExtraScaleEnabled) {
            float f4 = Math.min(f2, f3);
            float f5 = 1.0f;
            if (f4 < 1.0f) {
                f2 /= (f5 /= f4);
                f3 /= f5;
            }
            if (f5 > 1.0f) {
                n = canvas.save();
                float f6 = (float)rect.width() / 2.0f;
                float f7 = (float)rect.height() / 2.0f;
                float f8 = f6 * f4;
                float f9 = f7 * f4;
                canvas.translate(f6 - f8, f7 - f9);
                canvas.scale(f5, f5, f8, f9);
            }
        }
        this.matrix.reset();
        this.matrix.preScale(f2, f3);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
        if (n > 0) {
            canvas.restoreToCount(n);
        }
    }

    private void drawWithOriginalAspectRatio(Canvas canvas) {
        if (this.compositionLayer == null) {
            return;
        }
        float f2 = this.scale;
        float f3 = 1.0f;
        float f4 = this.getMaxScale(canvas);
        if (f2 > f4) {
            f2 = f4;
            f3 = this.scale / f2;
        }
        int n = -1;
        if (f3 > 1.0f) {
            n = canvas.save();
            float f5 = (float)this.composition.getBounds().width() / 2.0f;
            float f6 = (float)this.composition.getBounds().height() / 2.0f;
            float f7 = f5 * f2;
            float f8 = f6 * f2;
            canvas.translate(this.getScale() * f5 - f7, this.getScale() * f6 - f8);
            canvas.scale(f3, f3, f7, f8);
        }
        this.matrix.reset();
        this.matrix.preScale(f2, f2);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
        if (n > 0) {
            canvas.restoreToCount(n);
        }
    }

    static /* synthetic */ CompositionLayer access$0(LottieDrawable lottieDrawable) {
        return lottieDrawable.compositionLayer;
    }

    static /* synthetic */ LottieValueAnimator access$1(LottieDrawable lottieDrawable) {
        return lottieDrawable.animator;
    }
}

