/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import java.util.HashMap;
import java.util.Map;
import oz.lottie.LottieAnimationView;
import oz.lottie.LottieDrawable;

public class TextDelegate {
    private final Map stringMap = new HashMap();
    private final LottieAnimationView animationView;
    private final LottieDrawable drawable;
    private boolean cacheText = true;

    TextDelegate() {
        this.animationView = null;
        this.drawable = null;
    }

    public TextDelegate(LottieAnimationView lottieAnimationView) {
        this.animationView = lottieAnimationView;
        this.drawable = null;
    }

    public TextDelegate(LottieDrawable lottieDrawable) {
        this.drawable = lottieDrawable;
        this.animationView = null;
    }

    private String getText(String string) {
        return string;
    }

    public void setText(String string, String string2) {
        this.stringMap.put(string, string2);
        this.invalidate();
    }

    public void setCacheText(boolean bl) {
        this.cacheText = bl;
    }

    public void invalidateText(String string) {
        this.stringMap.remove(string);
        this.invalidate();
    }

    public void invalidateAllText() {
        this.stringMap.clear();
        this.invalidate();
    }

    public final String getTextInternal(String string) {
        if (this.cacheText && this.stringMap.containsKey(string)) {
            return (String)this.stringMap.get(string);
        }
        String string2 = this.getText(string);
        if (this.cacheText) {
            this.stringMap.put(string, string2);
        }
        return string2;
    }

    private void invalidate() {
        if (this.animationView != null) {
            this.animationView.invalidate();
        }
        if (this.drawable != null) {
            this.drawable.invalidateSelf();
        }
    }
}

