/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Path;
import android.graphics.PointF;
import java.util.List;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.content.CompoundTrimPathContent;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.content.TrimPathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.PolystarShape;
import oz.lottie.model.content.PolystarShape$Type;
import oz.lottie.model.content.ShapeTrimPath$Type;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;

public class PolystarContent
implements KeyPathElementContent,
PathContent,
BaseKeyframeAnimation$AnimationListener {
    private static final float POLYSTAR_MAGIC_NUMBER = 0.47829f;
    private static final float POLYGON_MAGIC_NUMBER = 0.25f;
    private final Path path = new Path();
    private final String name;
    private final LottieDrawable lottieDrawable;
    private final PolystarShape$Type type;
    private final boolean hidden;
    private final BaseKeyframeAnimation pointsAnimation;
    private final BaseKeyframeAnimation positionAnimation;
    private final BaseKeyframeAnimation rotationAnimation;
    private final BaseKeyframeAnimation innerRadiusAnimation;
    private final BaseKeyframeAnimation outerRadiusAnimation;
    private final BaseKeyframeAnimation innerRoundednessAnimation;
    private final BaseKeyframeAnimation outerRoundednessAnimation;
    private CompoundTrimPathContent trimPaths = new CompoundTrimPathContent();
    private boolean isPathValid;

    public PolystarContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, PolystarShape polystarShape) {
        this.lottieDrawable = lottieDrawable;
        this.name = polystarShape.getName();
        this.type = polystarShape.getType();
        this.hidden = polystarShape.isHidden();
        this.pointsAnimation = polystarShape.getPoints().createAnimation();
        this.positionAnimation = polystarShape.getPosition().createAnimation();
        this.rotationAnimation = polystarShape.getRotation().createAnimation();
        this.outerRadiusAnimation = polystarShape.getOuterRadius().createAnimation();
        this.outerRoundednessAnimation = polystarShape.getOuterRoundedness().createAnimation();
        if (this.type == PolystarShape$Type.STAR) {
            this.innerRadiusAnimation = polystarShape.getInnerRadius().createAnimation();
            this.innerRoundednessAnimation = polystarShape.getInnerRoundedness().createAnimation();
        } else {
            this.innerRadiusAnimation = null;
            this.innerRoundednessAnimation = null;
        }
        baseLayer.addAnimation(this.pointsAnimation);
        baseLayer.addAnimation(this.positionAnimation);
        baseLayer.addAnimation(this.rotationAnimation);
        baseLayer.addAnimation(this.outerRadiusAnimation);
        baseLayer.addAnimation(this.outerRoundednessAnimation);
        if (this.type == PolystarShape$Type.STAR) {
            baseLayer.addAnimation(this.innerRadiusAnimation);
            baseLayer.addAnimation(this.innerRoundednessAnimation);
        }
        this.pointsAnimation.addUpdateListener(this);
        this.positionAnimation.addUpdateListener(this);
        this.rotationAnimation.addUpdateListener(this);
        this.outerRadiusAnimation.addUpdateListener(this);
        this.outerRoundednessAnimation.addUpdateListener(this);
        if (this.type == PolystarShape$Type.STAR) {
            this.innerRadiusAnimation.addUpdateListener(this);
            this.innerRoundednessAnimation.addUpdateListener(this);
        }
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            Content content = (Content)list.get(n);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath$Type.SIMULTANEOUSLY) {
                TrimPathContent trimPathContent = (TrimPathContent)content;
                this.trimPaths.addTrimPath(trimPathContent);
                trimPathContent.addListener(this);
            }
            ++n;
        }
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        if (this.hidden) {
            this.isPathValid = true;
            return this.path;
        }
        switch (this.type) {
            case STAR: {
                this.createStarPath();
                break;
            }
            case POLYGON: {
                this.createPolygonPath();
            }
        }
        this.path.close();
        this.trimPaths.apply(this.path);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createStarPath() {
        float f2;
        float f3;
        float f4 = ((Float)this.pointsAnimation.getValue()).floatValue();
        double d2 = this.rotationAnimation == null ? 0.0f : ((Float)this.rotationAnimation.getValue()).floatValue();
        d2 -= 90.0;
        d2 = Math.toRadians(d2);
        float f5 = (float)(Math.PI * 2 / (double)f4);
        float f6 = f5 / 2.0f;
        float f7 = f4 - (float)((int)f4);
        if (f7 != 0.0f) {
            d2 += (double)(f6 * (1.0f - f7));
        }
        float f8 = ((Float)this.outerRadiusAnimation.getValue()).floatValue();
        float f9 = ((Float)this.innerRadiusAnimation.getValue()).floatValue();
        float f10 = 0.0f;
        if (this.innerRoundednessAnimation != null) {
            f10 = ((Float)this.innerRoundednessAnimation.getValue()).floatValue() / 100.0f;
        }
        float f11 = 0.0f;
        if (this.outerRoundednessAnimation != null) {
            f11 = ((Float)this.outerRoundednessAnimation.getValue()).floatValue() / 100.0f;
        }
        float f12 = 0.0f;
        if (f7 != 0.0f) {
            f12 = f9 + f7 * (f8 - f9);
            f3 = (float)((double)f12 * Math.cos(d2));
            f2 = (float)((double)f12 * Math.sin(d2));
            this.path.moveTo(f3, f2);
            d2 += (double)(f5 * f7 / 2.0f);
        } else {
            f3 = (float)((double)f8 * Math.cos(d2));
            f2 = (float)((double)f8 * Math.sin(d2));
            this.path.moveTo(f3, f2);
            d2 += (double)f6;
        }
        boolean bl = false;
        double d3 = Math.ceil(f4) * 2.0;
        int n = 0;
        while ((double)n < d3) {
            float f13 = bl ? f8 : f9;
            float f14 = f6;
            if (f12 != 0.0f && (double)n == d3 - 2.0) {
                f14 = f5 * f7 / 2.0f;
            }
            if (f12 != 0.0f && (double)n == d3 - 1.0) {
                f13 = f12;
            }
            float f15 = f3;
            float f16 = f2;
            f3 = (float)((double)f13 * Math.cos(d2));
            f2 = (float)((double)f13 * Math.sin(d2));
            if (f10 == 0.0f && f11 == 0.0f) {
                this.path.lineTo(f3, f2);
            } else {
                float f17 = (float)(Math.atan2(f16, f15) - 1.5707963267948966);
                float f18 = (float)Math.cos(f17);
                float f19 = (float)Math.sin(f17);
                float f20 = (float)(Math.atan2(f2, f3) - 1.5707963267948966);
                float f21 = (float)Math.cos(f20);
                float f22 = (float)Math.sin(f20);
                float f23 = bl ? f10 : f11;
                float f24 = bl ? f11 : f10;
                float f25 = bl ? f9 : f8;
                float f26 = bl ? f8 : f9;
                float f27 = f25 * f23 * 0.47829f * f18;
                float f28 = f25 * f23 * 0.47829f * f19;
                float f29 = f26 * f24 * 0.47829f * f21;
                float f30 = f26 * f24 * 0.47829f * f22;
                if (f7 != 0.0f) {
                    if (n == 0) {
                        f27 *= f7;
                        f28 *= f7;
                    } else if ((double)n == d3 - 1.0) {
                        f29 *= f7;
                        f30 *= f7;
                    }
                }
                this.path.cubicTo(f15 - f27, f16 - f28, f3 + f29, f2 + f30, f3, f2);
            }
            d2 += (double)f14;
            bl = !bl;
            ++n;
        }
        PointF pointF = (PointF)this.positionAnimation.getValue();
        this.path.offset(pointF.x, pointF.y);
        this.path.close();
    }

    private void createPolygonPath() {
        int n = (int)Math.floor(((Float)this.pointsAnimation.getValue()).floatValue());
        double d2 = this.rotationAnimation == null ? 0.0f : ((Float)this.rotationAnimation.getValue()).floatValue();
        d2 -= 90.0;
        d2 = Math.toRadians(d2);
        float f2 = (float)(Math.PI * 2 / (double)n);
        float f3 = ((Float)this.outerRoundednessAnimation.getValue()).floatValue() / 100.0f;
        float f4 = ((Float)this.outerRadiusAnimation.getValue()).floatValue();
        float f5 = (float)((double)f4 * Math.cos(d2));
        float f6 = (float)((double)f4 * Math.sin(d2));
        this.path.moveTo(f5, f6);
        d2 += (double)f2;
        double d3 = Math.ceil(n);
        int n2 = 0;
        while ((double)n2 < d3) {
            float f7 = f5;
            float f8 = f6;
            f5 = (float)((double)f4 * Math.cos(d2));
            f6 = (float)((double)f4 * Math.sin(d2));
            if (f3 != 0.0f) {
                float f9 = (float)(Math.atan2(f8, f7) - 1.5707963267948966);
                float f10 = (float)Math.cos(f9);
                float f11 = (float)Math.sin(f9);
                float f12 = (float)(Math.atan2(f6, f5) - 1.5707963267948966);
                float f13 = (float)Math.cos(f12);
                float f14 = (float)Math.sin(f12);
                float f15 = f4 * f3 * 0.25f * f10;
                float f16 = f4 * f3 * 0.25f * f11;
                float f17 = f4 * f3 * 0.25f * f13;
                float f18 = f4 * f3 * 0.25f * f14;
                this.path.cubicTo(f7 - f15, f8 - f16, f5 + f17, f6 + f18, f5, f6);
            } else {
                this.path.lineTo(f5, f6);
            }
            d2 += (double)f2;
            ++n2;
        }
        PointF pointF = (PointF)this.positionAnimation.getValue();
        this.path.offset(pointF.x, pointF.y);
        this.path.close();
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.POLYSTAR_POINTS) {
            this.pointsAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POLYSTAR_ROTATION) {
            this.rotationAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POSITION) {
            this.positionAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POLYSTAR_INNER_RADIUS && this.innerRadiusAnimation != null) {
            this.innerRadiusAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POLYSTAR_OUTER_RADIUS) {
            this.outerRadiusAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POLYSTAR_INNER_ROUNDEDNESS && this.innerRoundednessAnimation != null) {
            this.innerRoundednessAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POLYSTAR_OUTER_ROUNDEDNESS) {
            this.outerRoundednessAnimation.setValueCallback(lottieValueCallback);
        }
    }
}

