/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oz.lottie.custom.okio.Buffer$1;
import oz.lottie.custom.okio.Buffer$2;
import oz.lottie.custom.okio.BufferedSink;
import oz.lottie.custom.okio.BufferedSource;
import oz.lottie.custom.okio.ByteString;
import oz.lottie.custom.okio.Options;
import oz.lottie.custom.okio.Segment;
import oz.lottie.custom.okio.SegmentPool;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Source;
import oz.lottie.custom.okio.Timeout;
import oz.lottie.custom.okio.Util;

public final class Buffer
implements Cloneable,
BufferedSink,
BufferedSource {
    Segment head;
    long size;

    public long size() {
        return this.size;
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new Buffer$1(this);
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public BufferedSink emit() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long l) {
        if (this.size < l) {
            throw new EOFException();
        }
    }

    @Override
    public boolean request(long l) {
        return this.size >= l;
    }

    @Override
    public InputStream inputStream() {
        return new Buffer$2(this);
    }

    public Buffer copyTo(OutputStream outputStream) {
        return this.copyTo(outputStream, 0L, this.size);
    }

    public Buffer copyTo(OutputStream outputStream, long l, long l2) {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, l, l2);
        if (l2 == 0L) {
            return this;
        }
        Segment segment = this.head;
        while (l >= (long)(segment.limit - segment.pos)) {
            l -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l2 > 0L) {
            int n = (int)((long)segment.pos + l);
            int n2 = (int)Math.min((long)(segment.limit - n), l2);
            outputStream.write(segment.data, n, n2);
            l2 -= (long)n2;
            l = 0L;
            segment = segment.next;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public Buffer copyTo(Buffer var1_1, long var2_2, long var4_3) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, var2_2, var4_3);
        if (var4_3 == 0L) {
            return this;
        }
        var6_4 = this.head;
        var7_5 = var1_1.writableSegment(1);
        var1_1.size += var4_3;
        ** GOTO lbl23
        {
            var2_2 -= (long)(var6_4.limit - var6_4.pos);
            var6_4 = var6_4.next;
            do {
                if (var2_2 >= (long)(var6_4.limit - var6_4.pos)) continue block0;
                if (var7_5.limit == 2048) {
                    var7_5 = var7_5.push(SegmentPool.INSTANCE.take());
                }
                var8_6 = Math.min((long)var6_4.limit - ((long)var6_4.pos + var2_2), var4_3);
                var10_7 = 2048 - var7_5.limit;
                var12_8 = (int)Math.min(var8_6, var10_7);
                System.arraycopy(var6_4.data, var6_4.pos + (int)var2_2, var7_5.data, var7_5.limit, var12_8);
                var2_2 += (long)var12_8;
                var7_5.limit += var12_8;
                var4_3 -= (long)var12_8;
lbl23:
                // 2 sources

            } while (var4_3 > 0L);
        }
        return this;
    }

    public Buffer writeTo(OutputStream outputStream) {
        return this.writeTo(outputStream, this.size);
    }

    public Buffer writeTo(OutputStream outputStream, long l) {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, 0L, l);
        Segment segment = this.head;
        while (l > 0L) {
            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
            outputStream.write(segment.data, segment.pos, n);
            segment.pos += n;
            this.size -= (long)n;
            l -= (long)n;
            if (segment.pos != segment.limit) continue;
            Segment segment2 = segment;
            this.head = segment = segment2.pop();
            SegmentPool.INSTANCE.recycle(segment2);
        }
        return this;
    }

    public Buffer readFrom(InputStream inputStream) {
        this.readFrom(inputStream, Long.MAX_VALUE, true);
        return this;
    }

    public Buffer readFrom(InputStream inputStream, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        this.readFrom(inputStream, l, false);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private void readFrom(InputStream var1_1, long var2_2, boolean var4_3) {
        if (var1_1 != null) ** GOTO lbl13
        throw new IllegalArgumentException("in == null");
lbl-1000:
        // 1 sources

        {
            var5_4 = this.writableSegment(1);
            var6_5 = (int)Math.min(var2_2, (long)(2048 - var5_4.limit));
            var7_6 = var1_1.read(var5_4.data, var5_4.limit, var6_5);
            if (var7_6 == -1) {
                if (var4_3) {
                    return;
                }
                throw new EOFException();
            }
            var5_4.limit += var7_6;
            this.size += (long)var7_6;
            var2_2 -= (long)var7_6;
lbl13:
            // 2 sources

            ** while (var2_2 > 0L || var4_3)
        }
lbl14:
        // 1 sources

    }

    public long completeSegmentByteCount() {
        long l = this.size;
        if (l == 0L) {
            return 0L;
        }
        Segment segment = this.head.prev;
        if (segment.limit < 2048) {
            l -= (long)(segment.limit - segment.pos);
        }
        return l;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int n = segment.pos;
        int n2 = segment.limit;
        byte[] byArray = segment.data;
        byte by = byArray[n++];
        --this.size;
        if (n == n2) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n;
        }
        return by;
    }

    public byte getByte(long l) {
        Util.checkOffsetAndCount(this.size, l, 1L);
        Segment segment = this.head;
        int n;
        while (l >= (long)(n = segment.limit - segment.pos)) {
            l -= (long)n;
            segment = segment.next;
        }
        return segment.data[segment.pos + (int)l];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 2) {
            int n3 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)n3;
        }
        byte[] byArray = segment.data;
        int n4 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.size -= 2L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return (short)n4;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = segment.data;
        int n3 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.size -= 4L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return n3;
    }

    @Override
    public long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] byArray = segment.data;
        long l = ((long)byArray[n2++] & 0xFFL) << 56 | ((long)byArray[n2++] & 0xFFL) << 48 | ((long)byArray[n2++] & 0xFFL) << 40 | ((long)byArray[n2++] & 0xFFL) << 32 | ((long)byArray[n2++] & 0xFFL) << 24 | ((long)byArray[n2++] & 0xFFL) << 16 | ((long)byArray[n2++] & 0xFFL) << 8 | (long)byArray[n2++] & 0xFFL;
        this.size -= 8L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return l;
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public ByteString readByteString(long l) {
        return new ByteString(this.readByteArray(l));
    }

    @Override
    public void readFully(Buffer buffer, long l) {
        if (this.size < l) {
            buffer.write(this, this.size);
            throw new EOFException();
        }
        buffer.write(this, l);
    }

    @Override
    public long readAll(Sink sink) {
        long l = this.size;
        if (l > 0L) {
            sink.write(this, l);
        }
        return l;
    }

    @Override
    public String readUtf8() {
        try {
            return this.readString(this.size, Util.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readUtf8(long l) {
        return this.readString(l, Util.UTF_8);
    }

    @Override
    public String readString(Charset charset) {
        try {
            return this.readString(this.size, charset);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readString(long l, Charset charset) {
        Util.checkOffsetAndCount(this.size, 0L, l);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        if (l == 0L) {
            return "";
        }
        Segment segment = this.head;
        if ((long)segment.pos + l > (long)segment.limit) {
            return new String(this.readByteArray(l), charset);
        }
        String string = new String(segment.data, segment.pos, (int)l, charset);
        segment.pos = (int)((long)segment.pos + l);
        this.size -= l;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
        return string;
    }

    @Override
    public String readUtf8Line() {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        return this.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            Buffer buffer = new Buffer();
            this.copyTo(buffer, 0L, Math.min(32L, this.size));
            throw new EOFException("\\n not found: size=" + this.size() + " content=" + buffer.readByteString().hex() + "...");
        }
        return this.readUtf8Line(l);
    }

    String readUtf8Line(long l) {
        if (l > 0L && this.getByte(l - 1L) == 13) {
            String string = this.readUtf8(l - 1L);
            this.skip(2L);
            return string;
        }
        String string = this.readUtf8(l);
        this.skip(1L);
        return string;
    }

    @Override
    public byte[] readByteArray() {
        try {
            return this.readByteArray(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public byte[] readByteArray(long l) {
        Util.checkOffsetAndCount(this.size, 0L, l);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        byte[] byArray = new byte[(int)l];
        this.readFully(byArray);
        return byArray;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = this.read(byArray, n, byArray.length - n);
            if (n2 == -1) {
                throw new EOFException();
            }
            n += n2;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        Util.checkOffsetAndCount(byArray.length, n, n2);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        int n3 = Math.min(n2, segment.limit - segment.pos);
        System.arraycopy(segment.data, segment.pos, byArray, n, n3);
        segment.pos += n3;
        this.size -= (long)n3;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
        return n3;
    }

    public void clear() {
        try {
            this.skip(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public void skip(long l) {
        while (l > 0L) {
            if (this.head == null) {
                throw new EOFException();
            }
            int n = (int)Math.min(l, (long)(this.head.limit - this.head.pos));
            this.size -= (long)n;
            l -= (long)n;
            this.head.pos += n;
            if (this.head.pos != this.head.limit) continue;
            Segment segment = this.head;
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        if (byteString == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        return this.write(byteString.data, 0, byteString.data.length);
    }

    @Override
    public Buffer writeUtf8(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c2;
            char c3 = string.charAt(n);
            if (c3 < '\u0080') {
                Segment segment = this.writableSegment(1);
                byte[] byArray = segment.data;
                int n3 = segment.limit - n;
                int n4 = Math.min(n2, 2048 - n3);
                byArray[n3 + n++] = (byte)c3;
                while (n < n4) {
                    c3 = string.charAt(n);
                    if (c3 >= '\u0080') break;
                    byArray[n3 + n++] = (byte)c3;
                }
                int n5 = n + n3 - segment.limit;
                segment.limit += n5;
                this.size += (long)n5;
                continue;
            }
            if (c3 < '\u0800') {
                this.writeByte(c3 >> 6 | 0xC0);
                this.writeByte(c3 & 0x3F | 0x80);
                ++n;
                continue;
            }
            if (c3 < '\ud800' || c3 > '\udfff') {
                this.writeByte(c3 >> 12 | 0xE0);
                this.writeByte(c3 >> 6 & 0x3F | 0x80);
                this.writeByte(c3 & 0x3F | 0x80);
                ++n;
                continue;
            }
            char c4 = c2 = n + 1 < n2 ? string.charAt(n + 1) : (char)'\u0000';
            if (c3 > '\udbff' || c2 < '\udc00' || c2 > '\udfff') {
                this.writeByte(63);
                ++n;
                continue;
            }
            int n6 = 65536 + ((c3 & 0xFFFF27FF) << 10 | c2 & 0xFFFF23FF);
            this.writeByte(n6 >> 18 | 0xF0);
            this.writeByte(n6 >> 12 & 0x3F | 0x80);
            this.writeByte(n6 >> 6 & 0x3F | 0x80);
            this.writeByte(n6 & 0x3F | 0x80);
            n += 2;
        }
        return this;
    }

    @Override
    public Buffer writeString(String string, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (charset.equals(Util.UTF_8)) {
            return this.writeUtf8(string);
        }
        byte[] byArray = string.getBytes(charset);
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        Util.checkOffsetAndCount(byArray.length, n, n2);
        int n3 = n + n2;
        while (n < n3) {
            Segment segment = this.writableSegment(1);
            int n4 = Math.min(n3 - n, 2048 - segment.limit);
            System.arraycopy(byArray, n, segment.data, segment.limit, n4);
            n += n4;
            segment.limit += n4;
        }
        this.size += (long)n2;
        return this;
    }

    @Override
    public long writeAll(Source source) {
        long l;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l2 = 0L;
        while ((l = source.read(this, 2048L)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @Override
    public BufferedSink write(Source source, long l) {
        if (l > 0L) {
            source.read(this, l);
        }
        return this;
    }

    @Override
    public Buffer writeByte(int n) {
        Segment segment = this.writableSegment(1);
        segment.data[segment.limit++] = (byte)n;
        ++this.size;
        return this;
    }

    @Override
    public Buffer writeShort(int n) {
        Segment segment = this.writableSegment(2);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        segment.limit = n2;
        this.size += 2L;
        return this;
    }

    @Override
    public Buffer writeShortLe(int n) {
        return this.writeShort(Util.reverseBytesShort((short)n));
    }

    @Override
    public Buffer writeInt(int n) {
        Segment segment = this.writableSegment(4);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        segment.limit = n2;
        this.size += 4L;
        return this;
    }

    @Override
    public Buffer writeIntLe(int n) {
        return this.writeInt(Util.reverseBytesInt(n));
    }

    @Override
    public Buffer writeLong(long l) {
        Segment segment = this.writableSegment(8);
        byte[] byArray = segment.data;
        int n = segment.limit;
        byArray[n++] = (byte)(l >>> 56 & 0xFFL);
        byArray[n++] = (byte)(l >>> 48 & 0xFFL);
        byArray[n++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        segment.limit = n;
        this.size += 8L;
        return this;
    }

    @Override
    public Buffer writeLongLe(long l) {
        return this.writeLong(Util.reverseBytesLong(l));
    }

    Segment writableSegment(int n) {
        if (n < 1 || n > 2048) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.INSTANCE.take());
            return this.head.prev;
        }
        Segment segment = this.head.prev;
        if (segment.limit + n > 2048) {
            segment = segment.push(SegmentPool.INSTANCE.take());
        }
        return segment;
    }

    @Override
    public void write(Buffer buffer, long l) {
        if (buffer == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (buffer == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(buffer.size, 0L, l);
        while (l > 0L) {
            Segment segment;
            if (l < (long)(buffer.head.limit - buffer.head.pos)) {
                Segment segment2 = segment = this.head != null ? this.head.prev : null;
                if (segment == null || l + (long)(segment.limit - segment.pos) > 2048L) {
                    buffer.head = buffer.head.split((int)l);
                } else {
                    buffer.head.writeTo(segment, (int)l);
                    buffer.size -= l;
                    this.size += l;
                    return;
                }
            }
            segment = buffer.head;
            long l2 = segment.limit - segment.pos;
            buffer.head = segment.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segment);
            } else {
                Segment segment3 = this.head.prev;
                segment3 = segment3.push(segment);
                segment3.compact();
            }
            buffer.size -= l2;
            this.size += l2;
            l -= l2;
        }
    }

    @Override
    public long read(Buffer buffer, long l) {
        if (buffer == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.size == 0L) {
            return -1L;
        }
        if (l > this.size) {
            l = this.size;
        }
        buffer.write(this, l);
        return l;
    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L);
    }

    @Override
    public long indexOf(byte by, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        long l2 = 0L;
        do {
            int n;
            if (l >= (long)(n = segment.limit - segment.pos)) {
                l -= (long)n;
            } else {
                byte[] byArray = segment.data;
                long l3 = (long)segment.pos + l;
                long l4 = segment.limit;
                while (l3 < l4) {
                    if (byArray[(int)l3] == by) {
                        return l2 + l3 - (long)segment.pos;
                    }
                    ++l3;
                }
                l = 0L;
            }
            l2 += (long)n;
        } while ((segment = segment.next) != this.head);
        return -1L;
    }

    @Override
    public long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString byteString, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        long l2 = 0L;
        byte[] byArray = byteString.data;
        do {
            int n;
            if (l >= (long)(n = segment.limit - segment.pos)) {
                l -= (long)n;
            } else {
                byte[] byArray2 = segment.data;
                long l3 = (long)segment.pos + l;
                long l4 = segment.limit;
                while (l3 < l4) {
                    byte by = byArray2[(int)l3];
                    byte[] byArray3 = byArray;
                    int n2 = byArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        byte by2 = byArray3[n3];
                        if (by == by2) {
                            return l2 + l3 - (long)segment.pos;
                        }
                        ++n3;
                    }
                    ++l3;
                }
                l = 0L;
            }
            l2 += (long)n;
        } while ((segment = segment.next) != this.head);
        return -1L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    List segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            arrayList.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        Buffer buffer = (Buffer)object;
        if (this.size != buffer.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment segment = this.head;
        Segment segment2 = buffer.head;
        int n = segment.pos;
        int n2 = segment2.pos;
        long l = 0L;
        while (l < this.size) {
            long l2 = Math.min(segment.limit - n, segment2.limit - n2);
            int n3 = 0;
            while ((long)n3 < l2) {
                if (segment.data[n++] != segment2.data[n2++]) {
                    return false;
                }
                ++n3;
            }
            if (n == segment.limit) {
                segment = segment.next;
                n = segment.pos;
            }
            if (n2 == segment2.limit) {
                segment2 = segment2.next;
                n2 = segment2.pos;
            }
            l += l2;
        }
        return true;
    }

    public int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n = 1;
        do {
            int n2 = segment.pos;
            int n3 = segment.limit;
            while (n2 < n3) {
                n = 31 * n + segment.data[n2];
                ++n2;
            }
        } while ((segment = segment.next) != this.head);
        return n;
    }

    public String toString() {
        if (this.size == 0L) {
            return "Buffer[size=0]";
        }
        if (this.size <= 16L) {
            ByteString byteString = this.clone().readByteString();
            return String.format("Buffer[size=%s data=%s]", this.size, byteString.hex());
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
            Segment segment = this.head.next;
            while (segment != this.head) {
                messageDigest.update(segment.data, segment.pos, segment.limit - segment.pos);
                segment = segment.next;
            }
            return String.format("Buffer[size=%s md5=%s]", this.size, ByteString.of(messageDigest.digest()).hex());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public Buffer clone() {
        Buffer buffer = new Buffer();
        if (this.size == 0L) {
            return buffer;
        }
        buffer.write(this.head.data, this.head.pos, this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            buffer.write(segment.data, segment.pos, segment.limit - segment.pos);
            segment = segment.next;
        }
        return buffer;
    }

    public final ByteString snapshot() {
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
        }
        return this.snapshot((int)this.size);
    }

    public final ByteString snapshot(int n) {
        if (n == 0) {
            return ByteString.EMPTY;
        }
        try {
            return this.clone().readByteString(n);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public long indexOf(ByteString byteString) {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l) {
        long l2;
        if (byteString.size() == 0) {
            throw new IllegalArgumentException("bytes is empty");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l < l) {
            l2 = this.size;
            while (l2 > l) {
                segment = segment.prev;
                l2 -= (long)(segment.limit - segment.pos);
            }
        } else {
            long l3;
            l2 = 0L;
            while ((l3 = l2 + (long)(segment.limit - segment.pos)) < l) {
                segment = segment.next;
                l2 = l3;
            }
        }
        byte by = byteString.getByte(0);
        int n = byteString.size();
        long l4 = this.size - (long)n + 1L;
        while (l2 < l4) {
            byte[] byArray = segment.data;
            int n2 = (int)Math.min((long)segment.limit, (long)segment.pos + l4 - l2);
            int n3 = (int)((long)segment.pos + l - l2);
            while (n3 < n2) {
                if (byArray[n3] == by && this.rangeEquals(segment, n3 + 1, byteString, 1, n)) {
                    return (long)(n3 - segment.pos) + l2;
                }
                ++n3;
            }
            l = l2 += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    private boolean rangeEquals(Segment segment, int n, ByteString byteString, int n2, int n3) {
        int n4 = segment.limit;
        byte[] byArray = segment.data;
        int n5 = n2;
        while (n5 < n3) {
            if (n == n4) {
                segment = segment.next;
                byArray = segment.data;
                n = segment.pos;
                n4 = segment.limit;
            }
            if (byArray[n] != byteString.getByte(n5)) {
                return false;
            }
            ++n;
            ++n5;
        }
        return true;
    }

    @Override
    public int select(Options options) {
        int n = this.selectPrefix(options, false);
        if (n == -1) {
            return -1;
        }
        int n2 = options.byteStrings[n].size();
        try {
            this.skip(n2);
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
        return n;
    }

    int selectPrefix(Options options, boolean bl) {
        Segment segment = this.head;
        if (segment == null) {
            if (bl) {
                return -2;
            }
            return options.indexOf(ByteString.EMPTY);
        }
        Segment segment2 = segment;
        byte[] byArray = segment.data;
        int n = segment.pos;
        int n2 = segment.limit;
        int[] nArray = options.trie;
        int n3 = 0;
        int n4 = -1;
        block0: while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = nArray[n3++];
            if ((n9 = nArray[n3++]) != -1) {
                n4 = n9;
            }
            if (segment2 == null) break;
            if (n10 < 0) {
                boolean bl2;
                n8 = -1 * n10;
                n7 = n3 + n8;
                do {
                    if ((n6 = byArray[n++] & 0xFF) != nArray[n3++]) {
                        return n4;
                    }
                    boolean bl3 = bl2 = n3 == n7;
                    if (n != n2) continue;
                    segment2 = segment2.next;
                    n = segment2.pos;
                    byArray = segment2.data;
                    n2 = segment2.limit;
                    if (segment2 != segment) continue;
                    if (!bl2) break block0;
                    segment2 = null;
                } while (!bl2);
                n5 = nArray[n3];
            } else {
                n8 = n10;
                n7 = byArray[n++] & 0xFF;
                n6 = n3 + n8;
                while (true) {
                    if (n3 == n6) {
                        return n4;
                    }
                    if (n7 == nArray[n3]) break;
                    ++n3;
                }
                n5 = nArray[n3 + n8];
                if (n == n2) {
                    segment2 = segment2.next;
                    n = segment2.pos;
                    byArray = segment2.data;
                    n2 = segment2.limit;
                    if (segment2 == segment) {
                        segment2 = null;
                    }
                }
            }
            if (n5 >= 0) {
                return n5;
            }
            n3 = -n5;
        }
        if (bl) {
            return -2;
        }
        return n4;
    }

    @Override
    public Buffer writeUtf8(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + n);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n2 + " < " + n);
        }
        if (n2 > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n2 + " > " + string.length());
        }
        int n3 = n;
        while (n3 < n2) {
            char c2;
            char c3 = string.charAt(n3);
            if (c3 < '\u0080') {
                Segment segment = this.writableSegment(1);
                byte[] byArray = segment.data;
                int n4 = segment.limit - n3;
                int n5 = Math.min(n2, 2048 - n4);
                byArray[n4 + n3++] = (byte)c3;
                while (n3 < n5) {
                    c3 = string.charAt(n3);
                    if (c3 >= '\u0080') break;
                    byArray[n4 + n3++] = (byte)c3;
                }
                int n6 = n3 + n4 - segment.limit;
                segment.limit += n6;
                this.size += (long)n6;
                continue;
            }
            if (c3 < '\u0800') {
                this.writeByte(c3 >> 6 | 0xC0);
                this.writeByte(c3 & 0x3F | 0x80);
                ++n3;
                continue;
            }
            if (c3 < '\ud800' || c3 > '\udfff') {
                this.writeByte(c3 >> 12 | 0xE0);
                this.writeByte(c3 >> 6 & 0x3F | 0x80);
                this.writeByte(c3 & 0x3F | 0x80);
                ++n3;
                continue;
            }
            char c4 = c2 = n3 + 1 < n2 ? string.charAt(n3 + 1) : (char)'\u0000';
            if (c3 > '\udbff' || c2 < '\udc00' || c2 > '\udfff') {
                this.writeByte(63);
                ++n3;
                continue;
            }
            int n7 = 65536 + ((c3 & 0xFFFF27FF) << 10 | c2 & 0xFFFF23FF);
            this.writeByte(n7 >> 18 | 0xF0);
            this.writeByte(n7 >> 12 & 0x3F | 0x80);
            this.writeByte(n7 >> 6 & 0x3F | 0x80);
            this.writeByte(n7 & 0x3F | 0x80);
            n3 += 2;
        }
        return this;
    }
}

