/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.layer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.model.layer.Layer;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;

public class ImageLayer
extends BaseLayer {
    private final Paint paint = new LPaint(3);
    private final Rect src = new Rect();
    private final Rect dst = new Rect();
    private BaseKeyframeAnimation colorFilterAnimation;

    ImageLayer(LottieDrawable lottieDrawable, Layer layer) {
        super(lottieDrawable, layer);
    }

    @Override
    public void drawLayer(Canvas canvas, Matrix matrix, int n) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        float f2 = Utils.dpScale();
        this.paint.setAlpha(n);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter((ColorFilter)this.colorFilterAnimation.getValue());
        }
        canvas.save();
        canvas.concat(matrix);
        this.src.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.dst.set(0, 0, (int)((float)bitmap.getWidth() * f2), (int)((float)bitmap.getHeight() * f2));
        canvas.drawBitmap(bitmap, this.src, this.dst, this.paint);
        canvas.restore();
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        super.getBounds(rectF, matrix, bl);
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            rectF.set(0.0f, 0.0f, (float)bitmap.getWidth() * Utils.dpScale(), (float)bitmap.getHeight() * Utils.dpScale());
            this.boundsMatrix.mapRect(rectF);
        }
    }

    private Bitmap getBitmap() {
        String string = this.layerModel.getRefId();
        return this.lottieDrawable.getImageAsset(string);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        super.addValueCallback(object, lottieValueCallback);
        if (object == LottieProperty.COLOR_FILTER) {
            this.colorFilterAnimation = lottieValueCallback == null ? null : new ValueCallbackKeyframeAnimation(lottieValueCallback);
        }
    }
}

