/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.Color;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.parser.moshi.JsonReader$Token;

class JsonUtils {
    private static final JsonReader$Options POINT_NAMES = JsonReader$Options.of("x", "y");

    private JsonUtils() {
    }

    static int jsonToColor(JsonReader jsonReader) {
        jsonReader.beginArray();
        int n = (int)(jsonReader.nextDouble() * 255.0);
        int n2 = (int)(jsonReader.nextDouble() * 255.0);
        int n3 = (int)(jsonReader.nextDouble() * 255.0);
        while (jsonReader.hasNext()) {
            jsonReader.skipValue();
        }
        jsonReader.endArray();
        return Color.argb((int)255, (int)n, (int)n2, (int)n3);
    }

    static List jsonToPoints(JsonReader jsonReader, float f2) {
        ArrayList<PointF> arrayList = new ArrayList<PointF>();
        jsonReader.beginArray();
        while (jsonReader.peek() == JsonReader$Token.BEGIN_ARRAY) {
            jsonReader.beginArray();
            arrayList.add(JsonUtils.jsonToPoint(jsonReader, f2));
            jsonReader.endArray();
        }
        jsonReader.endArray();
        return arrayList;
    }

    static PointF jsonToPoint(JsonReader jsonReader, float f2) {
        switch (jsonReader.peek()) {
            case NUMBER: {
                return JsonUtils.jsonNumbersToPoint(jsonReader, f2);
            }
            case BEGIN_ARRAY: {
                return JsonUtils.jsonArrayToPoint(jsonReader, f2);
            }
            case BEGIN_OBJECT: {
                return JsonUtils.jsonObjectToPoint(jsonReader, f2);
            }
        }
        throw new IllegalArgumentException("Unknown point starts with " + (Object)((Object)jsonReader.peek()));
    }

    private static PointF jsonNumbersToPoint(JsonReader jsonReader, float f2) {
        float f3 = (float)jsonReader.nextDouble();
        float f4 = (float)jsonReader.nextDouble();
        while (jsonReader.hasNext()) {
            jsonReader.skipValue();
        }
        return new PointF(f3 * f2, f4 * f2);
    }

    private static PointF jsonArrayToPoint(JsonReader jsonReader, float f2) {
        jsonReader.beginArray();
        float f3 = (float)jsonReader.nextDouble();
        float f4 = (float)jsonReader.nextDouble();
        while (jsonReader.peek() != JsonReader$Token.END_ARRAY) {
            jsonReader.skipValue();
        }
        jsonReader.endArray();
        return new PointF(f3 * f2, f4 * f2);
    }

    private static PointF jsonObjectToPoint(JsonReader jsonReader, float f2) {
        float f3 = 0.0f;
        float f4 = 0.0f;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(POINT_NAMES)) {
                case 0: {
                    f3 = JsonUtils.valueFromObject(jsonReader);
                    break;
                }
                case 1: {
                    f4 = JsonUtils.valueFromObject(jsonReader);
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        jsonReader.endObject();
        return new PointF(f3 * f2, f4 * f2);
    }

    static float valueFromObject(JsonReader jsonReader) {
        JsonReader$Token jsonReader$Token = jsonReader.peek();
        switch (jsonReader$Token) {
            case NUMBER: {
                return (float)jsonReader.nextDouble();
            }
            case BEGIN_ARRAY: {
                jsonReader.beginArray();
                float f2 = (float)jsonReader.nextDouble();
                while (jsonReader.hasNext()) {
                    jsonReader.skipValue();
                }
                jsonReader.endArray();
                return f2;
            }
        }
        throw new IllegalArgumentException("Unknown value for token of type " + (Object)((Object)jsonReader$Token));
    }
}

