/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;

public class HttpClientResponse {
    private HttpResponse response = null;
    private HttpEntity entity = null;

    public HttpClientResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
        this.entity = httpResponse.getEntity();
    }

    public String getContentType() {
        return this.getResponseHeader("Content-Type").getValue();
    }

    public String getContentLength() {
        Header header = this.getResponseHeader("Content-Length");
        if (header == null) {
            return "0";
        }
        return header.getValue();
    }

    public String getLastModified() {
        return this.getResponseHeader("Last-Modified").getValue();
    }

    public Header[] getResponseHeaders() {
        return this.response.getAllHeaders();
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getStatusMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public String getResponseBodyAsString() {
        return EntityUtils.toString((HttpEntity)this.entity);
    }

    public InputStream getResponseBodyAsStream() {
        return this.entity.getContent();
    }

    public byte[] getResponseBody() {
        return EntityUtils.toByteArray((HttpEntity)this.entity);
    }

    public Header getResponseHeader(String string) {
        return this.response.getFirstHeader(string);
    }

    public Header[] getResponseHeaders(String string) {
        return this.response.getHeaders(string);
    }

    public String getContentEncoding() {
        return this.entity.getContentEncoding().getValue();
    }
}

