/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.IOException;
import oz.util.barcode.PlanarYUVLuminanceSource;
import oz.util.barcode.client.android.camera.AutoFocusManager;
import oz.util.barcode.client.android.camera.CameraConfigurationManager;
import oz.util.barcode.client.android.camera.PreviewCallback;
import oz.util.barcode.client.android.camera.open.OpenCameraInterface;
import oz.util.barcode.client.android.camera.open.OpenCameraManager;

public final class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private static final int MIN_FRAME_WIDTH = 240;
    private static final int MIN_FRAME_HEIGHT = 240;
    private static final int MAX_FRAME_WIDTH = 960;
    private static final int MAX_FRAME_HEIGHT = 540;
    private final Context context;
    private final CameraConfigurationManager configManager;
    private Camera camera;
    private AutoFocusManager autoFocusManager;
    private Rect framingRect;
    private Rect framingRectInPreview;
    private boolean initialized;
    private boolean previewing;
    private int requestedFramingRectWidth;
    private int requestedFramingRectHeight;
    private final PreviewCallback previewCallback;

    public CameraManager(Context context) {
        this.context = context;
        this.configManager = new CameraConfigurationManager(context);
        this.previewCallback = new PreviewCallback(this.configManager);
    }

    public Point getPreviewSize(Camera.Parameters parameters, Point point) {
        return this.configManager.findBestPreviewSizeValue(parameters, point);
    }

    public boolean isPreviewing() {
        return this.previewing;
    }

    public synchronized void openDriver(SurfaceHolder surfaceHolder) {
        block8: {
            Camera.Parameters parameters;
            Camera camera = this.camera;
            if (camera == null) {
                camera = ((OpenCameraInterface)new OpenCameraManager().build()).open();
                if (camera == null) {
                    throw new IOException();
                }
                this.camera = camera;
            }
            camera.setPreviewDisplay(surfaceHolder);
            if (!this.initialized) {
                this.initialized = true;
                this.configManager.initFromCameraParameters(camera);
                if (this.requestedFramingRectWidth > 0 && this.requestedFramingRectHeight > 0) {
                    this.setManualFramingRect(this.requestedFramingRectWidth, this.requestedFramingRectHeight);
                    this.requestedFramingRectWidth = 0;
                    this.requestedFramingRectHeight = 0;
                }
            }
            String string = (parameters = camera.getParameters()) == null ? null : parameters.flatten();
            try {
                this.configManager.setDesiredCameraParameters(camera, false);
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)TAG, (String)"Camera rejected parameters. Setting only minimal safe-mode parameters");
                Log.i((String)TAG, (String)("Resetting to saved camera params: " + string));
                if (string == null) break block8;
                parameters = camera.getParameters();
                parameters.unflatten(string);
                try {
                    camera.setParameters(parameters);
                    this.configManager.setDesiredCameraParameters(camera, true);
                }
                catch (RuntimeException runtimeException2) {
                    Log.w((String)TAG, (String)"Camera rejected even safe-mode parameters! No configuration");
                }
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.camera != null;
    }

    public synchronized void closeDriver() {
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
            this.framingRect = null;
            this.framingRectInPreview = null;
        }
    }

    public synchronized void startPreview() {
        Camera camera = this.camera;
        if (camera != null && !this.previewing) {
            camera.startPreview();
            this.previewing = true;
            this.autoFocusManager = new AutoFocusManager(this.context, this.camera);
        }
    }

    public synchronized void stopPreview() {
        if (this.autoFocusManager != null) {
            this.autoFocusManager.stop();
            this.autoFocusManager = null;
        }
        if (this.camera != null && this.previewing) {
            this.camera.stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void reFocus() {
        if (this.autoFocusManager != null && this.camera != null) {
            this.camera.autoFocus((Camera.AutoFocusCallback)this.autoFocusManager);
        }
    }

    public synchronized void setTorch(boolean bl) {
        if (bl != this.configManager.getTorchState(this.camera) && this.camera != null) {
            if (this.autoFocusManager != null) {
                this.autoFocusManager.stop();
            }
            this.configManager.setTorch(this.camera, bl);
            if (this.autoFocusManager != null) {
                this.autoFocusManager.start();
            }
        }
    }

    public synchronized boolean isCameraFlash() {
        return this.configManager.isCameraFlash(this.camera);
    }

    public synchronized void requestPreviewFrame(Handler handler, int n) {
        Camera camera = this.camera;
        if (camera != null && this.previewing) {
            this.previewCallback.setHandler(handler, n);
            camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
        }
    }

    public synchronized Rect getFramingRect() {
        if (this.framingRect == null) {
            if (this.camera == null) {
                return null;
            }
            Point point = this.configManager.getScreenResolution();
            if (point == null) {
                return null;
            }
            this.framingRect = new Rect(100, (int)((double)point.y * 0.35), point.x - 100, point.y - (int)((double)point.y * 0.35));
            Log.d((String)TAG, (String)("Calculated framing rect: " + this.framingRect));
        }
        return this.framingRect;
    }

    private static int findDesiredDimensionInRange(int n, int n2, int n3) {
        int n4 = n / 2;
        if (n4 < n2) {
            return n2;
        }
        if (n4 > n3) {
            return n3;
        }
        return n4;
    }

    public synchronized Rect getFramingRectInPreview() {
        if (this.framingRectInPreview == null) {
            Rect rect = this.getFramingRect();
            if (rect == null) {
                return null;
            }
            Rect rect2 = new Rect(rect);
            Point point = this.configManager.getCameraResolution();
            Point point2 = this.configManager.getScreenResolution();
            if (point == null || point2 == null) {
                return null;
            }
            rect2.left = rect2.left * point.x / point2.x;
            rect2.right = rect2.right * point.x / point2.x;
            rect2.top = rect2.top * point.y / point2.y;
            rect2.bottom = rect2.bottom * point.y / point2.y;
            this.framingRectInPreview = rect2;
        }
        return this.framingRectInPreview;
    }

    public synchronized void setManualFramingRect(int n, int n2) {
        if (this.initialized) {
            Point point = this.configManager.getScreenResolution();
            if (n > point.x) {
                n = point.x;
            }
            if (n2 > point.y) {
                n2 = point.y;
            }
            int n3 = (point.x - n) / 2;
            int n4 = (point.y - n2) / 2;
            this.framingRect = new Rect(n3, n4, n3 + n, n4 + n2);
            Log.d((String)TAG, (String)("Calculated manual framing rect: " + this.framingRect));
            this.framingRectInPreview = null;
        } else {
            this.requestedFramingRectWidth = n;
            this.requestedFramingRectHeight = n2;
        }
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] byArray, int n, int n2) {
        Rect rect = this.getFramingRectInPreview();
        if (rect == null) {
            return null;
        }
        try {
            return new PlanarYUVLuminanceSource(byArray, n, n2, rect.left, rect.top, rect.width(), rect.height(), false);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

