/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import oz.util.barcode.client.android.camera.CameraConfigurationManager;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = PreviewCallback.class.getSimpleName();
    private final CameraConfigurationManager configManager;
    private Handler previewHandler;
    private int previewMessage;
    boolean rotateFlag = true;

    PreviewCallback(CameraConfigurationManager cameraConfigurationManager) {
        this.configManager = cameraConfigurationManager;
    }

    void setHandler(Handler handler, int n) {
        this.previewHandler = handler;
        this.previewMessage = n;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        Point point = this.configManager.getCameraResolution();
        int n = this.configManager.getRotate();
        if ((n == 90 || n == 270) && this.rotateFlag) {
            byArray = this.rotateYUV420Degree90(byArray, point.x, point.y);
            this.rotateFlag = false;
        } else {
            this.rotateFlag = true;
        }
        Handler handler = this.previewHandler;
        if (point != null && handler != null) {
            Message message = handler.obtainMessage(this.previewMessage, point.x, point.y, (Object)byArray);
            message.sendToTarget();
            this.previewHandler = null;
        } else {
            Log.d((String)TAG, (String)"Got preview callback, but no handler or resolution available");
        }
    }

    private byte[] rotateYUV420Degree90(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[n * n2 * 3 / 2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                byArray2[n4] = byArray[n3 * n + n5];
                ++n4;
                --n3;
            }
            ++n5;
        }
        n4 = n * n2 * 3 / 2 - 1;
        n5 = n - 1;
        while (n5 > 0) {
            n3 = 0;
            while (n3 < n2 / 2) {
                byArray2[n4] = byArray[n * n2 + n3 * n + n5];
                byArray2[--n4] = byArray[n * n2 + n3 * n + (n5 - 1)];
                --n4;
                ++n3;
            }
            n5 -= 2;
        }
        return byArray2;
    }
}

