/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.GeoParsedResult;
import oz.util.barcode.client.result.ResultParser;

public final class GeoResultParser
extends ResultParser {
    private static final Pattern GEO_URL_PATTERN = Pattern.compile("geo:([\\-0-9.]+),([\\-0-9.]+)(?:,([\\-0-9.]+))?(?:\\?(.*))?", 2);

    @Override
    public GeoParsedResult parse(Result result) {
        double d2;
        double d3;
        double d4;
        String string;
        Matcher matcher;
        block9: {
            block8: {
                String string2 = GeoResultParser.getMassagedText(result);
                matcher = GEO_URL_PATTERN.matcher(string2);
                if (!matcher.matches()) {
                    return null;
                }
                string = matcher.group(4);
                try {
                    d4 = Double.parseDouble(matcher.group(1));
                    if (!(d4 > 90.0) && !(d4 < -90.0)) break block8;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            d3 = Double.parseDouble(matcher.group(2));
            if (!(d3 > 180.0) && !(d3 < -180.0)) break block9;
            return null;
        }
        if (matcher.group(3) == null) {
            d2 = 0.0;
        } else {
            d2 = Double.parseDouble(matcher.group(3));
            if (d2 < 0.0) {
                return null;
            }
        }
        return new GeoParsedResult(d4, d3, d2, string);
    }
}

