/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import oz.util.barcode.Binarizer;
import oz.util.barcode.LuminanceSource;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    @Override
    public BitArray getBlackRow(int n, BitArray bitArray) {
        int n2;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n3 = luminanceSource.getWidth();
        if (bitArray == null || bitArray.getSize() < n3) {
            bitArray = new BitArray(n3);
        } else {
            bitArray.clear();
        }
        this.initArrays(n3);
        byte[] byArray = luminanceSource.getRow(n, this.luminances);
        int[] nArray = this.buckets;
        int n4 = 0;
        while (n4 < n3) {
            n2 = byArray[n4] & 0xFF;
            int n5 = n2 >> 3;
            nArray[n5] = nArray[n5] + 1;
            ++n4;
        }
        n4 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        n2 = byArray[0] & 0xFF;
        int n6 = byArray[1] & 0xFF;
        int n7 = 1;
        while (n7 < n3 - 1) {
            int n8 = byArray[n7 + 1] & 0xFF;
            int n9 = (n6 << 2) - n2 - n8 >> 1;
            if (n9 < n4) {
                bitArray.set(n7);
            }
            n2 = n6;
            n6 = n8;
            ++n7;
        }
        return bitArray;
    }

    @Override
    public BitMatrix getBlackMatrix() {
        int n;
        int n2;
        int n3;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n4 = luminanceSource.getWidth();
        int n5 = luminanceSource.getHeight();
        BitMatrix bitMatrix = new BitMatrix(n4, n5);
        this.initArrays(n4);
        int[] nArray = this.buckets;
        int n6 = 1;
        while (n6 < 5) {
            int n7 = n5 * n6 / 5;
            byte[] byArray = luminanceSource.getRow(n7, this.luminances);
            n3 = (n4 << 2) / 5;
            n2 = n4 / 5;
            while (n2 < n3) {
                n = byArray[n2] & 0xFF;
                int n8 = n >> 3;
                nArray[n8] = nArray[n8] + 1;
                ++n2;
            }
            ++n6;
        }
        n6 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        byte[] byArray = luminanceSource.getMatrix();
        int n9 = 0;
        while (n9 < n5) {
            n3 = n9 * n4;
            n2 = 0;
            while (n2 < n4) {
                n = byArray[n3 + n2] & 0xFF;
                if (n < n6) {
                    bitMatrix.set(n2, n9);
                }
                ++n2;
            }
            ++n9;
        }
        return bitMatrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new GlobalHistogramBinarizer(luminanceSource);
    }

    private void initArrays(int n) {
        if (this.luminances.length < n) {
            this.luminances = new byte[n];
        }
        int n2 = 0;
        while (n2 < 32) {
            this.buckets[n2] = 0;
            ++n2;
        }
    }

    private static int estimateBlackPoint(int[] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            if (nArray[n7] > n6) {
                n5 = n7;
                n6 = nArray[n7];
            }
            if (nArray[n7] > n4) {
                n4 = nArray[n7];
            }
            ++n7;
        }
        n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            n2 = n9 - n5;
            n = nArray[n9] * n2 * n2;
            if (n > n8) {
                n7 = n9;
                n8 = n;
            }
            ++n9;
        }
        if (n5 > n7) {
            n9 = n5;
            n5 = n7;
            n7 = n9;
        }
        if (n7 - n5 <= n3 >> 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        n9 = n7 - 1;
        n2 = -1;
        n = n7 - 1;
        while (n > n5) {
            int n10 = n - n5;
            int n11 = n10 * n10 * (n7 - n) * (n4 - nArray[n]);
            if (n11 > n2) {
                n9 = n;
                n2 = n11;
            }
            --n;
        }
        return n9 << 3;
    }
}

