/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.decoder;

import oz.util.barcode.ChecksumException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonDecoder;
import oz.util.barcode.common.reedsolomon.ReedSolomonException;
import oz.util.barcode.datamatrix.decoder.BitMatrixParser;
import oz.util.barcode.datamatrix.decoder.DataBlock;
import oz.util.barcode.datamatrix.decoder.DecodedBitStreamParser;
import oz.util.barcode.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) {
        int n = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                if (blArray[n2][n3]) {
                    bitMatrix.set(n3, n2);
                }
                ++n3;
            }
            ++n2;
        }
        return this.decode(bitMatrix);
    }

    public DecoderResult decode(BitMatrix bitMatrix) {
        Object object;
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        Version version = bitMatrixParser.getVersion();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version);
        int n = dataBlockArray.length;
        int n2 = 0;
        Object[] objectArray = dataBlockArray;
        int n3 = dataBlockArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            n2 += ((DataBlock)object).getNumDataCodewords();
            ++n4;
        }
        object = new byte[n2];
        n4 = 0;
        while (n4 < n) {
            DataBlock dataBlock = dataBlockArray[n4];
            objectArray = dataBlock.getCodewords();
            int n5 = dataBlock.getNumDataCodewords();
            this.correctErrors((byte[])objectArray, n5);
            int n6 = 0;
            while (n6 < n5) {
                object[n6 * n + n4] = objectArray[n6];
                ++n6;
            }
            ++n4;
        }
        return DecodedBitStreamParser.decode((byte[])object);
    }

    private void correctErrors(byte[] byArray, int n) {
        int n2 = byArray.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = byArray[n3] & 0xFF;
            ++n3;
        }
        n3 = byArray.length - n;
        try {
            this.rsDecoder.decode(nArray, n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        int n4 = 0;
        while (n4 < n) {
            byArray[n4] = (byte)nArray[n4];
            ++n4;
        }
    }
}

