/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.multi.qrcode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.DetectorResult;
import oz.util.barcode.multi.MultipleBarcodeReader;
import oz.util.barcode.multi.qrcode.QRCodeMultiReader$SAComparator;
import oz.util.barcode.multi.qrcode.detector.MultiDetector;
import oz.util.barcode.qrcode.QRCodeReader;
import oz.util.barcode.qrcode.decoder.QRCodeDecoderMetaData;

public final class QRCodeMultiReader
extends QRCodeReader
implements MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map map) {
        DetectorResult[] detectorResultArray;
        List<Result> list = new ArrayList();
        DetectorResult[] detectorResultArray2 = detectorResultArray = new MultiDetector(binaryBitmap.getBlackMatrix()).detectMulti(map);
        int n = detectorResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            DetectorResult detectorResult = detectorResultArray2[n2];
            try {
                String string;
                DecoderResult decoderResult = this.getDecoder().decode(detectorResult.getBits(), map);
                ResultPoint[] resultPointArray = detectorResult.getPoints();
                if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
                    ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(resultPointArray);
                }
                Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
                List list2 = decoderResult.getByteSegments();
                if (list2 != null) {
                    result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, list2);
                }
                if ((string = decoderResult.getECLevel()) != null) {
                    result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
                }
                if (decoderResult.hasStructuredAppend()) {
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
                }
                list.add(result);
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
            ++n2;
        }
        if (list.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        list = QRCodeMultiReader.processStructuredAppend(list);
        return list.toArray(new Result[list.size()]);
    }

    private static List processStructuredAppend(List list) {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        boolean bl = false;
        for (Object object42 : list) {
            if (!((Result)object42).getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return list;
        }
        object42 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        for (Object object32 : list) {
            object42.add(object32);
            if (!((Result)object32).getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) continue;
            arrayList.add(object32);
        }
        Collections.sort(arrayList, new QRCodeMultiReader$SAComparator(null));
        object32 = new StringBuilder();
        int n = 0;
        int n2 = 0;
        Object object5 = arrayList.iterator();
        while (object5.hasNext()) {
            object2 = (Result)object5.next();
            ((StringBuilder)object32).append(((Result)object2).getText());
            n += ((Result)object2).getRawBytes().length;
            if (!((Result)object2).getResultMetadata().containsKey((Object)ResultMetadataType.BYTE_SEGMENTS)) continue;
            Iterable iterable = (Iterable)((Result)object2).getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS);
            for (byte[] byArray : iterable) {
                n2 += byArray.length;
            }
        }
        object2 = new byte[n];
        object5 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        Object object6 = arrayList.iterator();
        while (object6.hasNext()) {
            object = (Result)object6.next();
            System.arraycopy(((Result)object).getRawBytes(), 0, object2, n3, ((Result)object).getRawBytes().length);
            n3 += ((Result)object).getRawBytes().length;
            if (!((Result)object).getResultMetadata().containsKey((Object)ResultMetadataType.BYTE_SEGMENTS)) continue;
            Iterable iterable = (Iterable)((Result)object).getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS);
            for (byte[] byArray : iterable) {
                System.arraycopy(byArray, 0, object5, n4, byArray.length);
                n4 += byArray.length;
            }
        }
        object = new Result(((StringBuilder)object32).toString(), (byte[])object2, NO_POINTS, BarcodeFormat.QR_CODE);
        if (n2 > 0) {
            object6 = new ArrayList();
            object6.add(object5);
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object6);
        }
        object42.add(object);
        return object42;
    }
}

