/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.Code39Reader;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n4);
        }
        int[] nArray = new int[9];
        int n5 = 25 + n4;
        int n6 = 0;
        while (n6 < n4) {
            n3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(n6));
            if (n3 < 0) {
                throw new IllegalArgumentException("Bad contents: " + string);
            }
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n3], nArray);
            int[] nArray2 = nArray;
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int n7 = nArray2[n];
                n5 += n7;
                ++n;
            }
            ++n6;
        }
        boolean[] blArray = new boolean[n5];
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n3 = Code39Writer.appendPattern(blArray, 0, nArray, true);
        int[] nArray3 = new int[]{1};
        n3 += Code39Writer.appendPattern(blArray, n3, nArray3, false);
        n = n4 - 1;
        while (n >= 0) {
            n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(n));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n2], nArray);
            n3 += Code39Writer.appendPattern(blArray, n3, nArray, true);
            n3 += Code39Writer.appendPattern(blArray, n3, nArray3, false);
            --n;
        }
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n3 += Code39Writer.appendPattern(blArray, n3, nArray, true);
        return blArray;
    }

    private static void toIntArray(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < 9) {
            int n3 = n & 1 << n2;
            nArray[n2] = n3 == 0 ? 1 : 2;
            ++n2;
        }
    }
}

