/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.EAN13Writer;

public final class UPCAWriter
implements Writer {
    private final EAN13Writer subWriter = new EAN13Writer();

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.UPC_A) {
            throw new IllegalArgumentException("Can only encode UPC-A, but got " + (Object)((Object)barcodeFormat));
        }
        return this.subWriter.encode(UPCAWriter.preencode(string), BarcodeFormat.EAN_13, n, n2, map);
    }

    private static String preencode(String string) {
        int n = string.length();
        if (n == 11) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 11) {
                n2 += (string.charAt(n3) - 48) * (n3 % 2 == 0 ? 3 : 1);
                ++n3;
            }
            string = String.valueOf(string) + (1000 - n2) % 10;
        } else if (n != 12) {
            throw new IllegalArgumentException("Requested contents should be 11 or 12 digits long, but got " + string.length());
        }
        return String.valueOf('0') + string;
    }
}

