/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;
import oz.util.barcode.qrcode.encoder.ByteMatrix;
import oz.util.barcode.qrcode.encoder.Encoder;
import oz.util.barcode.qrcode.encoder.QRCode;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        Object object;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + (Object)((Object)barcodeFormat));
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n + 'x' + n2);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int n3 = 4;
        if (map != null) {
            Integer n4;
            object = (ErrorCorrectionLevel)((Object)map.get((Object)EncodeHintType.ERROR_CORRECTION));
            if (object != null) {
                errorCorrectionLevel = object;
            }
            if ((n4 = (Integer)map.get((Object)EncodeHintType.MARGIN)) != null) {
                n3 = n4;
            }
        }
        object = Encoder.encode(string, errorCorrectionLevel, map);
        return QRCodeWriter.renderResult((QRCode)object, n, n2, n3);
    }

    private static BitMatrix renderResult(QRCode qRCode, int n, int n2, int n3) {
        ByteMatrix byteMatrix = qRCode.getMatrix();
        if (byteMatrix == null) {
            throw new IllegalStateException();
        }
        int n4 = byteMatrix.getWidth();
        int n5 = byteMatrix.getHeight();
        int n6 = n4 + (n3 << 1);
        int n7 = n5 + (n3 << 1);
        int n8 = Math.max(n, n6);
        int n9 = Math.max(n2, n7);
        int n10 = Math.min(n8 / n6, n9 / n7);
        int n11 = (n8 - n4 * n10) / 2;
        int n12 = (n9 - n5 * n10) / 2;
        BitMatrix bitMatrix = new BitMatrix(n8, n9);
        int n13 = 0;
        int n14 = n12;
        while (n13 < n5) {
            int n15 = 0;
            int n16 = n11;
            while (n15 < n4) {
                if (byteMatrix.get(n15, n13) == 1) {
                    bitMatrix.setRegion(n16, n14, n10, n10);
                }
                ++n15;
                n16 += n10;
            }
            ++n13;
            n14 += n10;
        }
        return bitMatrix;
    }
}

