/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.decoder;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitSource;
import oz.util.barcode.common.CharacterSetECI;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.StringUtils;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;
import oz.util.barcode.qrcode.decoder.Mode;
import oz.util.barcode.qrcode.decoder.Version;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel, Map map) {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(50);
        ArrayList arrayList = new ArrayList(1);
        int n = -1;
        int n2 = -1;
        try {
            Mode mode;
            CharacterSetECI characterSetECI = null;
            boolean bl = false;
            do {
                int n3;
                if ((mode = bitSource.available() < 4 ? Mode.TERMINATOR : Mode.forBits(bitSource.readBits(4))) == Mode.TERMINATOR) continue;
                if (mode == Mode.FNC1_FIRST_POSITION || mode == Mode.FNC1_SECOND_POSITION) {
                    bl = true;
                    continue;
                }
                if (mode == Mode.STRUCTURED_APPEND) {
                    if (bitSource.available() < 16) {
                        throw FormatException.getFormatInstance();
                    }
                    n = bitSource.readBits(8);
                    n2 = bitSource.readBits(8);
                    continue;
                }
                if (mode == Mode.ECI) {
                    n3 = DecodedBitStreamParser.parseECIValue(bitSource);
                    characterSetECI = CharacterSetECI.getCharacterSetECIByValue(n3);
                    if (characterSetECI != null) continue;
                    throw FormatException.getFormatInstance();
                }
                if (mode == Mode.HANZI) {
                    n3 = bitSource.readBits(4);
                    int n4 = bitSource.readBits(mode.getCharacterCountBits(version));
                    if (n3 != 1) continue;
                    DecodedBitStreamParser.decodeHanziSegment(bitSource, stringBuilder, n4);
                    continue;
                }
                n3 = bitSource.readBits(mode.getCharacterCountBits(version));
                if (mode == Mode.NUMERIC) {
                    DecodedBitStreamParser.decodeNumericSegment(bitSource, stringBuilder, n3);
                    continue;
                }
                if (mode == Mode.ALPHANUMERIC) {
                    DecodedBitStreamParser.decodeAlphanumericSegment(bitSource, stringBuilder, n3, bl);
                    continue;
                }
                if (mode == Mode.BYTE) {
                    DecodedBitStreamParser.decodeByteSegment(bitSource, stringBuilder, n3, characterSetECI, arrayList, map);
                    continue;
                }
                if (mode == Mode.KANJI) {
                    DecodedBitStreamParser.decodeKanjiSegment(bitSource, stringBuilder, n3);
                    continue;
                }
                throw FormatException.getFormatInstance();
            } while (mode != Mode.TERMINATOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FormatException.getFormatInstance();
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, errorCorrectionLevel == null ? null : errorCorrectionLevel.toString(), n, n2);
    }

    private static void decodeHanziSegment(BitSource bitSource, StringBuilder stringBuilder, int n) {
        if (n * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        while (n > 0) {
            int n3 = bitSource.readBits(13);
            int n4 = n3 / 96 << 8 | n3 % 96;
            n4 = n4 < 959 ? (n4 += 41377) : (n4 += 42657);
            byArray[n2] = (byte)(n4 >> 8 & 0xFF);
            byArray[n2 + 1] = (byte)(n4 & 0xFF);
            n2 += 2;
            --n;
        }
        try {
            stringBuilder.append(new String(byArray, "GB2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeKanjiSegment(BitSource bitSource, StringBuilder stringBuilder, int n) {
        if (n * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        while (n > 0) {
            int n3 = bitSource.readBits(13);
            int n4 = n3 / 192 << 8 | n3 % 192;
            n4 = n4 < 7936 ? (n4 += 33088) : (n4 += 49472);
            byArray[n2] = (byte)(n4 >> 8);
            byArray[n2 + 1] = (byte)n4;
            n2 += 2;
            --n;
        }
        try {
            stringBuilder.append(new String(byArray, "SJIS"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeByteSegment(BitSource bitSource, StringBuilder stringBuilder, int n, CharacterSetECI characterSetECI, Collection collection, Map map) {
        if (8 * n > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)bitSource.readBits(8);
            ++n2;
        }
        String string = characterSetECI == null ? StringUtils.guessEncoding(byArray, map) : characterSetECI.name();
        try {
            stringBuilder.append(new String(byArray, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
        collection.add(byArray);
    }

    private static char toAlphaNumericChar(int n) {
        if (n >= ALPHANUMERIC_CHARS.length) {
            throw FormatException.getFormatInstance();
        }
        return ALPHANUMERIC_CHARS[n];
    }

    private static void decodeAlphanumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n, boolean bl) {
        int n2;
        int n3 = stringBuilder.length();
        while (n > 1) {
            if (bitSource.available() < 11) {
                throw FormatException.getFormatInstance();
            }
            n2 = bitSource.readBits(11);
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 45));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 45));
            n -= 2;
        }
        if (n == 1) {
            if (bitSource.available() < 6) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(bitSource.readBits(6)));
        }
        if (bl) {
            n2 = n3;
            while (n2 < stringBuilder.length()) {
                if (stringBuilder.charAt(n2) == '%') {
                    if (n2 < stringBuilder.length() - 1 && stringBuilder.charAt(n2 + 1) == '%') {
                        stringBuilder.deleteCharAt(n2 + 1);
                    } else {
                        stringBuilder.setCharAt(n2, '\u001d');
                    }
                }
                ++n2;
            }
        }
    }

    private static void decodeNumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n) {
        int n2;
        while (n >= 3) {
            if (bitSource.available() < 10) {
                throw FormatException.getFormatInstance();
            }
            n2 = bitSource.readBits(10);
            if (n2 >= 1000) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 100));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 10 % 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 10));
            n -= 3;
        }
        if (n == 2) {
            if (bitSource.available() < 7) {
                throw FormatException.getFormatInstance();
            }
            n2 = bitSource.readBits(7);
            if (n2 >= 100) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 10));
        } else if (n == 1) {
            if (bitSource.available() < 4) {
                throw FormatException.getFormatInstance();
            }
            n2 = bitSource.readBits(4);
            if (n2 >= 10) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2));
        }
    }

    private static int parseECIValue(BitSource bitSource) {
        int n = bitSource.readBits(8);
        if ((n & 0x80) == 0) {
            return n & 0x7F;
        }
        if ((n & 0xC0) == 128) {
            int n2 = bitSource.readBits(8);
            return (n & 0x3F) << 8 | n2;
        }
        if ((n & 0xE0) == 192) {
            int n3 = bitSource.readBits(16);
            return (n & 0x1F) << 16 | n3;
        }
        throw FormatException.getFormatInstance();
    }
}

