/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.encoder;

import oz.util.barcode.WriterException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;
import oz.util.barcode.qrcode.decoder.Version;
import oz.util.barcode.qrcode.encoder.ByteMatrix;
import oz.util.barcode.qrcode.encoder.MaskUtil;
import oz.util.barcode.qrcode.encoder.QRCode;

final class MatrixUtil {
    private static final int[][] POSITION_DETECTION_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE;
    private static final int[][] TYPE_INFO_COORDINATES;
    private static final int VERSION_INFO_POLY = 7973;
    private static final int TYPE_INFO_POLY = 1335;
    private static final int TYPE_INFO_MASK_PATTERN = 21522;

    static {
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[]{1, 1, 1, 1, 1, 1, 1};
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[6] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[7];
        nArray2[0] = 1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[6] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[6] = 1;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[0] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[6] = 1;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArray5[6] = 1;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{1, 1, 1, 1, 1, 1, 1};
        POSITION_DETECTION_PATTERN = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        nArrayArray2[0] = new int[]{1, 1, 1, 1, 1};
        int[] nArray6 = new int[5];
        nArray6[0] = 1;
        nArray6[4] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[5];
        nArray7[0] = 1;
        nArray7[2] = 1;
        nArray7[4] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[5];
        nArray8[0] = 1;
        nArray8[4] = 1;
        nArrayArray2[3] = nArray8;
        nArrayArray2[4] = new int[]{1, 1, 1, 1, 1};
        POSITION_ADJUSTMENT_PATTERN = nArrayArray2;
        POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = new int[][]{{-1, -1, -1, -1, -1, -1, -1}, {6, 18, -1, -1, -1, -1, -1}, {6, 22, -1, -1, -1, -1, -1}, {6, 26, -1, -1, -1, -1, -1}, {6, 30, -1, -1, -1, -1, -1}, {6, 34, -1, -1, -1, -1, -1}, {6, 22, 38, -1, -1, -1, -1}, {6, 24, 42, -1, -1, -1, -1}, {6, 26, 46, -1, -1, -1, -1}, {6, 28, 50, -1, -1, -1, -1}, {6, 30, 54, -1, -1, -1, -1}, {6, 32, 58, -1, -1, -1, -1}, {6, 34, 62, -1, -1, -1, -1}, {6, 26, 46, 66, -1, -1, -1}, {6, 26, 48, 70, -1, -1, -1}, {6, 26, 50, 74, -1, -1, -1}, {6, 30, 54, 78, -1, -1, -1}, {6, 30, 56, 82, -1, -1, -1}, {6, 30, 58, 86, -1, -1, -1}, {6, 34, 62, 90, -1, -1, -1}, {6, 28, 50, 72, 94, -1, -1}, {6, 26, 50, 74, 98, -1, -1}, {6, 30, 54, 78, 102, -1, -1}, {6, 28, 54, 80, 106, -1, -1}, {6, 32, 58, 84, 110, -1, -1}, {6, 30, 58, 86, 114, -1, -1}, {6, 34, 62, 90, 118, -1, -1}, {6, 26, 50, 74, 98, 122, -1}, {6, 30, 54, 78, 102, 126, -1}, {6, 26, 52, 78, 104, 130, -1}, {6, 30, 56, 82, 108, 134, -1}, {6, 34, 60, 86, 112, 138, -1}, {6, 30, 58, 86, 114, 142, -1}, {6, 34, 62, 90, 118, 146, -1}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}};
        int[][] nArrayArray3 = new int[15][];
        int[] nArray9 = new int[2];
        nArray9[0] = 8;
        nArrayArray3[0] = nArray9;
        nArrayArray3[1] = new int[]{8, 1};
        nArrayArray3[2] = new int[]{8, 2};
        nArrayArray3[3] = new int[]{8, 3};
        nArrayArray3[4] = new int[]{8, 4};
        nArrayArray3[5] = new int[]{8, 5};
        nArrayArray3[6] = new int[]{8, 7};
        nArrayArray3[7] = new int[]{8, 8};
        nArrayArray3[8] = new int[]{7, 8};
        nArrayArray3[9] = new int[]{5, 8};
        nArrayArray3[10] = new int[]{4, 8};
        nArrayArray3[11] = new int[]{3, 8};
        nArrayArray3[12] = new int[]{2, 8};
        nArrayArray3[13] = new int[]{1, 8};
        int[] nArray10 = new int[2];
        nArray10[1] = 8;
        nArrayArray3[14] = nArray10;
        TYPE_INFO_COORDINATES = nArrayArray3;
    }

    private MatrixUtil() {
    }

    static void clearMatrix(ByteMatrix byteMatrix) {
        byteMatrix.clear((byte)-1);
    }

    static void buildMatrix(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, int n, ByteMatrix byteMatrix) {
        MatrixUtil.clearMatrix(byteMatrix);
        MatrixUtil.embedBasicPatterns(version, byteMatrix);
        MatrixUtil.embedTypeInfo(errorCorrectionLevel, n, byteMatrix);
        MatrixUtil.maybeEmbedVersionInfo(version, byteMatrix);
        MatrixUtil.embedDataBits(bitArray, n, byteMatrix);
    }

    static void embedBasicPatterns(Version version, ByteMatrix byteMatrix) {
        MatrixUtil.embedPositionDetectionPatternsAndSeparators(byteMatrix);
        MatrixUtil.embedDarkDotAtLeftBottomCorner(byteMatrix);
        MatrixUtil.maybeEmbedPositionAdjustmentPatterns(version, byteMatrix);
        MatrixUtil.embedTimingPatterns(byteMatrix);
    }

    static void embedTypeInfo(ErrorCorrectionLevel errorCorrectionLevel, int n, ByteMatrix byteMatrix) {
        BitArray bitArray = new BitArray();
        MatrixUtil.makeTypeInfoBits(errorCorrectionLevel, n, bitArray);
        int n2 = 0;
        while (n2 < bitArray.getSize()) {
            int n3;
            int n4;
            boolean bl = bitArray.get(bitArray.getSize() - 1 - n2);
            int n5 = TYPE_INFO_COORDINATES[n2][0];
            int n6 = TYPE_INFO_COORDINATES[n2][1];
            byteMatrix.set(n5, n6, bl);
            if (n2 < 8) {
                n4 = byteMatrix.getWidth() - n2 - 1;
                n3 = 8;
                byteMatrix.set(n4, n3, bl);
            } else {
                n4 = 8;
                n3 = byteMatrix.getHeight() - 7 + (n2 - 8);
                byteMatrix.set(n4, n3, bl);
            }
            ++n2;
        }
    }

    static void maybeEmbedVersionInfo(Version version, ByteMatrix byteMatrix) {
        if (version.getVersionNumber() < 7) {
            return;
        }
        BitArray bitArray = new BitArray();
        MatrixUtil.makeVersionInfoBits(version, bitArray);
        int n = 17;
        int n2 = 0;
        while (n2 < 6) {
            int n3 = 0;
            while (n3 < 3) {
                boolean bl = bitArray.get(n);
                --n;
                byteMatrix.set(n2, byteMatrix.getHeight() - 11 + n3, bl);
                byteMatrix.set(byteMatrix.getHeight() - 11 + n3, n2, bl);
                ++n3;
            }
            ++n2;
        }
    }

    static void embedDataBits(BitArray bitArray, int n, ByteMatrix byteMatrix) {
        int n2 = 0;
        int n3 = -1;
        int n4 = byteMatrix.getWidth() - 1;
        int n5 = byteMatrix.getHeight() - 1;
        while (n4 > 0) {
            if (n4 == 6) {
                --n4;
            }
            while (n5 >= 0 && n5 < byteMatrix.getHeight()) {
                int n6 = 0;
                while (n6 < 2) {
                    int n7 = n4 - n6;
                    if (MatrixUtil.isEmpty(byteMatrix.get(n7, n5))) {
                        boolean bl;
                        if (n2 < bitArray.getSize()) {
                            bl = bitArray.get(n2);
                            ++n2;
                        } else {
                            bl = false;
                        }
                        if (n != -1 && MaskUtil.getDataMaskBit(n, n7, n5)) {
                            bl = !bl;
                        }
                        byteMatrix.set(n7, n5, bl);
                    }
                    ++n6;
                }
                n5 += n3;
            }
            n3 = -n3;
            n5 += n3;
            n4 -= 2;
        }
        if (n2 != bitArray.getSize()) {
            throw new WriterException("Not all bits consumed: " + n2 + '/' + bitArray.getSize());
        }
    }

    static int findMSBSet(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    static int calculateBCHCode(int n, int n2) {
        int n3 = MatrixUtil.findMSBSet(n2);
        n <<= n3 - 1;
        while (MatrixUtil.findMSBSet(n) >= n3) {
            n ^= n2 << MatrixUtil.findMSBSet(n) - n3;
        }
        return n;
    }

    static void makeTypeInfoBits(ErrorCorrectionLevel errorCorrectionLevel, int n, BitArray bitArray) {
        if (!QRCode.isValidMaskPattern(n)) {
            throw new WriterException("Invalid mask pattern");
        }
        int n2 = errorCorrectionLevel.getBits() << 3 | n;
        bitArray.appendBits(n2, 5);
        int n3 = MatrixUtil.calculateBCHCode(n2, 1335);
        bitArray.appendBits(n3, 10);
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBits(21522, 15);
        bitArray.xor(bitArray2);
        if (bitArray.getSize() != 15) {
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
    }

    static void makeVersionInfoBits(Version version, BitArray bitArray) {
        bitArray.appendBits(version.getVersionNumber(), 6);
        int n = MatrixUtil.calculateBCHCode(version.getVersionNumber(), 7973);
        bitArray.appendBits(n, 12);
        if (bitArray.getSize() != 18) {
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
    }

    private static boolean isEmpty(int n) {
        return n == -1;
    }

    private static void embedTimingPatterns(ByteMatrix byteMatrix) {
        int n = 8;
        while (n < byteMatrix.getWidth() - 8) {
            int n2 = (n + 1) % 2;
            if (MatrixUtil.isEmpty(byteMatrix.get(n, 6))) {
                byteMatrix.set(n, 6, n2);
            }
            if (MatrixUtil.isEmpty(byteMatrix.get(6, n))) {
                byteMatrix.set(6, n, n2);
            }
            ++n;
        }
    }

    private static void embedDarkDotAtLeftBottomCorner(ByteMatrix byteMatrix) {
        if (byteMatrix.get(8, byteMatrix.getHeight() - 8) == 0) {
            throw new WriterException();
        }
        byteMatrix.set(8, byteMatrix.getHeight() - 8, 1);
    }

    private static void embedHorizontalSeparationPattern(int n, int n2, ByteMatrix byteMatrix) {
        int n3 = 0;
        while (n3 < 8) {
            if (!MatrixUtil.isEmpty(byteMatrix.get(n + n3, n2))) {
                throw new WriterException();
            }
            byteMatrix.set(n + n3, n2, 0);
            ++n3;
        }
    }

    private static void embedVerticalSeparationPattern(int n, int n2, ByteMatrix byteMatrix) {
        int n3 = 0;
        while (n3 < 7) {
            if (!MatrixUtil.isEmpty(byteMatrix.get(n, n2 + n3))) {
                throw new WriterException();
            }
            byteMatrix.set(n, n2 + n3, 0);
            ++n3;
        }
    }

    private static void embedPositionAdjustmentPattern(int n, int n2, ByteMatrix byteMatrix) {
        int n3 = 0;
        while (n3 < 5) {
            int n4 = 0;
            while (n4 < 5) {
                byteMatrix.set(n + n4, n2 + n3, POSITION_ADJUSTMENT_PATTERN[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    private static void embedPositionDetectionPattern(int n, int n2, ByteMatrix byteMatrix) {
        int n3 = 0;
        while (n3 < 7) {
            int n4 = 0;
            while (n4 < 7) {
                byteMatrix.set(n + n4, n2 + n3, POSITION_DETECTION_PATTERN[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    private static void embedPositionDetectionPatternsAndSeparators(ByteMatrix byteMatrix) {
        int n = POSITION_DETECTION_PATTERN[0].length;
        MatrixUtil.embedPositionDetectionPattern(0, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(byteMatrix.getWidth() - n, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(0, byteMatrix.getWidth() - n, byteMatrix);
        int n2 = 8;
        MatrixUtil.embedHorizontalSeparationPattern(0, n2 - 1, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(byteMatrix.getWidth() - n2, n2 - 1, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, byteMatrix.getWidth() - n2, byteMatrix);
        int n3 = 7;
        MatrixUtil.embedVerticalSeparationPattern(n3, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(byteMatrix.getHeight() - n3 - 1, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(n3, byteMatrix.getHeight() - n3, byteMatrix);
    }

    private static void maybeEmbedPositionAdjustmentPatterns(Version version, ByteMatrix byteMatrix) {
        if (version.getVersionNumber() < 2) {
            return;
        }
        int n = version.getVersionNumber() - 1;
        int[] nArray = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n];
        int n2 = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n].length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = nArray[n3];
                int n6 = nArray[n4];
                if (n6 != -1 && n5 != -1 && MatrixUtil.isEmpty(byteMatrix.get(n6, n5))) {
                    MatrixUtil.embedPositionAdjustmentPattern(n6 - 2, n5 - 2, byteMatrix);
                }
                ++n4;
            }
            ++n3;
        }
    }
}

