/*
 * Decompiled with CFR 0.152.
 */
package oz.util.drawable;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import oz.util.drawable.TextDrawable$1;
import oz.util.drawable.TextDrawable$Builder;
import oz.util.drawable.TextDrawable$IShapeBuilder;

public class TextDrawable
extends ShapeDrawable {
    private final Paint textPaint;
    private final Paint fillPaint;
    private final Paint borderPaint;
    private static final float SHADE_FACTOR = 0.9f;
    private final String text;
    private final int color;
    private final RectShape shape;
    private final int height;
    private final int width;
    private final float fontSize;
    private final float radius;
    private final float borderThickness;

    private TextDrawable(TextDrawable$Builder textDrawable$Builder) {
        super((Shape)TextDrawable$Builder.access$000(textDrawable$Builder));
        this.shape = TextDrawable$Builder.access$000(textDrawable$Builder);
        this.height = TextDrawable$Builder.access$100(textDrawable$Builder);
        this.width = TextDrawable$Builder.access$200(textDrawable$Builder);
        this.radius = textDrawable$Builder.radius;
        this.text = TextDrawable$Builder.access$300(textDrawable$Builder) ? TextDrawable$Builder.access$400(textDrawable$Builder).toUpperCase() : TextDrawable$Builder.access$400(textDrawable$Builder);
        this.color = textDrawable$Builder.color;
        this.fontSize = TextDrawable$Builder.access$500(textDrawable$Builder);
        this.textPaint = new Paint(1);
        this.textPaint.setColor(textDrawable$Builder.textColor);
        this.textPaint.setFakeBoldText(TextDrawable$Builder.access$600(textDrawable$Builder));
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTypeface(TextDrawable$Builder.access$700(textDrawable$Builder));
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setStrokeWidth(TextDrawable$Builder.access$800(textDrawable$Builder));
        if (textDrawable$Builder.textColorMode != null) {
            this.textPaint.setXfermode((Xfermode)new PorterDuffXfermode(textDrawable$Builder.textColorMode));
        }
        if (textDrawable$Builder.fiilRect) {
            this.fillPaint = new Paint(1);
            this.fillPaint.setStyle(Paint.Style.FILL);
            this.fillPaint.setColor(textDrawable$Builder.fillColor);
        } else {
            this.fillPaint = null;
        }
        this.borderThickness = TextDrawable$Builder.access$800(textDrawable$Builder);
        this.borderPaint = new Paint(1);
        this.borderPaint.setColor(this.getDarkerShade(textDrawable$Builder.borderColor));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(this.borderThickness);
        Paint paint = this.getPaint();
        paint.setColor(this.color);
    }

    private int getDarkerShade(int n) {
        return Color.rgb((int)((int)(0.9f * (float)Color.red((int)n))), (int)((int)(0.9f * (float)Color.green((int)n))), (int)((int)(0.9f * (float)Color.blue((int)n))));
    }

    private void calcIntrinsic(Rect rect) {
        int n = super.getIntrinsicWidth();
        n = n > 0 ? (rect.width() - n) / 2 : 0;
        int n2 = super.getIntrinsicHeight();
        n2 = n2 > 0 ? (rect.height() - n2) / 2 : 0;
        rect.inset(n, n2);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Rect rect = this.getBounds();
        this.calcIntrinsic(rect);
        if (this.fillPaint != null) {
            this.drawBorder(this.fillPaint, rect, canvas);
        }
        if (this.borderThickness > 0.0f) {
            this.drawBorder(this.borderPaint, rect, canvas);
        }
        int n = canvas.save();
        canvas.translate((float)rect.left, (float)rect.top);
        int n2 = this.width < 0 ? rect.width() : this.width;
        int n3 = this.height < 0 ? rect.height() : this.height;
        float f2 = this.fontSize < 0.0f ? (float)(Math.min(n2, n3) / 2) : this.fontSize;
        this.textPaint.setTextSize(f2);
        canvas.drawText(this.text, (float)(n2 / 2), (float)(n3 / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f, this.textPaint);
        canvas.restoreToCount(n);
    }

    private void drawBorder(Paint paint, Rect rect, Canvas canvas) {
        RectF rectF = new RectF(rect);
        if (paint.getStyle() != Paint.Style.FILL) {
            rectF.inset(this.borderThickness / 2.0f, this.borderThickness / 2.0f);
        }
        if (this.shape instanceof OvalShape) {
            canvas.drawOval(rectF, paint);
        } else if (this.shape instanceof RoundRectShape) {
            canvas.drawRoundRect(rectF, this.radius, this.radius, paint);
        } else {
            canvas.drawRect(rectF, paint);
        }
    }

    public void setAlpha(int n) {
        this.textPaint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.textPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public static TextDrawable$IShapeBuilder builder() {
        return new TextDrawable$Builder(null);
    }

    /* synthetic */ TextDrawable(TextDrawable$Builder textDrawable$Builder, TextDrawable$1 textDrawable$1) {
        this(textDrawable$Builder);
    }
}

