/*
 * Decompiled with CFR 0.152.
 */
package oz.util.video;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.WindowManager;
import oz.util.video.VideoGestureListener;

public class ViewGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private static final String TAG = "ViewGestureListener";
    private static final int SWIPE_THRESHOLD = 60;
    public static final int SWIPE_LEFT = 1;
    public static final int SWIPE_RIGHT = 2;
    private VideoGestureListener listener;
    private Context context;

    public ViewGestureListener(Context context, VideoGestureListener videoGestureListener) {
        this.context = context;
        this.listener = videoGestureListener;
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        this.listener.onSingleTap();
        return true;
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
        float f4 = motionEvent.getRawX() - motionEvent2.getRawX();
        float f5 = motionEvent.getRawY() - motionEvent2.getRawY();
        if (Math.abs(f4) > Math.abs(f5)) {
            if (Math.abs(f4) > 60.0f) {
                this.listener.onHorizontalScroll(f4 < 0.0f);
            }
        } else if (Math.abs(f5) > 60.0f) {
            Log.i((String)TAG, (String)("deltaY->" + f5));
            if ((double)motionEvent.getX() < (double)ViewGestureListener.getDeviceWidth(this.context) * 1.0 / 5.0) {
                this.listener.onVerticalScroll(f5 / (float)ViewGestureListener.getDeviceHeight(this.context), 1);
            } else if ((double)motionEvent.getX() > (double)ViewGestureListener.getDeviceWidth(this.context) * 4.0 / 5.0) {
                this.listener.onVerticalScroll(f5 / (float)ViewGestureListener.getDeviceHeight(this.context), 2);
            }
        }
        return true;
    }

    public static int getDeviceWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getDeviceHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }
}

