/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.OverScroller;
import java.lang.reflect.Method;
import oz.main.OZStorage;
import oz.viewer.ui.main.HorizontalPicker$Marquee;
import oz.viewer.ui.main.HorizontalPicker$OnItemClicked;
import oz.viewer.ui.main.HorizontalPicker$OnItemSelected;
import oz.viewer.ui.main.HorizontalPicker$PickerTouchHelper;
import oz.viewer.ui.main.HorizontalPicker$SavedState;

public class HorizontalPicker
extends View {
    public static final String TAG = "HorizontalNumberPicker";
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 4;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private VelocityTracker mVelocityTracker;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private int mOverscrollDistance;
    private int mTouchSlop;
    private int mMaxValue = 0;
    private BoringLayout[] mLayouts;
    private TextPaint mTextPaint;
    private BoringLayout.Metrics mBoringMetrics;
    private TextUtils.TruncateAt mEllipsize;
    private int mItemWidth;
    private RectF mItemClipBounds;
    private RectF mItemClipBoundsOffser;
    private float mLastDownEventX;
    private OverScroller mFlingScrollerX;
    private OverScroller mAdjustScrollerX;
    private int mPreviousScrollerX;
    private boolean mScrollingX;
    private int mPressedItem = -1;
    private HorizontalPicker$OnItemSelected mOnItemSelected;
    private HorizontalPicker$OnItemClicked mOnItemClicked;
    private int mSelectedItem;
    private HorizontalPicker$Marquee mMarquee;
    private int mMarqueeRepeatLimit = 3;
    private float mDividerSize = 0.0f;
    private int mSideItems = 1;
    private TextDirectionHeuristicCompat mTextDir;
    private HorizontalPicker$PickerTouchHelper mTouchHelper;

    public HorizontalPicker(Context context, int n) {
        super(context);
        if (Build.VERSION.SDK_INT >= 14) {
            Object object;
            TextPaint textPaint = new TextPaint();
            textPaint.setAntiAlias(true);
            this.mTextPaint = textPaint;
            int n2 = 2;
            int n3 = this.mSideItems;
            this.mDividerSize = 1.0f;
            n3 = 2;
            float f2 = OZStorage.getDensityDPI();
            float f3 = f2 * this.mTextPaint.getTextSize();
            if (f3 > -1.0f) {
                this.setTextSize(f3);
            }
            switch (n2) {
                case 1: {
                    this.setEllipsize(TextUtils.TruncateAt.START);
                    break;
                }
                case 2: {
                    this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                    break;
                }
                case 3: {
                    this.setEllipsize(TextUtils.TruncateAt.END);
                    break;
                }
                case 4: {
                    this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                }
            }
            try {
                if (Build.VERSION.SDK_INT >= 11) {
                    object = ((Object)((Object)this)).getClass().getMethod("setLayerType", Integer.TYPE, Paint.class);
                    ((Method)object).invoke((Object)this, 1, null);
                }
            }
            catch (Exception exception) {
                Log.d((String)"OZViewer", (String)"Not supported layout type.");
            }
            object = this.mTextPaint.getFontMetricsInt();
            this.mBoringMetrics = new BoringLayout.Metrics();
            this.mBoringMetrics.ascent = ((Paint.FontMetricsInt)object).ascent;
            this.mBoringMetrics.bottom = ((Paint.FontMetricsInt)object).bottom;
            this.mBoringMetrics.descent = ((Paint.FontMetricsInt)object).descent;
            this.mBoringMetrics.leading = ((Paint.FontMetricsInt)object).leading;
            this.mBoringMetrics.top = ((Paint.FontMetricsInt)object).top;
            this.mBoringMetrics.width = this.mItemWidth;
            this.setWillNotDraw(false);
            this.mFlingScrollerX = new OverScroller(context);
            this.mAdjustScrollerX = new OverScroller(context, (Interpolator)new DecelerateInterpolator(2.5f));
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
            this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
            this.mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity() / 4;
            this.mOverscrollDistance = viewConfiguration.getScaledOverscrollDistance();
            this.mPreviousScrollerX = Integer.MIN_VALUE;
            this.setMaxValue(n);
            this.setSideItems(n3);
            this.mTouchHelper = new HorizontalPicker$PickerTouchHelper(this);
            ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mTouchHelper);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n);
        int n6 = View.MeasureSpec.getSize((int)n2);
        if (n4 == 0x40000000) {
            n3 = n6;
        } else {
            Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
            int n7 = (int)(Math.abs(fontMetrics.ascent) + Math.abs(fontMetrics.descent));
            n3 = Math.min(n6, n7 += this.getPaddingTop() + this.getPaddingBottom());
        }
        this.setMeasuredDimension(n5, n3);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = new Paint();
        paint.reset();
        paint.setAntiAlias(false);
        paint.setColor(-7829368);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(1.0f);
        int n = canvas.getSaveCount();
        canvas.save();
        int n2 = this.mSelectedItem;
        float f2 = (float)this.mItemWidth + this.mDividerSize;
        canvas.translate(f2 * (float)this.mSideItems, 0.0f);
        float f3 = 0.0f;
        for (int j = 0; j < this.mMaxValue; ++j) {
            RectF rectF;
            this.mTextPaint.setColor(this.getTextColor(j));
            BoringLayout boringLayout = this.mLayouts[j];
            int n3 = canvas.getSaveCount();
            canvas.save();
            f3 = 0.0f;
            float f4 = boringLayout.getLineWidth(0);
            if (f4 > (float)this.mItemWidth) {
                f3 = this.isRtl(Integer.toString(j + 1)) ? (f3 += (f4 - (float)this.mItemWidth) / 2.0f) : (f3 -= (f4 - (float)this.mItemWidth) / 2.0f);
            }
            if (this.mMarquee != null && j == n2) {
                f3 += this.mMarquee.getScroll();
            }
            canvas.translate(-f3, (float)((canvas.getHeight() - boringLayout.getHeight()) / 2));
            if (f3 == 0.0f) {
                rectF = this.mItemClipBounds;
            } else {
                rectF = this.mItemClipBoundsOffser;
                rectF.set(this.mItemClipBounds);
                rectF.offset(f3, 0.0f);
            }
            canvas.clipRect(rectF);
            boringLayout.draw(canvas);
            if (this.mMarquee != null && j == n2 && this.mMarquee.shouldDrawGhost()) {
                canvas.translate(this.mMarquee.getGhostOffset(), 0.0f);
                boringLayout.draw(canvas);
            }
            canvas.restoreToCount(n3);
            canvas.translate(f2, 0.0f);
        }
        canvas.restoreToCount(n);
        float f5 = this.getScrollX() + canvas.getWidth() / 2;
        float f6 = OZStorage.getDensityDPI();
        float f7 = f6 * 2.0f;
        canvas.drawLine(f5 - f2 / 2.0f, f7, f5 - f2 / 2.0f, (float)canvas.getHeight() - f7, paint);
        canvas.drawLine(f5 + f2 / 2.0f, f7, f5 + f2 / 2.0f, (float)canvas.getHeight() - f7, paint);
    }

    private boolean isRtl(CharSequence charSequence) {
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        return this.mTextDir.isRtl(charSequence, 0, charSequence.length());
    }

    private TextDirectionHeuristicCompat getTextDirectionHeuristic() {
        return TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
    }

    private void remakeLayout() {
        if (this.mLayouts != null && this.mLayouts.length > 0 && this.getWidth() > 0) {
            for (int j = 0; j < this.mLayouts.length; ++j) {
                this.mLayouts[j].replaceOrMake((CharSequence)Integer.toString(j + 1), this.mTextPaint, this.mItemWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, this.mBoringMetrics, false, this.mEllipsize, this.mItemWidth);
            }
        }
    }

    private int getTextColor(int n) {
        int n2 = this.getScrollX();
        int n3 = -7829368;
        int n4 = (int)((float)this.mItemWidth + this.mDividerSize);
        if (n2 > n4 * n - n4 / 2 && n2 < n4 * (n + 1) - n4 / 2) {
            n3 = -16777216;
        } else if (n == this.mPressedItem) {
            n3 = -7829368;
        }
        return n3;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.calculateItemSize(n, n2);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n = motionEvent.getActionMasked();
        switch (n) {
            case 2: {
                float f2 = motionEvent.getX();
                int n2 = (int)(this.mLastDownEventX - f2);
                if (!this.mScrollingX && Math.abs(n2) <= this.mTouchSlop) break;
                if (!this.mScrollingX) {
                    n2 = 0;
                    this.mPressedItem = -1;
                    this.mScrollingX = true;
                    this.stopMarqueeIfNeeded();
                }
                int n3 = this.getScrollRange();
                if (this.overScrollBy(n2, 0, this.getScrollX(), 0, n3, 0, this.mOverscrollDistance, 0, true)) {
                    this.mVelocityTracker.clear();
                }
                this.mLastDownEventX = f2;
                this.invalidate();
                break;
            }
            case 0: {
                if (!this.mAdjustScrollerX.isFinished()) {
                    this.mAdjustScrollerX.forceFinished(true);
                } else if (!this.mFlingScrollerX.isFinished()) {
                    this.mFlingScrollerX.forceFinished(true);
                } else {
                    this.mScrollingX = false;
                }
                this.mLastDownEventX = motionEvent.getX();
                if (!this.mScrollingX) {
                    this.mPressedItem = this.getPositionFromTouch(motionEvent.getX());
                }
                this.invalidate();
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                int n4 = (int)velocityTracker.getXVelocity();
                if (this.mScrollingX && Math.abs(n4) > this.mMinimumFlingVelocity) {
                    this.flingX(n4);
                } else {
                    float f3 = motionEvent.getX();
                    if (!this.mScrollingX) {
                        int n5 = this.getPositionOnScreen(f3);
                        int n6 = n5 - this.mSideItems;
                        if (n6 == 0) {
                            this.selectItem();
                        } else {
                            this.smoothScrollBy(n6);
                        }
                    } else if (this.mScrollingX) {
                        this.finishScrolling();
                    }
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            case 3: {
                this.mPressedItem = -1;
                this.invalidate();
            }
        }
        return true;
    }

    private void selectItem() {
        if (this.mOnItemClicked != null) {
            this.mOnItemClicked.onItemClicked(this.getSelectedItem());
        }
        this.adjustToNearestItemX();
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return super.onKeyDown(n, keyEvent);
        }
        switch (n) {
            case 23: 
            case 66: {
                this.selectItem();
                return true;
            }
            case 21: {
                this.smoothScrollBy(-1);
                return true;
            }
            case 22: {
                this.smoothScrollBy(1);
                return true;
            }
        }
        return super.onKeyDown(n, keyEvent);
    }

    public void computeScroll() {
        this.computeScrollX();
    }

    public void getFocusedRect(Rect rect) {
        super.getFocusedRect(rect);
    }

    public void setOnItemSelectedListener(HorizontalPicker$OnItemSelected horizontalPicker$OnItemSelected) {
        this.mOnItemSelected = horizontalPicker$OnItemSelected;
    }

    public void setOnItemClickedListener(HorizontalPicker$OnItemClicked horizontalPicker$OnItemClicked) {
        this.mOnItemClicked = horizontalPicker$OnItemClicked;
    }

    public int getSelectedItem() {
        int n = this.getScrollX();
        return this.getPositionFromCoordinates(n);
    }

    public void setSelectedItem(int n) {
        this.mSelectedItem = n;
        this.scrollToItem(n);
    }

    public int getMarqueeRepeatLimit() {
        return this.mMarqueeRepeatLimit;
    }

    public void setMarqueeRepeatLimit(int n) {
        this.mMarqueeRepeatLimit = n;
    }

    public int getSideItems() {
        return this.mSideItems;
    }

    public void setSideItems(int n) {
        if (this.mSideItems < 0) {
            throw new IllegalArgumentException("Number of items on each side must be grater or equal to 0.");
        }
        if (this.mSideItems != n) {
            this.mSideItems = n;
            this.calculateItemSize(this.getWidth(), this.getHeight());
        }
    }

    public void scrollBy(int n, int n2) {
        super.scrollBy(n, 0);
    }

    public void scrollTo(int n, int n2) {
        super.scrollTo(n, n2);
    }

    public int getValue() {
        return this.getSelectedItem() + 1;
    }

    public void setValue(int n) {
        if (n <= 0 || n > this.mMaxValue) {
            return;
        }
        if (this.mOnItemSelected != null) {
            this.mOnItemSelected.onItemSelected(n - 1);
        }
        this.setSelectedItem(n - 1);
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int n) {
        this.mMaxValue = n;
        int n2 = 0;
        this.mLayouts = new BoringLayout[n];
        for (int j = 0; j < n; ++j) {
            n2 = j + 1;
            this.mLayouts[j] = new BoringLayout((CharSequence)Integer.toString(n2), this.mTextPaint, this.mItemWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, this.mBoringMetrics, false, this.mEllipsize, this.mItemWidth);
        }
        if (this.getWidth() > 0) {
            this.startMarqueeIfNeeded();
        }
        this.requestLayout();
        this.invalidate();
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof HorizontalPicker$SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        HorizontalPicker$SavedState horizontalPicker$SavedState = (HorizontalPicker$SavedState)parcelable;
        super.onRestoreInstanceState(horizontalPicker$SavedState.getSuperState());
        this.setSelectedItem(HorizontalPicker$SavedState.access$000(horizontalPicker$SavedState));
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        HorizontalPicker$SavedState horizontalPicker$SavedState = new HorizontalPicker$SavedState(parcelable);
        HorizontalPicker$SavedState.access$002(horizontalPicker$SavedState, this.mSelectedItem);
        return horizontalPicker$SavedState;
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.mEllipsize;
    }

    public void setEllipsize(TextUtils.TruncateAt truncateAt) {
        if (this.mEllipsize != truncateAt) {
            this.mEllipsize = truncateAt;
            this.remakeLayout();
            this.invalidate();
        }
    }

    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        super.scrollTo(n, n2);
        if (!this.mFlingScrollerX.isFinished() && bl) {
            this.mFlingScrollerX.springBack(n, n2, 0, this.getScrollRange(), 0, 0);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
    }

    private int getPositionFromTouch(float f2) {
        return this.getPositionFromCoordinates((int)((float)this.getScrollX() - ((float)this.mItemWidth + this.mDividerSize) * ((float)this.mSideItems + 0.5f) + f2));
    }

    private void computeScrollX() {
        OverScroller overScroller = this.mFlingScrollerX;
        if (overScroller.isFinished() && (overScroller = this.mAdjustScrollerX).isFinished()) {
            return;
        }
        if (overScroller.computeScrollOffset()) {
            int n = overScroller.getCurrX();
            if (this.mPreviousScrollerX == Integer.MIN_VALUE) {
                this.mPreviousScrollerX = overScroller.getStartX();
            }
            this.overScrollBy(n - this.mPreviousScrollerX, 0, this.mPreviousScrollerX, this.getScrollY(), this.getScrollRange(), 0, this.mOverscrollDistance, 0, false);
            this.mPreviousScrollerX = n;
            if (overScroller.isFinished()) {
                this.onScrollerFinishedX(overScroller);
            }
            this.postInvalidate();
        }
    }

    private void flingX(int n) {
        this.mPreviousScrollerX = Integer.MIN_VALUE;
        this.mFlingScrollerX.fling(this.getScrollX(), this.getScrollY(), -n, 0, 0, (int)((float)this.mItemWidth + this.mDividerSize) * (this.mMaxValue - 1), 0, 0, this.getWidth() / 2, 0);
        this.invalidate();
    }

    private void adjustToNearestItemX() {
        int n = this.getScrollX();
        int n2 = Math.round((float)n / ((float)this.mItemWidth + this.mDividerSize * 1.0f));
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.mMaxValue) {
            n2 = this.mMaxValue;
        }
        this.mSelectedItem = n2;
        int n3 = (this.mItemWidth + (int)this.mDividerSize) * n2;
        int n4 = n3 - n;
        this.mAdjustScrollerX.startScroll(n, 0, n4, 0, 800);
        this.invalidate();
    }

    private void calculateItemSize(int n, int n2) {
        int n3 = this.mSideItems * 2 + 1;
        int n4 = (int)this.mDividerSize * (n3 - 1);
        this.mItemWidth = (n - n4) / n3;
        this.mItemClipBounds = new RectF(0.0f, 0.0f, (float)this.mItemWidth, (float)n2);
        this.mItemClipBoundsOffser = new RectF(this.mItemClipBounds);
        this.scrollToItem(this.mSelectedItem);
        this.remakeLayout();
        this.startMarqueeIfNeeded();
    }

    private void onScrollerFinishedX(OverScroller overScroller) {
        if (overScroller == this.mFlingScrollerX) {
            this.finishScrolling();
        }
    }

    private void finishScrolling() {
        this.adjustToNearestItemX();
        this.mScrollingX = false;
        if (this.mOnItemSelected != null) {
            this.mOnItemSelected.onItemSelected(this.getPositionFromCoordinates(this.getScrollX()));
        }
        this.startMarqueeIfNeeded();
    }

    private void startMarqueeIfNeeded() {
        this.stopMarqueeIfNeeded();
        int n = this.getSelectedItem();
        BoringLayout boringLayout = this.mLayouts[n];
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && (float)this.mItemWidth < boringLayout.getLineWidth(0)) {
            this.mMarquee = new HorizontalPicker$Marquee(this, (Layout)boringLayout, this.isRtl(Integer.toString(n + 1)));
            this.mMarquee.start(this.mMarqueeRepeatLimit);
        }
    }

    private void stopMarqueeIfNeeded() {
        if (this.mMarquee != null) {
            this.mMarquee.stop();
            this.mMarquee = null;
        }
    }

    private int getPositionOnScreen(float f2) {
        return (int)(f2 / ((float)this.mItemWidth + this.mDividerSize));
    }

    private void smoothScrollBy(int n) {
        int n2 = (this.mItemWidth + (int)this.mDividerSize) * n;
        n2 = this.getRelativeInBound(n2);
        this.mFlingScrollerX.startScroll(this.getScrollX(), 0, n2, 0);
        this.stopMarqueeIfNeeded();
        this.invalidate();
    }

    private void setTextSize(float f2) {
        if (f2 != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(f2);
            this.requestLayout();
            this.invalidate();
        }
    }

    private int getPositionFromCoordinates(int n) {
        return Math.round((float)n / ((float)this.mItemWidth + this.mDividerSize));
    }

    private void scrollToItem(int n) {
        this.scrollTo((this.mItemWidth + (int)this.mDividerSize) * n, 0);
        this.invalidate();
    }

    private int getRelativeInBound(int n) {
        int n2 = this.getScrollX();
        return this.getInBoundsX(n2 + n) - n2;
    }

    private int getInBoundsX(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > (this.mItemWidth + (int)this.mDividerSize) * (this.mMaxValue - 1)) {
            n = (this.mItemWidth + (int)this.mDividerSize) * (this.mMaxValue - 1);
        }
        return n;
    }

    private int getScrollRange() {
        int n = 0;
        if (this.mMaxValue != 0) {
            n = Math.max(0, (this.mItemWidth + (int)this.mDividerSize) * (this.mMaxValue - 1));
        }
        return n;
    }

    static /* synthetic */ int access$100(HorizontalPicker horizontalPicker) {
        return horizontalPicker.mItemWidth;
    }

    static /* synthetic */ float access$200(HorizontalPicker horizontalPicker) {
        return horizontalPicker.mDividerSize;
    }

    static /* synthetic */ int access$300(HorizontalPicker horizontalPicker) {
        return horizontalPicker.mSideItems;
    }

    static /* synthetic */ int access$400(HorizontalPicker horizontalPicker) {
        return horizontalPicker.mMaxValue;
    }
}

