/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageButton;
import oz.viewer.ui.main.overlay.AButtonInfo;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.ToolbarManagerBase;

public class ABottomToolbarButtonInfo
extends AButtonInfo {
    public static final int BTN_INPUT_SIGN = 0;
    public static final int BTN_INPUT_TEXT = 1;
    public static final int BTN_INPUT_COUNT = 2;
    public static final String[][] TOOLBAR_BUTTON_IMAGES = new String[][]{{"resource/bottom_input_bt01d.png", "resource/bottom_input_bt01.png"}, {"resource/bottom_input_bt02d.png", "resource/bottom_input_bt02.png"}};
    private static final int TOOLBAR_BUTTON_ENABLE = 0;
    private static final int TOOLBAR_BUTTON_DISABLE = 1;
    private int mShowIndex;

    public ABottomToolbarButtonInfo(ToolbarManagerBase toolbarManagerBase, int n) {
        super(toolbarManagerBase, n, n);
        this.setShowIndex(Integer.MAX_VALUE);
        this.setVisibility(8);
        this.setEnabled(false);
    }

    protected void initButtonImage(ImageButton imageButton) {
        imageButton.setImageDrawable((Drawable)AOverlayUtil.getListViewStateListDrawableFromAsset(imageButton.getContext(), this.getImagesPath(), this.getImagesDisablePath(), AOverlayUtil.DpToPx(50)));
    }

    protected void updateButtonEnable(ImageButton imageButton) {
    }

    protected String getImagesPath() {
        return TOOLBAR_BUTTON_IMAGES[this.getIndex()][0];
    }

    protected String getImagesDisablePath() {
        return TOOLBAR_BUTTON_IMAGES[this.getIndex()][1];
    }

    public void setShowIndex(int n) {
        this.mShowIndex = n;
    }

    public int getShowIndex() {
        return this.mShowIndex;
    }

    protected boolean onClickInternal(View view) {
        this.getParent().getNativeController().OnBottomToolbarClickEvent(0, this.getIndex());
        return true;
    }

    public int compareTo(AButtonInfo aButtonInfo) {
        if (aButtonInfo instanceof ABottomToolbarButtonInfo) {
            return this.getShowIndex() - ((ABottomToolbarButtonInfo)aButtonInfo).getShowIndex();
        }
        return super.compareTo(aButtonInfo);
    }
}

