/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oz.viewer.ui.main.overlay.AButtonInfo;
import oz.viewer.ui.main.overlay.ACommentButtonInfo;
import oz.viewer.ui.main.overlay.AGuideModeButtonInfo;
import oz.viewer.ui.main.overlay.AParameterButtonInfo;
import oz.viewer.ui.main.overlay.AToolbarButtonInfo;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.ToolbarManagerBase;

public class AToolbarManager
extends ToolbarManagerBase {
    public static final int BUTTON_TYPE_GUIDE = 1;
    public static final int BUTTON_TYPE_COMMENT = 2;
    public static final int BUTTON_TYPE_PARAMETER = 3;
    public static final int BUTTON_TYPE_ICON = 4;
    public static final int BUTTON_TYPE_COUNT = 5;

    public AToolbarManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 1, 5);
    }

    protected void preInitView() {
        int n;
        for (n = 6000; n <= 6001; ++n) {
            this.addButton(1, new AGuideModeButtonInfo(this, n, n));
        }
        for (n = 5000; n <= 5001; ++n) {
            this.addButton(2, new ACommentButtonInfo(this, n, n));
        }
        this.getButtonFromKey(1, 6001).setVisibility(8);
        this.getButtonFromKey(2, 5001).setVisibility(8);
        this.addButton(3, new AParameterButtonInfo(this));
        this.setButtonTypeVisibility(1, false);
        this.setButtonTypeVisibility(2, false);
        this.setButtonTypeVisibility(3, false);
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)overlayLayout.findLayout(21110);
        frameLayout.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
    }

    public void requestUpdateView() {
        super.requestUpdateView();
        if (!this.getOZParent().getScreenToolController().isCommentMode()) {
            this.getOZParent().getNavigator().requestUpdateView();
        }
    }

    public void show() {
        super.show();
        if (!this.getOZParent().getScreenToolController().isCommentMode()) {
            this.getOZParent().getNavigator().show();
        }
    }

    public AButtonInfo[] getButtons(int n) {
        if (n == 4) {
            AButtonInfo[] aButtonInfoArray = new AButtonInfo[this.getButtonCount(n)];
            ((Map)this.getButtonInfos().get(n)).values().toArray(aButtonInfoArray);
            List<AButtonInfo> list = Arrays.asList(aButtonInfoArray);
            Collections.sort(list);
            return list.toArray(aButtonInfoArray);
        }
        return super.getButtons(n);
    }

    public void addToolbarButton(int n, int n2) {
        if (n == -1) {
            return;
        }
        this.addButton(4, new AToolbarButtonInfo(this, n, n2, ((Map)this.getButtonInfos().get(4)).size()));
    }

    public boolean isAutoHideEnable() {
        if (this.getOZParent().getScreenToolController().isHandMode()) {
            return super.isAutoHideEnable();
        }
        return this.getOZParent().getCommentManager().isAutoHideEnable();
    }
}

