package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#contentVersion} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ApertureMasterDataJSON extends AcmsCommonJSON {
	private static final String apertureLastEditDate = "apertureLastEditDate";
	private static final String ApertureData = "apertureData";
	public String lastEditDate;
    public JSONObject apertureData;

	public ApertureMasterDataJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		// 絞り検索の日付を取得
		if(json.has(apertureLastEditDate)) {
			this.lastEditDate = json.getString(apertureLastEditDate);
		}

		// 絞り検索のデータを取得
		if (json.has(ApertureData)) {
			this.apertureData = JsonUtil.getJSONObject(json, ApertureData);
		}
	}
}
