package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.Date;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.dto.ChatGroupDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class GroupListJSON extends AcmsCommonJSON {


    public ArrayList<ChatGroupDto> groupList;
    public String lastRequestDate;

    public GroupListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }
        if (!json.getJSONObject(ABookCommConstants.KEY.BODY).has(ABookCommConstants.KEY.GROUP_INFO_LIST)) { return; }

        JSONArray groupListJsonArray = json.getJSONObject(ABookCommConstants.KEY.BODY).getJSONArray(ABookCommConstants.KEY.GROUP_INFO_LIST);
        if (groupListJsonArray == null) { return; }

        groupList = new ArrayList<ChatGroupDto>();
        for (int listCount = 0; listCount < groupListJsonArray.length(); listCount++) {
            if (groupListJsonArray.getJSONObject(listCount).length() == 0) {
                break;
            }
            JSONObject groupJSON = groupListJsonArray.getJSONObject(listCount);

            ChatGroupDto groupDto = new ChatGroupDto();

            groupDto.groupId = groupJSON.getInt(ABookCommConstants.KEY.GROUP_ID);
            if (groupJSON.has(ABookCommConstants.KEY.PARENT_GROUP_ID)) {
                groupDto.parentGroupId = groupJSON.getInt(ABookCommConstants.KEY.PARENT_GROUP_ID);
            }
            groupDto.groupName = groupJSON.getString(ABookCommConstants.KEY.GROUP_NAME);
            groupDto.delFlg = groupJSON.getInt(ABookCommConstants.KEY.DEL_FLG);
            if (groupJSON.has(ABookCommConstants.KEY.GROUP_MEMBER_LIST)) {
                JSONArray groupMemberJsonArray = groupJSON.getJSONArray(ABookCommConstants.KEY.GROUP_MEMBER_LIST);
                ArrayList<ShopMemberDto> groupMembers = new ArrayList<ShopMemberDto>();
                for (int groupMemberCount = 0; groupMemberCount < groupMemberJsonArray.length(); groupMemberCount++) {
                    JSONObject groupMember = groupMemberJsonArray.getJSONObject(groupMemberCount);
                    ShopMemberDto shopMemberDto = new ShopMemberDto();
                    shopMemberDto.shopMemberId = groupMember.getInt(ABookCommConstants.KEY.SHOP_MEMBER_ID);
                    shopMemberDto.shopMemberName = groupMember.getString(ABookCommConstants.KEY.MEMBER_NAME);
                    shopMemberDto.loginId = groupMember.getString(ABookCommConstants.KEY.LOGIN_ID);
                    shopMemberDto.delFlg = groupMember.getInt(ABookCommConstants.KEY.DEL_FLG);
                    if (groupMember.has(ABookCommConstants.KEY.PROFILE_IMAGE_PATH)) {
                        shopMemberDto.profileUrl = groupMember.getString(ABookCommConstants.KEY.PROFILE_IMAGE_PATH);
                    }
                    groupMembers.add(shopMemberDto);
                }
                groupDto.groupMembers = groupMembers;
            }
            groupList.add(groupDto);
        }
        String time = JsonUtil.getString(json, PresentTime);
        presentTime = DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
        lastRequestDate = DateTimeUtil.toString(presentTime, DateTimeFormat.yyyyMMddHHmmss_none);

    }
}

