package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.dto.TaskDto;
import jp.agentec.abook.abv.bl.dto.TaskReportApprovalDto;


public class ProcessDataJSON extends AcmsCommonJSON {
    private static final String ProcessList = "processList";
    private static final String PhaseList = "phaseList";
    private static final String ApprovalList = "approvalList";
    private static final String ProcessKey = "processKey";
    private static final String ProcessStatus = "processStatus";
    private static final String PhaseNo = "phaseNo";
    private static final String PhaseStatus = "phaseStatus";
    private static final String ApprovalGroupId = "approvalGroupId";
    private static final String ApprovalGroupName = "approvalGroupName";
    private static final String ApprovalName = "approvalName";
    private static final String ApprovalNo = "approvalNo";
    private static final String Comment = "comment";
    private static final String SendbackPhaseNo = "sendbackPhaseNo";
    private static final String Signature = "signature";
    private static final String Status = "status";

    public List<TaskDto> taskDtoList;

    public ProcessDataJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) {

        taskDtoList = new ArrayList<TaskDto>();

        if (json.has(ProcessList)) {
            JSONArray taskList = json.getJSONArray(ProcessList);

            for (int i = 0; i < taskList.length(); i++) {
                JSONObject taskJson = taskList.getJSONObject(i);
                TaskDto taskDto = new TaskDto();
                taskDto.processKey = taskJson.getString(ProcessKey);
                taskDto.processStatus = taskJson.getInt(ProcessStatus);

                if (!taskJson.has(PhaseList)) {
                    continue;
                }
                JSONArray phaseList = taskJson.getJSONArray(PhaseList);
                taskDto.phaseList = new ArrayList<TaskDto>();
                for (int j = 0; j < phaseList.length(); j++) {
                    JSONObject phaseJson = phaseList.getJSONObject(j);
                    TaskDto phaseTaskDto = new TaskDto();
                    phaseTaskDto.phaseNo = phaseJson.getInt(PhaseNo);
                    phaseTaskDto.phaseStatus = phaseJson.getInt(PhaseStatus);

                    if (!phaseJson.has(ApprovalList)) {
                        continue;
                    }
                    JSONArray approvalList = phaseJson.getJSONArray(ApprovalList);
                    phaseTaskDto.taskReportApprovalDtoList = new ArrayList<TaskReportApprovalDto>();
                    for (int k = 0; k < approvalList.length(); k++) {
                        JSONObject approvalJson = approvalList.getJSONObject(k);
                        TaskReportApprovalDto taskReportApprovalDto = new TaskReportApprovalDto();
                        taskReportApprovalDto.approvalGroupId = approvalJson.getInt(ApprovalGroupId);
                        taskReportApprovalDto.approvalGroupName = approvalJson.getString(ApprovalGroupName);
                        taskReportApprovalDto.approvalName = approvalJson.getString(ApprovalName);
                        taskReportApprovalDto.approvalNo = approvalJson.getInt(ApprovalNo);
                        taskReportApprovalDto.comment = approvalJson.getString(Comment);
                        taskReportApprovalDto.sendbackPhaseNo = approvalJson.getInt(SendbackPhaseNo);
                        taskReportApprovalDto.signature = approvalJson.getString(Signature);
                        taskReportApprovalDto.status = approvalJson.getInt(Status);
                        phaseTaskDto.taskReportApprovalDtoList.add(taskReportApprovalDto);
                    }
                    taskDto.phaseList.add(phaseTaskDto);
                }
                taskDtoList.add(taskDto);
            }
        }
    }
}
