package jp.agentec.abook.abv.bl.acms.client.parameters;

/**
 * ACMSのAPIに渡すパラメータの中で、共通的にコンテンツIDを使うパラメータを格納します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class AcmsContentParameters extends AcmsParameters {
	private long contentId;
	
	/**
	 * {@link AcmsContentParameters} クラスのインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param contentId 確認するコンテンツのIDです。
	 * @since 1.0.0
	 */
	public AcmsContentParameters(String sid, long contentId) {
		super(sid);
		
		this.contentId = contentId;
	}
	
	/**
	 * 確認するコンテンツのIDを返します。
	 * @return　確認するコンテンツのIDです。
	 * @since 1.0.0
	 */
	public long getContentId() {
		return contentId;
	}
}
