package jp.agentec.abook.abv.bl.acms.client.parameters;

/**
 * アプリの最新バージョンを取得するパラメータ
 * @author Jang
 * @version 1.0.0
 */
public class AppLastVersionParameters extends AcmsParameters {
	private String appVersion;
	private String appId;
	private String uid;
	private String ma;
	
	/**
	 * {@link AppLastVersionParameters} クラスのインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param appVersion アプリのバージョン
	 * @param uid 端末のUDIDです。
	 * @param appId　アプリIDです。（iPad:1, android:3）
     * @param ma MacAddress
	 * @since 1.0.0
	 */
	public AppLastVersionParameters(String sid, String appVersion, String appId, String uid, String ma) {
		super(sid);
		
		this.appVersion = appVersion;
		this.appId = appId;
		this.uid = uid;
		this.ma = ma;
	}

	/**
	 * アプリバージョンを返します。
	 * @return アプリバージョンです。
	 * @since 1.0.0
	 */
	public String getAppVersion() {
		return appVersion;
	}

	/**
	 * アプリIDを返します。
	 * @return　アプリIDです。（iPad:1, android:3）
	 * @since 1.0.0
	 */
	public String getAppId() {
		return appId;
	}

	public String getUid() {
		return uid;
	}

	/**
	 * MacAddressを返します。
	 * @return MacAddress
	 */
	public String getMa() {
		return ma;
	}

}
