package jp.agentec.abook.abv.bl.acms.type;

/**
 * コンテンツを検索する際、検索をかける項目を示します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public enum SearchDivisionType {
	/**
	 * タイトルを検索します。
	 * @since 1.0.0
	 */
	Title(1),
	/**
	 * タグを検索します。
	 * @since 1.0.0
	 */
	Tag(2),
	/**
	 * 全文を検索します。
	 * @since 1.0.0
	 */
	FullText(3),
	/**
	 * メモ本文を検索します。
	 * @since 1.0.0
	 */	
	Memo(4);
	
	private final int searchDivision;
	
	SearchDivisionType(int searchDivision) {
		this.searchDivision = searchDivision;
	}
	
	/**
	 * 検索をかける項目の番号を返します。
	 * @return　検索をかける項目の番号です。
	 * @since 1.0.0
	 */
	public int type() {
		return searchDivision;
	}

	/**
	 * 指定した数字に対応するSecurityPolicyCodeの値を返します。
	 * @param searchDivision 数字のコードです。
	 * @return　指定した数字に対応するSearchDivisionTypeの値です。
	 * @since 1.0.0
	 */
	public static SearchDivisionType parse(int searchDivision) {
		SearchDivisionType divisionType;
		
		switch (searchDivision) {
		case 1:
			divisionType = SearchDivisionType.Title;
			break;
		case 2:
			divisionType = SearchDivisionType.Tag;
			break;
		case 3:
			divisionType = SearchDivisionType.FullText;
			break;
		default:
			divisionType = SearchDivisionType.Memo;
			break;
		}
		
		return divisionType;
	}
}
