package jp.agentec.abook.abv.bl.common.exception;


public class ABVRuntimeException extends RuntimeException {
	private static final long serialVersionUID = 5876698825970923495L;
	private ABVExceptionCode code;

	public ABVRuntimeException(ABVExceptionCode code) {
		super();
		this.code = code;
	}

	public ABVRuntimeException(ABVExceptionCode code, String message) {
		super(message);
		this.code = code;
	}

	public ABVRuntimeException(String message) {
		super(message);
	}

	public ABVRuntimeException(Throwable t) {
		super(t);
	}

	public ABVRuntimeException(String message, Throwable t) {
		super(message, t);
	}

	public ABVExceptionCode getCode() {
		return code;
	}
	
	@Override
	public String toString() {
		return String.format("%s: code: %s, message: %s", getClass().getName(), code, getMessage());
	}

}
