package jp.agentec.abook.abv.bl.data;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;

/**
 * アンドロイド内部のSQLiteデータベースをSDカード等の場所にエクスポートします。<br>
 * データベースをエクスポートする行為はアプリケーションをセキュリティレベルを低下させる原因となります。<br>
 * このクラスは、テスト及びデバッグ用途以外には使用しないことを勧奨します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class DatabaseExporter {
	private static final String TAG = "DatabaseExporter";


	/*package*/ DatabaseExporter() {
	}

	public static final void fileExport(String fromPath, String toPath) throws IOException {
        if (StringUtil.isNullOrWhiteSpace(toPath)) {
            throw new RuntimeException("Exporting unsuccesful. Arguments now allowed white space.");
        }

        InputStream is = null;
        OutputStream os = null;

        try {
            is = new FileInputStream(fromPath);
            FileUtil.createNewDirectory(FileUtil.getParentPath(toPath));
            os = new FileOutputStream(toPath);

            byte[] buffer = new byte[1024];
            int length;

            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }

            os.flush();

            Logger.i(TAG, "Exporting succesful.");
        } catch (IOException e) {
            String msg = "Exporting unseccesful.";
            Logger.e("DatabaseExporter", msg, e);
            throw e;
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e2) {
                }
            }

            if (is != null) {
                try {
                    is.close();
                } catch (IOException e2) {
                }
            }
        }
    }


	public static final void export(String exportPath) throws IOException {
		
		SQLiteDatabase db = DBConnector.getInstance().getDatabase();
		String databasePath = db.getPath();
		
		Logger.i(TAG, String.format("Exporting a SQLite database from [%s] to [%s].", databasePath, exportPath));
		
		if (StringUtil.isNullOrWhiteSpace(databasePath)) {
			throw new RuntimeException("A database is no exist.");
		}
        fileExport(databasePath, exportPath);

	}
}
