package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.AcmsDto;


public class AcmsDao extends AbstractDao {

	/*package*/ AcmsDao() {
	}

	@Override
	protected AcmsDto convert(Cursor cursor) {
		AcmsDto dto = new AcmsDto();

		int colnum = cursor.getColumnIndex("url_path");
		if (colnum != -1) {
			dto.urlPath = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("acms_address");
		if (colnum != -1) {
			dto.acmsAddress = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("download_server_address");
		if (colnum != -1) {
			dto.downloadServerAddress = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("websocket_server_http_url");
		if (colnum != -1) {
			dto.websocketServerHttpUrl = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("websocket_server_ws_url");
		if (colnum != -1) {
			dto.websocketServerWsUrl = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("schedulelist_last_fetch_date");
		if (colnum != -1) {
			dto.scheduleListLastFetchDate = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("contentversion_last_fetch_date");
		if (colnum != -1) {
			dto.contentVersionLastFetchDate = cursor.getString(colnum);
		}

		return dto;
	}

	public String getUrlPath() {
		return rawQueryGetString("select url_path from m_acms", null);
	}

	public AcmsDto getAcms() {
		return rawQueryGetDto("select * from m_acms", null, AcmsDto.class);
	}

	public void insert(AcmsDto acmsDto) {
		insert("insert into m_acms (url_path, acms_address,download_server_address, websocket_server_http_url, websocket_server_ws_url, schedulelist_last_fetch_date, contentversion_last_fetch_date) values (?,?,?,?,?,?,?)", acmsDto.getInsertValues());
	}

	/**
	 * ログイン情報の削除
	 */
	public void deleteAcms() {
		delete("m_acms", "", null);
	}

	public boolean isTodayLastAnnounceChangePasswordDate() {
		int ret = rawQueryGetInt("select COUNT(url_path) AS last_count from m_acms where last_announce_change_password_date=DATE('NOW','LOCALTIME')", null);
		return ret > 0;
	}

	public void updateLastAnnounceChangePasswordDate() {
		update("update m_acms set last_announce_change_password_date=DATE('NOW','LOCALTIME')", null);
	}

    public String selectContentVersionLastFetchDate() {
        String lastFetchDate = rawQueryGetString("select contentversion_last_fetch_date from m_acms order by contentversion_last_fetch_date desc limit 1", null);
        if (lastFetchDate == null) {
            return null;
        }
        return lastFetchDate;
    }

    public boolean updateScheduleListLastFetchDate(String fetchDate) {
        long count = update("update m_acms set schedulelist_last_fetch_date=?", new Object[]{fetchDate});
        return count > 0;
    }

    public boolean updateContentVersionLastFetchDate(String fetchDate) {
        long count = update("update m_acms set contentversion_last_fetch_date=?", new Object[]{fetchDate});
        return count > 0;
    }

    public void clearFetchDate() {
        updateScheduleListLastFetchDate("");
        updateContentVersionLastFetchDate("");
    }
}
