package jp.agentec.abook.abv.bl.data.dao;

import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * Created by kim jinsung on 2018/09/17.
 */

public class PushMessageDao extends AbstractDao {
    private static final String TAG = "PushMessageDao";

    @Override
    protected PushMessageDto convert(Cursor cursor) {
        PushMessageDto dto = new PushMessageDto();

        int column = cursor.getColumnIndex("push_message_id");
        if (column != -1) {
            dto.pushMessageId = cursor.getLong(column);
        }

        column = cursor.getColumnIndex("operation_id");
        if (column != -1) {
            dto.operationId = cursor.getLong(column);
        }

        column = cursor.getColumnIndex("push_send_login_id");
        if (column != -1) {
            dto.pushSendLoginId = cursor.getString(column);
        }

        column = cursor.getColumnIndex("push_send_date");
        if (column != -1) {
            dto.pushSendDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmm_hyphen);
        }
        column = cursor.getColumnIndex("push_message");
        if (column != -1) {
            dto.pushMessage = cursor.getString(column);
        }
        column = cursor.getColumnIndex("reading_flg");
        if (column != -1) {
            dto.readingFlg = toBool(cursor.getInt(column));
        }
        column = cursor.getColumnIndex("room_id");
        if (column != -1) {
            dto.roomId = cursor.getLong(column);
        }
        column = cursor.getColumnIndex("room_name");
        if (column != -1) {
            dto.roomName = cursor.getString(column);
        }
        column = cursor.getColumnIndex("operation_name");
        if (column != -1) {
            dto.operationName = cursor.getString(column);
        }
        return dto;
    }
    public void insert(PushMessageDto dto) {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT OR IGNORE INTO t_push_message ");
        sql.append(" (push_message_id, operation_id, push_send_login_id, push_send_date, push_message, reading_flg, room_id, room_name) ");
        sql.append(" VALUES (?,?,?,?,?,?,?,?) ");
        try {
            beginTransaction();
            insert(sql.toString(), dto.getInsertValues());
            commit();
        } catch (Exception e) {
            rollback();
            Logger.e("insert PushMessageDto failed.", e);
            throw new RuntimeException(e);
        }
        Logger.v(TAG, "sql=%s", sql);
    }

    public void updateReadingFlg(long pushMessageId) {
        String[] args = new String[] { "" + pushMessageId };
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE t_push_message ");
        sql.append("    SET reading_flg = 1 ");
        sql.append("  WHERE push_message_id = ? ");
        try {
            beginTransaction();
            update(sql.toString(), args);
            commit();
        } catch (Exception e) {
            rollback();
            Logger.e("updateReadingFlg failed.", e);
            throw new RuntimeException(e);
        }

        Logger.v(TAG, "sql=%s", sql);
    }
    public void delete(long operationId) {
        String[] args = new String[] { "" + operationId };
        delete("t_push_message", "operation_id=?", args);
    }

    public List<PushMessageDto> selectAll() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tpm.push_message_id, tpm.operation_id, tpm.push_send_login_id, tpm.push_send_date, tpm.push_message, tpm.reading_flg, top.operation_name, tpm.room_id, tpm.room_name ");
        sql.append(" FROM t_push_message AS tpm ");
        sql.append(" LEFT OUTER JOIN t_operation AS top ");
        sql.append(" ON tpm.operation_id = top.operation_id ");
        sql.append(" ORDER BY tpm.push_message_id DESC ");
        Logger.v(TAG, "sql=%s", sql);
        return rawQueryGetDtoList(sql.toString(), null, PushMessageDto.class);
    }

    public PushMessageDto select(long pushMessageId) {
        String[] args = new String[] { "" + pushMessageId };
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tpm.push_message_id, tpm.operation_id, tpm.push_send_login_id, tpm.push_send_date, tpm.push_message, tpm.reading_flg, top.operation_name, tpm.room_id, tpm.room_name ");
        sql.append(" FROM t_push_message AS tpm ");
        sql.append(" INNER JOIN t_operation AS top ");
        sql.append(" ON tpm.operation_id = top.operation_id ");
        sql.append(" WHERE tpm.push_message_id = ? ");
        Logger.v(TAG, "sql=%s", sql);
        return rawQueryGetDto(sql.toString(), args, PushMessageDto.class);
    }

    public PushMessageDto selectChat(long pushMessageId, long pushOperstoinId, Date pushSendDate) {
        String[] args = new String[] { "" + pushMessageId, "" + pushOperstoinId, "" + pushSendDate };
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tpm.push_message_id, tpm.operation_id, tpm.push_send_login_id, tpm.push_send_date, tpm.push_message, tpm.reading_flg, top.operation_name, tpm.room_id, tpm.room_name ");
        sql.append(" FROM t_push_message AS tpm ");
        sql.append(" INNER JOIN t_operation AS top ");
        sql.append(" ON tpm.operation_id = top.operation_id ");
        sql.append(" WHERE tpm.push_message_id = ? ");
        sql.append(" AND tpm.operation_id = ? ");
        sql.append(" AND tpm.push_send_date = ? " );
        Logger.v(TAG, "sql=%s", sql);
        return rawQueryGetDto(sql.toString(), args, PushMessageDto.class);
    }


}
