package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;

public class TContentResource extends SQLiteTableScript {
	
	public TContentResource() {
		super();
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE t_content_resource ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , sub_directory TEXT NOT NULL ");
		sql.append("      , resource_file_name TEXT NOT NULL ");
		sql.append("      , hashed_file_name TEXT ");
		sql.append("      , hashed_file_header BLOB ");
		sql.append("      , PRIMARY KEY (content_id, sub_directory, resource_file_name) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
