package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.log.LogLevel;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.ContentReadingLogDto;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ContentReadingLogDaoTest extends TestCase {

	private ContentReadingLogDao dao = AbstractDao.getDao(ContentReadingLogDao.class);

	public ContentReadingLogDaoTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		ABVEnvironment.getInstance().setLogLevel(LogLevel.verbose);

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("ContentReadingLogDaoTest");
//		suite.addTest(new ContentReadingLogDaoTest("deleteUnsendLog"));
		suite.addTest(new ContentReadingLogDaoTest("getUnsentSignageLog"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void deleteUnsendLog() {
		dao.deleteUnsendLog(null);
		dao.deleteUnsendLog("");
		dao.deleteUnsendLog("2578");
		dao.deleteUnsendLog("2577,2576");
	}
	
	public void getUnsentSignageLog() {
		for (ContentReadingLogDto dto : dao.getUnendSignageLog()) {
			System.out.println(dto.contentId + "," + dto.startDate);;
		}
	}

}
