package jp.agentec.adf.net.http;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.io.File;

import jp.agentec.adf.net.http.HttpHeaderProperties;
import jp.agentec.adf.net.http.HttpHeaderProperties.PropertyKey;
import jp.agentec.adf.net.http.HttpMultipart;
import jp.agentec.adf.net.http.HttpParameterObject;
import jp.agentec.adf.net.http.HttpRequestSender;
import jp.agentec.adf.net.http.HttpResponse;
import jp.agentec.adf.util.StringUtil;

import org.junit.Test;

public class HttpRequestSenderTest {
	@Test
	public void testPost() {
		String url1 = "http://demo35.agtplus.kr/acms/agentec/abvapi/notifyBackupStart/?sid=41ffde706183225c4c3b6065f468d276&type=1&deviceType=3";
		String url2 = "http://demo35.agtplus.kr/acms/agentec/abvapi/notifyBackupFinish/?sid=41ffde706183225c4c3b6065f468d276&type=1&deviceType=3";
		String url = "http://demo35.agtplus.kr/acms/agentec/abvapi/uploadBackupFile/";
		//String url = "https://demo35.agtplus.kr/acms/agentec/abvapi/serviceOption/?sid=41ffde706183225c4c3b6065f468d276";
		
		HttpMultipart part1 = new HttpMultipart("sid", "41ffde706183225c4c3b6065f468d276");
		HttpMultipart part2 = new HttpMultipart("deviceType", "3");
		HttpMultipart part3 = new HttpMultipart("formFile", new File("c:\\Users\\macrojin\\Pictures\\3af78c-27504-c.jpg"));
		
		HttpHeaderProperties prop = new HttpHeaderProperties();
		prop.addProperty(PropertyKey.UserAgent, "Android");
		try {
			HttpResponse result1 = HttpRequestSender.post(url1, null, prop);
			System.out.println(result1.httpResponseBody);
			
			HttpResponse result = HttpRequestSender.post(url, prop, new HttpMultipart[] {part1, part2, part3});
			
//			AcmsParameters param = new AcmsParameters("41ffde706183225c4c3b6065f468d276");
//			HttpResponse result = HttpRequestSender.post(url, param, prop);
			System.out.println(result.httpResponseBody);
			
			HttpResponse result2 = HttpRequestSender.post(url2, null, prop);
			System.out.println(result2.httpResponseBody);
			
			assertTrue(true);
		} catch (Exception e) {
			e.printStackTrace();
			assertFalse(false);
		}
	}
	
//	@Test
//	public void testDownload() {
//		String url = "http://demo35.agtplus.kr/acms/agentec/abvapi/getBackupFile/";
//		
//		HttpMultipart part1 = new HttpMultipart("sid", "41ffde706183225c4c3b6065f468d276");
//		HttpMultipart part2 = new HttpMultipart("filename", "24x24-free-application-icons.png");
//		HttpMultipart part3 = new HttpMultipart("deviceType", "3");
//		
//		HttpHeaderProperties prop = new HttpHeaderProperties();
//		prop.addProperty(PropertyKey.UserAgent, "Android");
//		try {
//			HttpResponse result = HttpRequestSender.post(url, prop, new HttpMultipart[] {part1, part2, part3});
//			
//			FileOutputStream os = new FileOutputStream("c:\\Users\\macrojin\\Pictures\\dl.png");
//			
//			assertTrue(true);
//		} catch (Exception e) {
//			e.printStackTrace();
//			assertFalse(false);
//		}
//	}
	
	public class AcmsParameters extends HttpParameterObject {
		/**
		 * セッションID
		 * @since 1.0.0
		 */
		private String sid;
		
		/**
		 * {@link AcmsParameters} のインスタンスを初期化します。
		 * @param sid ログインした時のセッションIDです。
		 * @since 1.0.0
		 */
		public AcmsParameters(String sid) {
			this.sid = sid;
		}

		/**
		 * セッションIDを返します。
		 * @return ログインした時のセッションIDです。
		 * @since 1.0.0
		 */
		public String getSid() {
			return sid;
		}
	}

	public class MobileLoginParameters extends HttpParameterObject {
		private final String[] RegexAllowSymbols = new String[] {"-", "_"};

		/**
		 * ユーザのログインIDです。
		 * @since 1.0.0
		 */
		private String loginId;
		/**
		 * ユーザのパスワードです。
		 * @since 1.0.0
		 */
		private String password;
		/**
		 * 端末の一意IDです。
		 * @since 1.0.0
		 */
		private String udid;
		/**
		 * {@link MobileLoginParameters} クラスのインスタンスを初期化します。
		 * @param loginId ユーザのログインIDです。半角英数字と'_'、'-'のみ使えます。
		 * @param password ユーザのパスワードです。半角英数字と'_'、'-'のみ使えます。
		 * @param udid 端末の一意IDです。半角英数字と'_'、'-'のみ使えます。
		 * @throws 引数のどれかが半角英数字と'_'、'-'ではありません。
		 * @since 1.0.0
		 */
		public MobileLoginParameters(String loginId, String memberPassword, String udid) throws IllegalArgumentException {
			if (!StringUtil.isHankaku(loginId, true, true, RegexAllowSymbols)) {
				throw new IllegalArgumentException("argument loginId must be hankaku, '_' or '-'");
			}

			if (!StringUtil.isHankaku(memberPassword, true, true, RegexAllowSymbols)) {
				throw new IllegalArgumentException("password loginId must be hankaku, '_' or '-'");
			}

			if (!StringUtil.isHankaku(udid, true, true, RegexAllowSymbols)) {
				throw new IllegalArgumentException("udid loginId must be hankaku, '_' or '-'");
			}

			this.loginId = loginId;
			this.password = memberPassword;
			this.udid = udid;
		}
		/**
		 *  ユーザのログインIDを指定します。
		 * @return ユーザのログインIDです。
		 * @since 1.0.0
		 */
		public String getLoginId() {
			return loginId;
		}
		/**
		 * ユーザのパスワードを取得します。
		 * @return ユーザのパスワードです。
		 * @since 1.0.0
		 */
		public String getPassword() {
			return password;
		}
		/**
		 * 端末の一意IDを取得します。
		 * @return 端末の一意IDです。
		 * @since 1.0.0
		 */
		public String getUdid() {
			return udid;
		}
	}
}
