package jp.agentec.abook.abv.bl.common.db.impl;

import android.database.SQLException;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.db.SQLiteStatement;
import jp.agentec.abook.abv.bl.common.log.Logger;

public class StandardSQLiteDatabase implements SQLiteDatabase {
	private android.database.sqlite.SQLiteDatabase db;

	public StandardSQLiteDatabase(android.database.sqlite.SQLiteDatabase db) {
		this.db = db;
	}

	@Override
	public void beginTransaction() {
		db.beginTransaction();
	}

	@Override
	public void endTransaction() {
		db.endTransaction();
	}

	@Override
	public void setTransactionSuccessful() {
		db.setTransactionSuccessful();
	}

	@Override
	public boolean inTransaction() {
		return db.inTransaction();
	}

	@Override
	public void close() {
		db.close();
	}

	@Override
	public jp.agentec.abook.abv.bl.common.db.Cursor query(String table, String[] columns, String selection,
			String[] selectionArgs, String groupBy, String having,
			String orderBy) {
		return new StandardCursor(db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy));
	}

	@Override
	public jp.agentec.abook.abv.bl.common.db.Cursor query(String table, String[] columns, String selection,
			String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
		return new StandardCursor(db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit));
	}

	@Override
	public jp.agentec.abook.abv.bl.common.db.Cursor rawQuery(String sql, String[] selectionArgs) {
		return new StandardCursor(db.rawQuery(sql, selectionArgs));
	}

	@Override
	public int delete(String table, String whereClause, String[] whereArgs) {
		return db.delete(table, whereClause, whereArgs);
	}

	@Override
	public void execSQL(String sql) {
        try {
            db.execSQL(sql);
        } catch (SQLException e) {
            String message = e.getMessage();
            if (message != null && message.contains("duplicate column")) {
                // 1.7.6.5のバグ改修の際に、SQLExceptionが回避できない場合がある
                // 詳細は以下のチケットで確認
                // https://redmine.agentec.jp/redmine/issues/23374
                Logger.i("StandardSQLiteDatabase", message + ".");
            }
        }
	}

	@Override
	public void execSQL(String sql, Object[] bindArgs) {
		db.execSQL(sql, bindArgs);
	}

	@Override
	public boolean isOpen() {
		return db.isOpen();
	}

	@Override
	public boolean needUpgrade(int newVersion) {
		return db.needUpgrade(newVersion);
	}

	@Override
	public SQLiteStatement compileStatement(String sql) {
		return new StandardSQLiteStatement(db.compileStatement(sql));
	}
	
	@Override
	public Cursor query(boolean distinct, String table, String[] columns,
			String selection, String[] selectionArgs, String groupBy,
			String having, String orderBy, String limit) {
		return new StandardCursor(db.query(distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit));
	}

	@Override
	public String getPath() {
		return db.getPath();
	}

	@Override
	public int getVersion() {
		return db.getVersion();
	}

}
