package jp.agentec.abook.abv.launcher.android;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.adf.util.StringUtil;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;

public class LogFileProvider extends ContentProvider {
	private static final String TAG = "LogFileProvider";
	//public static String authorities = "content://jp.agentec.abook.abv.cl.provider.logfileprovider"; 
	public static Date expired;
	
	// ファイルの取得
	@Override
	public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
		if (expired == null || expired.before(new Date())) { // セキュリティのため期限を設ける
			Logger.d(TAG, "expired.");
			return null;
		}

        if (getContext() != null && StringUtil.contains(uri.getLastPathSegment(), new String[]{ABVEnvironment.LogZipExportName, ABVEnvironment.LogUncaughtErrorEncName})) {
            File file = new File(getContext().getCacheDir().getAbsolutePath() + "/" + uri.getLastPathSegment());
            Logger.i(TAG, "url: " + uri + " exists=" + file.exists());

            ParcelFileDescriptor parcel = ParcelFileDescriptor.open(file, ParcelFileDescriptor.MODE_READ_ONLY);
            return parcel;
        }
        return null;
    }

    // 未使用
	@Override
	public int delete(Uri uri, String s, String[] as) {
		return 0;
	}

	// 未使用
	@Override
	public String getType(Uri uri) {
		return null;
	}

	// 未使用
	@Override
	public Uri insert(Uri uri, ContentValues contentvalues) {
		return null;
	}

	// 未使用
	@Override
	public boolean onCreate() {
		return true;
	}

	// 未使用
	@Override
	public Cursor query(Uri uri, String[] as, String s, String[] as1, String s1) {
		return null;
	}

	// 未使用
	@Override
	public int update(Uri uri, ContentValues contentvalues, String s, String[] as) {
		return 0;
	}
}
