package jp.agentec.abook.abv.ui.common.util;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.ui.common.vo.Size;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;

public class DisplayUtil {

	/**
	 * Gets the size of the display, in pixels. 
	 * @param context
	 * @return {@link Point} x:width y:height
	 */
	public static Point getDisplaySize(Context context) {
		WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		int displayWidth;
		int displayHeight;

		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
			WindowMetrics metrics = wm.getCurrentWindowMetrics();
			Rect bounds = metrics.getBounds();

			WindowInsets windowInsets = metrics.getWindowInsets();
			android.graphics.Insets insets = windowInsets.getInsets(
					WindowInsets.Type.navigationBars() | WindowInsets.Type.displayCutout()
			);

			displayWidth = bounds.width() - (insets.left + insets.right);
			displayHeight = bounds.height() - (insets.top + insets.bottom);
		} else {
			Display display = wm.getDefaultDisplay();
			Point size = new Point();
			display.getSize(size);
			displayWidth = size.x;
			displayHeight = size.y;
		}

		return new Point(displayWidth, displayHeight);

	}
	
	public static Size getDisplaySize2(Context context) {
		Point point = getDisplaySize(context);
		int displayWidth = point.x;
		int displayHeight = point.y;
//		Logger.v(TAG, "Version=" + Build.VERSION.SDK_INT + "displayHeight=" + displayHeight);
		// **バグ対応 メニューバーの高さ(48)を調節する **//
		if (Build.VERSION.SDK_INT == 12 || Build.VERSION.SDK_INT == 11) { // Version 3.1 or 3.0
			displayHeight = displayHeight - 48;
			Logger.v("DisplayUtil", "edit displayHeight=%s", displayHeight);
		}
		return new Size(displayWidth, displayHeight);
	}
	
	/**
	 * フルスクリーン表示の場合のサイズを取得する
	 * 
	 * @param context
	 * @return
	 */
	public static Size getDisplaySizeForFull(Context context) {
		WindowManager w = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		Display d = w.getDefaultDisplay();
		DisplayMetrics metrics = new DisplayMetrics();
		d.getMetrics(metrics);
		
		// since SDK_INT = 1;
		int width = metrics.widthPixels;
		int height = metrics.heightPixels;
		
		// includes window decorations (statusbar bar/menu bar)
		if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
			try {
				width = (Integer) Display.class.getMethod("getRawWidth").invoke(d);
				height = (Integer) Display.class.getMethod("getRawHeight").invoke(d);
			} catch (Exception ignored) {
			}
		}
		
		// includes window decorations (statusbar bar/menu bar)
		if (Build.VERSION.SDK_INT >= 17) {
			try {
				Point realSize = new Point();
				Display.class.getMethod("getRealSize", Point.class).invoke(d, realSize);
				width = realSize.x;
				height = realSize.y;
			} catch (Exception ignored) {
			}
		}
		
		return new Size(width, height);
	}
	

}
