package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.os.AsyncTask;

import com.theta.network.HttpConnector;
import com.theta.view.MJpegInputStream;

import org.json.JSONException;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaCameraActivity;

/**
 * THETAカメラライブ映像取得スレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class ShowLiveViewTask extends AsyncTask<Void, String, MJpegInputStream> {
    private static final String TAG = "ShowLiveViewTask";
    private static final int FAIL_RETRAY_DELAY_MILLIS = 1000;
    private final WeakReference<ThetaCameraActivity> refActivity;

    public ShowLiveViewTask(ThetaCameraActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected MJpegInputStream doInBackground(Void... params) {
        Logger.d(TAG, "doInBackground");
        MJpegInputStream mjis = null;
        final int MAX_RETRY_COUNT = 5;
        for (int retryCount = 0; retryCount < MAX_RETRY_COUNT; retryCount++) {
            try {
                boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(), ABookKeys.THETA_OLD_VERSION_FLG, false);
                HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
                InputStream is = camera.getLivePreview();
                mjis = new MJpegInputStream(is);
                //正常にライブ再生されるか確認
                mjis.readMJpegFrame();

                retryCount = MAX_RETRY_COUNT;
            } catch (IOException e) {
                Logger.e(TAG,"doInBackground fail e = " + e.toString());
                if (mjis != null) {
                    try {
                        mjis.close();
                    } catch (IOException ex) {
                        Logger.e(TAG, "doInBackground fail ex = " + ex.toString());
                    }
                }

                try {
                    Thread.sleep(FAIL_RETRAY_DELAY_MILLIS);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            } catch (JSONException e) {
                try {
                    Thread.sleep(FAIL_RETRAY_DELAY_MILLIS);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }

        return mjis;
    }

    @Override
    protected void onProgressUpdate(String... values) {
        for (String log : values) {
            Logger.d(TAG, log);
        }
    }

    @Override
    protected void onPostExecute(MJpegInputStream mJpegInputStream) {
        Logger.d(TAG, "onPostExecute");
        ThetaCameraActivity activity = refActivity.get();
        activity.showLiveViewTaskFinish(mJpegInputStream);
    }
}
