package jp.agentec.abook.abv.ui.viewer.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ContentPageDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContentLogic;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.viewer.foxitPdf.PdfThumbnailProvider;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ContentSearchPageAdapter extends BaseAdapter {
	private static final String TAG = "ContentSearchPageAdapter";
	Context context;
	LayoutInflater inflater;
	List<ContentPageDto> listItem;
	private PdfThumbnailProvider pdfThumbnailProvider;

	public ContentSearchPageAdapter(Context context, long contentId, String searchKeyword, PdfThumbnailProvider pdfThumbnailProvider) throws IOException {
		this.context = context;
		this.pdfThumbnailProvider = pdfThumbnailProvider;
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		listItem = new ArrayList<>();
		ContentLogic contentLogic = AbstractLogic.getLogic(ContentLogic.class);
		listItem = contentLogic.getContentPage(contentId, searchKeyword);
		Logger.v("ABVSearchPageAdapter", "search:listItem=%s", listItem);
	}

	@Override
    public int getCount() {
		return listItem.size();
	}

	@Override
    public long getItemId(int position) {
		return listItem.get(position).contentId;
	}

	@Override
    public View getView(int position, View convertView, ViewGroup parent) {
		if (null == convertView) {
			convertView = inflater.inflate(R.layout.bookmark_render, null);
		}
		
		//setStripeColor(context, convertView, position);
		
		final ContentPageDto dto = listItem.get(position);

		ImageView image = (ImageView) convertView.findViewById(R.id.img_main);
		Logger.d("ABVSearchPageAdapter", "getView:1");
		try {
			image.setImageBitmap(pdfThumbnailProvider.getThumbnail(dto.pageNum - 1, false));
		} catch (Exception e) {
			Logger.e(TAG, "PdfThumbnailProvider", e);
			ErrorMessage.showErrorMessageToast(context.getApplicationContext(), ErrorCode.E107);
		}
		image.setAdjustViewBounds(true);
		image.setScaleType(ImageView.ScaleType.FIT_CENTER);
		image.setPadding(0, 0, 1, 1);
		GradientDrawable g = new GradientDrawable(GradientDrawable.Orientation.TL_BR, new int[] { Color.WHITE, Color.WHITE, R.color.background });
		//noinspection deprecation(API16から非推奨になった。無視)
		image.setBackgroundDrawable(g);

		TextView pageNum = (TextView) convertView.findViewById(R.id.num_page);
		pageNum.setText("Page：" + dto.pageNum);

		TextView pageText = (TextView) convertView.findViewById(R.id.txt_page);
		pageText.setText("..." + dto.searchResult + "...");

		return convertView;
	}

	@Override
    public ContentPageDto getItem(int position) {
		return listItem.get(position);
	}
}
