package jp.agentec.abook.abv.ui.viewer.view;

import jp.agentec.abook.abv.launcher.android.R;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;

/***********************************************************************
 * メモアイコン   クラス
 ***********************************************************************/
public class ActionMemoIcon extends ImageView {
	
	public String memoId;
	
	public ActionMemoIcon(final Context context) {
		super(context);
    	setImageResource(R.drawable.memo_icon);
		setBackgroundColor(Color.TRANSPARENT);
		setAdjustViewBounds(true);
		setScaleType(ScaleType.FIT_START);
	}
	
	
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		Drawable d = getDrawable().mutate();
		if (enabled) {
			d.setAlpha(255);
		} else {
			d.setAlpha(70);
		}
		invalidate();
	}
	
}
