package jp.odakyu.toiletsignage.activity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import jp.odakyu.toiletsignage.application.ToiletApplication;
import jp.odakyu.toiletsignage.constants.ToiletConstants;
import jp.odakyu.toiletsignage.info.ToiletInfo;
import jp.odakyu.toiletsignage.log.Logger;

/**
 * Created by agentec on 2017/12/11.
 */

public class ParentActivity extends AppCompatActivity {
    private static final String TAG = "ParentActivity";

    ToiletInfo toiletInfo;
    private BroadcastReceiver broadcastReceiver;
    private boolean isRunning;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //横画面
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

        //ステータスバー非表示
        Window window = getWindow();
        View view = window.getDecorView();
        view.setSystemUiVisibility(
                View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY |
                        View.SYSTEM_UI_FLAG_HIDE_NAVIGATION |
                        View.SYSTEM_UI_FLAG_FULLSCREEN);

        toiletInfo = ToiletInfo.getInstance();

        //BroadcastReceiver設定
        IntentFilter filter = new IntentFilter(ToiletInfo.NAME_CONNTENT_FINISH);
        broadcastReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                //Main ActivityとSignage Activityが両方生きている時の対策で表示しているActivityのみ実行
                if (isRunning) {
                    boolean isNetworkConnect = intent.getBooleanExtra(ToiletConstants.KEY_NETWORK_CONNECT,false);
                    int errorCount = intent.getIntExtra(ToiletConstants.KEY_ERROR_COUNT, -1);
                    Logger.i(TAG, "isNetworkConnect = " + isNetworkConnect + ", errorCount = " + errorCount);
                    reloadDisplayView(errorCount, isNetworkConnect);
                }
            }
        };
        registerReceiver(broadcastReceiver, filter);

        //強制的にスリーブさせない処理追加
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
    }

    @Override
    public void finish() {
        super.finish();
        unregisterReceiver(broadcastReceiver);
    }

    @Override
    protected void onStop() {
        super.onStop();
        ToiletApplication application = (ToiletApplication) getApplication();
        //アプリがバックグラウンドのなった時のみタスクを停止
        if (!application.isForeground(this)) {
            Logger.i(TAG, "Application Background");
            application.stopTimer();
        }

    }

    @Override
    protected void onStart() {
        super.onStart();
        ToiletApplication application = (ToiletApplication) getApplication();
        //初回起動時以外はタスク開始（バックグラウンドからフォアグラウンド対応）
        if (toiletInfo.getToiletDefaultJsonArray() != null) {
            application.startTimer();
        }
    }

    @Override
    protected void onResume() {
        isRunning = true;
        super.onResume();
    }

    @Override
    protected void onPause() {
        isRunning = false;
        super.onPause();
    }

    //Child Classから実装
    protected void reloadDisplayView(final int errorCount, final boolean isNetworkConnect) {}
}
