package jp.odakyu.toiletsignage.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.Gravity;
import android.widget.ImageView;
import android.widget.TextView;
import android.graphics.Typeface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.odakyu.toiletsignage.R;
import jp.odakyu.toiletsignage.constants.ToiletConstants;
import jp.odakyu.toiletsignage.info.ToiletInfo;
import jp.odakyu.toiletsignage.json.ResultToiletJson;
import jp.odakyu.toiletsignage.json.USBToiletDefaultJson;
import jp.odakyu.toiletsignage.log.Logger;

/**
 * Created by agentec on 2017/11/30.
 */

public class SignageActivity extends ParentActivity {
    private static final String TAG = "SignageActivity";

    private TextView vacantCountTextView;
    private TextView totalCountTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (toiletInfo.getToiletGateType() == ToiletConstants.VALUE_TOILET_GATE_TYPE_1) {
            setContentView(R.layout.activity_signage_1);
        } else if (toiletInfo.getToiletGateType() == ToiletConstants.VALUE_TOILET_GATE_TYPE_3) {
            setContentView(R.layout.activity_signage_3);
        } else { //USBから取得したトイレ情報がない場合
            //強制にエラーカウント１設定
            moveMainView(1, true);
            return;
        }

        settingInitDisplay();
        settingFontFamily();
    }

    private void settingInitDisplay() {
        ImageView sexualityIconImageView = findViewById(R.id.sexualityIconImageView);
        vacantCountTextView = findViewById(R.id.vacantCountTextView);
        totalCountTextView = findViewById(R.id.totalCountTextView);

        if (toiletInfo.getToiletGateType() == ToiletConstants.VALUE_TOILET_GATE_TYPE_3) {

            //お近くのトイレ情報設定
            TextView leftGateNameJPTextView = findViewById(R.id.leftGateNameJPTextView);
            TextView leftGateNameENTextView = findViewById(R.id.leftGateNameENTextView);
            TextView rightGateNameJPTextView = findViewById(R.id.rightGateNameJPTextView);
            TextView rightGateNameENTextView = findViewById(R.id.rightGateNameENTextView);

            for (USBToiletDefaultJson toiletDefaultJson:
            toiletInfo.getToiletDefaultJsonArray()) {
                if (toiletDefaultJson.getPriority() == ToiletInfo.VALUE_PRIORITY_SUB_LEFT) {
                    leftGateNameJPTextView.setText(toiletDefaultJson.getToiletNameJP());
                    leftGateNameENTextView.setText(toiletDefaultJson.getToiletNameEN());

                } else if (toiletDefaultJson.getPriority() == ToiletInfo.VALUE_PRIORITY_SUB_RIGHT) {
                    rightGateNameJPTextView.setText(toiletDefaultJson.getToiletNameJP());
                    rightGateNameENTextView.setText(toiletDefaultJson.getToiletNameEN());
                }
            }
        }

        int toiletSex = toiletInfo.getToiletSex();

        if (toiletInfo.getToiletGateType() == ToiletConstants.VALUE_TOILET_GATE_TYPE_3) {
            if (toiletSex == ToiletInfo.VALUE_SEX_MAN) {
                sexualityIconImageView.setImageResource(R.drawable.icon_man_3);
            } else {
                sexualityIconImageView.setImageResource(R.drawable.icon_woman_3);
            }
        } else {
            if (toiletSex == ToiletInfo.VALUE_SEX_MAN) {
                sexualityIconImageView.setImageResource(R.drawable.icon_man_1);
            } else {
                sexualityIconImageView.setImageResource(R.drawable.icon_woman_1);
            }
        }
        settingDisplay();
    }

    /**
     * ビューで表示するすべてのTextViewのフォント情報を変更
     */
    private void settingFontFamily() {
        Map<Integer, String> textViewFontInfoMap = new HashMap<>();
        textViewFontInfoMap.put(R.id.mainTitleJPTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
        textViewFontInfoMap.put(R.id.mainTitleENTextView, ToiletConstants.MEIRIO_FONT_NAME);
        textViewFontInfoMap.put(R.id.vacantTitleJPTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
        textViewFontInfoMap.put(R.id.vacantTitleENTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
        textViewFontInfoMap.put(R.id.vacantCountTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
        textViewFontInfoMap.put(R.id.totalTitleJPTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
        textViewFontInfoMap.put(R.id.totalTitleENTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
        textViewFontInfoMap.put(R.id.totalCountTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);

        if (toiletInfo.getToiletGateType() == ToiletConstants.VALUE_TOILET_GATE_TYPE_3) {
            textViewFontInfoMap.put(R.id.subTitleJPTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
            textViewFontInfoMap.put(R.id.subTitleENTextView, ToiletConstants.MEIRIO_FONT_NAME);
            textViewFontInfoMap.put(R.id.leftGateNameJPTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
            textViewFontInfoMap.put(R.id.leftGateNameENTextView, ToiletConstants.MEIRIO_FONT_NAME);
            textViewFontInfoMap.put(R.id.rightGateNameJPTextView, ToiletConstants.MEIRIO_BOLD_FONT_NAME);
            textViewFontInfoMap.put(R.id.rightGateNameENTextView, ToiletConstants.MEIRIO_FONT_NAME);
        }

        for(Map.Entry<Integer, String> entry : textViewFontInfoMap.entrySet()) {
            TextView textView = findViewById(entry.getKey());

            //空き数と総数の数字表示が真ん中ではないので調整
            if (entry.getKey() == R.id.vacantCountTextView || entry.getKey() == R.id.totalCountTextView) {
                textView.setPadding(0, 10, 0, 0);
                textView.setGravity(Gravity.CENTER);
            }
            textView.setTypeface(Typeface.createFromAsset(getAssets(), entry.getValue()));
        }
    }

    /**
     * 10秒ごとに実行するトイレ情報取得タスクから、結果を送信する
     * @param errorCount サーバ通信タスクからの情報で、取得失敗カウント
     * @param isNetworkConnect インターネット接続情報
     */
    @Override
    protected void reloadDisplayView(final int errorCount, final boolean isNetworkConnect) {
        Logger.i(TAG, "reloadDisplayView");
        //バックグラウンドスレッドからメーイン
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (errorCount > ToiletInfo.MAX_ERROR_COUNT) {
                    //サーバ側から取得したトイレ情報削除
                    toiletInfo.clearResultToiletJsonMap();
                    moveMainView(errorCount, isNetworkConnect);
                } else {
                    if (errorCount == 0) {
                        settingDisplay();
                    }
                }
            }
        });
    }

    private void moveMainView(int errorCount, boolean isNetworkConnect) {
        Intent intent = new Intent(SignageActivity.this, MainActivity.class);
        intent.putExtra(ToiletConstants.KEY_ERROR_COUNT, errorCount);
        intent.putExtra(ToiletConstants.KEY_NETWORK_CONNECT, isNetworkConnect);
        startActivity(intent);
        finish();
    }

    private void settingDisplay() {
        ArrayList<USBToiletDefaultJson> toiletDefaultJsonArray = toiletInfo.getToiletDefaultJsonArray();

        if (toiletDefaultJsonArray == null || toiletDefaultJsonArray.size() == 0) {
            //MainActivity 移動(強制にエラーカウント１)
            moveMainView(1, true);
        }

        int vacantCount = 0;
        int totalCount = 0;
        for (USBToiletDefaultJson toiletDefaultJson:
                toiletDefaultJsonArray) {
            ArrayList<ResultToiletJson> resultToiletJson = toiletInfo.getResultToiletJsonMap(toiletDefaultJson.getToiletId());
            vacantCount = toiletInfo.getVacantCount(toiletDefaultJson.getToiletId());
            totalCount = toiletInfo.getTotalCount(toiletDefaultJson.getToiletId());
            if (toiletDefaultJson.getPriority() == ToiletInfo.VALUE_PRIORITY_MAIN) { //開設トイレ
                if (vacantCount == -1) {
                    //取得失敗
                    continue;
                }
                vacantCountTextView.setText(String.valueOf(vacantCount));
                totalCountTextView.setText(String.valueOf(totalCount));
                ImageView statusIconImageView = findViewById(R.id.statusIconImageView);
                if (toiletInfo.getToiletGateType() == ToiletConstants.VALUE_TOILET_GATE_TYPE_3) {
                    if (vacantCount == 0) {
                        statusIconImageView.setImageResource(R.drawable.icon_full_3);
                    } else {
                        statusIconImageView.setImageResource(R.drawable.icon_empty_3);
                    }
                } else {
                    if (vacantCount == 0) {
                        statusIconImageView.setImageResource(R.drawable.icon_full_1);
                    } else {
                        statusIconImageView.setImageResource(R.drawable.icon_empty_1);

                    }
                }
            } else if (toiletDefaultJson.getPriority() == ToiletInfo.VALUE_PRIORITY_SUB_LEFT) { //お近くトイレ（左側）
                ImageView leftStatusIconImageView = findViewById(R.id.leftStatusIconImageView);
                if (vacantCount == 0) {
                    leftStatusIconImageView.setImageResource(R.drawable.icon_full_sub);
                } else {
                    leftStatusIconImageView.setImageResource(R.drawable.icon_empty_sub);
                }
            } else if (toiletDefaultJson.getPriority() == ToiletInfo.VALUE_PRIORITY_SUB_RIGHT) { //お近くトイレ（左側）
                ImageView rightStatusIconImageView = findViewById(R.id.rightStatusIconImageView);
                if (vacantCount == 0) {
                    rightStatusIconImageView.setImageResource(R.drawable.icon_full_sub);
                } else {
                    rightStatusIconImageView.setImageResource(R.drawable.icon_empty_sub);
                }
            }
        }

        //サーバから取得したデータが不正なのでMainに遷移
        if (vacantCount == -1 || totalCount == -1) {
            //強制にエラーカウント１設定
            moveMainView(1, true);
        }
    }
}
