package jp.odakyu.toiletsignage.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.odakyu.toiletsignage.constants.ToiletConstants;
import jp.odakyu.toiletsignage.json.ResultToiletJson;
import jp.odakyu.toiletsignage.json.USBToiletDefaultJson;

/**
 * Created by agentec on 2017/12/11.
 */

public class ToiletInfo {
    private static ToiletInfo instance = null;

    public static final String NAME_CONNTENT_FINISH = "jp.odakyu.toiletsignage.CONNECT_FINISH";
    public static final int VALUE_SEX_MAN = 0;
    public static final int VALUE_SEX_WOMAN = 1;

    public static final int VALUE_PRIORITY_MAIN = 0;
    public static final int VALUE_PRIORITY_SUB_LEFT = 1;
    public static final int VALUE_PRIORITY_SUB_RIGHT = 2;

    public static final int VALUE_DEFAULT_TOILET_NULL = 0;
    public static final int VALUE_DEFAULT_TOILET_VALIDATION_FAIL = 1;
    public static final int VALUE_NETWORK_DIS_CONNECT = 2;
    public static final int VALUE_TOILET_SERVER_CONNECT_FAIL = 3;

    public static final int MAX_ERROR_COUNT = 5;

    private ArrayList<USBToiletDefaultJson> mToiletDefaultJsonArray;
    private Map<Integer, ArrayList<ResultToiletJson>> mResultToiletJsonMap = new HashMap<>();
    private boolean isUsbFileCopyComplete = false;

    public static synchronized ToiletInfo getInstance() {
        if (instance == null) {
            instance = new ToiletInfo();
        }
        return instance;
    }

    public void setToiletDefaultJsonArray(ArrayList<USBToiletDefaultJson> defaultToiletJsonArray) {
        mToiletDefaultJsonArray = defaultToiletJsonArray;
    }

    public ArrayList<USBToiletDefaultJson> getToiletDefaultJsonArray() {
        return mToiletDefaultJsonArray;
    }

    public void setResultToiletJsonMap(int toiletId, ArrayList<ResultToiletJson> resultToiletJsonMap) {
        mResultToiletJsonMap.put(toiletId, resultToiletJsonMap);
    }

    public ArrayList<ResultToiletJson> getResultToiletJsonMap(int toiletId) {
        return mResultToiletJsonMap.get(toiletId);
    }

    public int getResultToiletJsonMapSize() {
        return mResultToiletJsonMap.size();
    }

    public void clearResultToiletJsonMap() {
        mResultToiletJsonMap.clear();
    }

    public int getToiletSex() {
        if (mToiletDefaultJsonArray != null && mToiletDefaultJsonArray.size() > 0) {
            USBToiletDefaultJson toiletDefaultJson = mToiletDefaultJsonArray.get(0);
            return toiletDefaultJson.getToiletSex();
        }
        return -1;
    }

    public int getVacantCount(int toiletId) {
        if (mResultToiletJsonMap.size() > 0) {
            ArrayList<ResultToiletJson> resultToiletJsonArray = getResultToiletJsonMap(toiletId);
            int vacantCount = 0;
            for (ResultToiletJson resultToiletJson:resultToiletJsonArray) {
                if (resultToiletJson.getStatus().equals(ResultToiletJson.VALUE_STATUS_OPEN)) {
                    vacantCount++;
                }
            }
            return vacantCount;
        }
        return -1;
    }

    public int getTotalCount(int toiletId) {
        if (mResultToiletJsonMap.size() > 0) {
            ArrayList<ResultToiletJson> resultToiletJsonArray = getResultToiletJsonMap(toiletId);
            return resultToiletJsonArray.size();
        }
        return -1;
    }

    public void setUsbFileCopyComplete(boolean usbFileCopyComplete) {
        isUsbFileCopyComplete = usbFileCopyComplete;
    }

    public boolean getUsbFileCopyComplete() {
        return isUsbFileCopyComplete;
    }

    public int getToiletGateType() {
        if (mToiletDefaultJsonArray == null) {
            return ToiletConstants.VALUE_TOILET_GATE_TYPE_0;
        }
        return mToiletDefaultJsonArray.size();
    }
}
